/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.FoldingRegionWindow;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import java.awt.Point;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class FoldingModelWindow
implements FoldingModelEx {
    private final FoldingModelEx myDelegate;
    private final DocumentWindow myDocumentWindow;
    private final EditorWindow myEditorWindow;
    private static final Key<FoldingRegionWindow> FOLD_REGION_WINDOW = Key.create((String)"FOLD_REGION_WINDOW");

    public FoldingModelWindow(@NotNull FoldingModelEx delegate, @NotNull DocumentWindow documentWindow, @NotNull EditorWindow editorWindow) {
        if (delegate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/FoldingModelWindow.<init> must not be null");
        }
        if (documentWindow == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/injected/editor/FoldingModelWindow.<init> must not be null");
        }
        if (editorWindow == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/injected/editor/FoldingModelWindow.<init> must not be null");
        }
        this.myDelegate = delegate;
        this.myDocumentWindow = documentWindow;
        this.myEditorWindow = editorWindow;
    }

    @Override
    public void setFoldingEnabled(boolean isEnabled) {
        this.myDelegate.setFoldingEnabled(isEnabled);
    }

    @Override
    public boolean isFoldingEnabled() {
        return this.myDelegate.isFoldingEnabled();
    }

    @Override
    public FoldRegion getFoldingPlaceholderAt(Point p) {
        return this.myDelegate.getFoldingPlaceholderAt(p);
    }

    @Override
    public FoldRegion[] getAllFoldRegionsIncludingInvalid() {
        FoldRegion[] all = this.myDelegate.getAllFoldRegionsIncludingInvalid();
        ArrayList<FoldingRegionWindow> result = new ArrayList<FoldingRegionWindow>();
        for (FoldRegion region : all) {
            FoldingRegionWindow window = (FoldingRegionWindow)region.getUserData(FOLD_REGION_WINDOW);
            if (window == null || window.getEditor() != this.myEditorWindow) continue;
            result.add(window);
        }
        return result.toArray(new FoldRegion[result.size()]);
    }

    @Override
    public boolean intersectsRegion(int startOffset, int endOffset) {
        int hostStart = this.myDocumentWindow.injectedToHost(startOffset);
        int hostEnd = this.myDocumentWindow.injectedToHost(endOffset);
        return this.myDelegate.intersectsRegion(hostStart, hostEnd);
    }

    public FoldRegion addFoldRegion(int startOffset, int endOffset, @NotNull String placeholderText) {
        if (placeholderText == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/injected/editor/FoldingModelWindow.addFoldRegion must not be null");
        }
        FoldRegion region = this.createFoldRegion(startOffset, endOffset, placeholderText, null);
        return this.addFoldRegion(region) ? region : null;
    }

    public boolean addFoldRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/FoldingModelWindow.addFoldRegion must not be null");
        }
        return this.myDelegate.addFoldRegion(((FoldingRegionWindow)region).getDelegate());
    }

    public void removeFoldRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/FoldingModelWindow.removeFoldRegion must not be null");
        }
        this.myDelegate.removeFoldRegion(((FoldingRegionWindow)region).getDelegate());
    }

    @NotNull
    public FoldRegion[] getAllFoldRegions() {
        FoldRegion[] all = this.myDelegate.getAllFoldRegions();
        ArrayList<FoldingRegionWindow> result = new ArrayList<FoldingRegionWindow>();
        for (FoldRegion region : all) {
            FoldingRegionWindow window = (FoldingRegionWindow)region.getUserData(FOLD_REGION_WINDOW);
            if (window == null || window.getEditor() != this.myEditorWindow) continue;
            result.add(window);
        }
        FoldRegion[] foldRegionArray = result.toArray(new FoldRegion[result.size()]);
        if (foldRegionArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/FoldingModelWindow.getAllFoldRegions must not return null");
        }
        return foldRegionArray;
    }

    public boolean isOffsetCollapsed(int offset) {
        return this.myDelegate.isOffsetCollapsed(this.myDocumentWindow.injectedToHost(offset));
    }

    public FoldRegion getCollapsedRegionAtOffset(int offset) {
        FoldRegion host = this.myDelegate.getCollapsedRegionAtOffset(this.myDocumentWindow.injectedToHost(offset));
        return host;
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/FoldingModelWindow.runBatchFoldingOperation must not be null");
        }
        this.myDelegate.runBatchFoldingOperation(operation);
    }

    public void runBatchFoldingOperationDoNotCollapseCaret(@NotNull Runnable operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/FoldingModelWindow.runBatchFoldingOperationDoNotCollapseCaret must not be null");
        }
        this.myDelegate.runBatchFoldingOperationDoNotCollapseCaret(operation);
    }

    @Override
    public FoldRegion fetchOutermost(int offset) {
        FoldRegion host = this.myDelegate.fetchOutermost(this.myDocumentWindow.injectedToHost(offset));
        return host;
    }

    @Override
    public int getLastCollapsedRegionBefore(int offset) {
        return -1;
    }

    @Override
    public TextAttributes getPlaceholderAttributes() {
        return this.myDelegate.getPlaceholderAttributes();
    }

    @Override
    public FoldRegion[] fetchTopLevel() {
        return FoldRegion.EMPTY_ARRAY;
    }

    @Override
    public FoldRegion createFoldRegion(int startOffset, int endOffset, @NotNull String placeholder, FoldingGroup group) {
        if (placeholder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/injected/editor/FoldingModelWindow.createFoldRegion must not be null");
        }
        FoldRegion hostRegion = this.myDelegate.createFoldRegion(this.myDocumentWindow.injectedToHost(startOffset), this.myDocumentWindow.injectedToHost(endOffset), placeholder, group);
        FoldingRegionWindow window = new FoldingRegionWindow(this.myDocumentWindow, this.myEditorWindow, (FoldRegionImpl)hostRegion);
        hostRegion.putUserData(FOLD_REGION_WINDOW, (Object)window);
        return window;
    }
}

