/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.BaseHtmlLexer;
import com.intellij.lexer.EmbedmentLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.lexer._HtmlLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.Nullable;

public class HtmlHighlightingLexer
extends BaseHtmlLexer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lexer.HtmlHighlightingLexer");
    private static final int EMBEDDED_LEXER_ON = 2048;
    private static final int EMBEDDED_LEXER_STATE_SHIFT = 12;
    private Lexer embeddedLexer;
    private Lexer styleLexer;
    private Lexer scriptLexer;
    protected Lexer elLexer;
    private boolean hasNoEmbeddments;
    private static FileType ourStyleFileType;
    private static FileType ourScriptFileType;

    public HtmlHighlightingLexer() {
        this((Lexer)new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)new _HtmlLexer()), TOKENS_TO_MERGE), true);
    }

    protected HtmlHighlightingLexer(Lexer lexer, boolean caseInsensitive) {
        super(lexer, caseInsensitive);
        XmlEmbeddmentHandler value = new XmlEmbeddmentHandler();
        this.registerHandler(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, value);
        this.registerHandler(XmlTokenType.XML_DATA_CHARACTERS, value);
        this.registerHandler(XmlTokenType.XML_COMMENT_CHARACTERS, value);
    }

    @Override
    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        super.start(buffer, startOffset, endOffset, initialState);
        if ((initialState & 0x800) != 0) {
            int state = initialState >> 12;
            this.setEmbeddedLexer();
            LOG.assertTrue(this.embeddedLexer != null);
            this.embeddedLexer.start(buffer, startOffset, this.skipToTheEndOfTheEmbeddment(), state);
        } else {
            this.embeddedLexer = null;
        }
    }

    private void setEmbeddedLexer() {
        Lexer newLexer = null;
        if (this.hasSeenStyle()) {
            if (this.styleLexer == null) {
                this.styleLexer = ourStyleFileType != null ? SyntaxHighlighter.PROVIDER.create(ourStyleFileType, null, null).getHighlightingLexer() : null;
            }
            newLexer = this.styleLexer;
        } else if (this.hasSeenScript()) {
            if (this.scriptLexer == null) {
                this.scriptLexer = ourScriptFileType != null ? SyntaxHighlighter.PROVIDER.create(ourScriptFileType, null, null).getHighlightingLexer() : null;
            }
            newLexer = this.scriptLexer;
        } else {
            newLexer = this.createELLexer(newLexer);
        }
        if (newLexer != null) {
            this.embeddedLexer = newLexer;
        }
    }

    @Nullable
    protected Lexer createELLexer(Lexer newLexer) {
        return newLexer;
    }

    @Override
    public void advance() {
        if (this.embeddedLexer != null) {
            this.embeddedLexer.advance();
            if (this.embeddedLexer.getTokenType() == null) {
                this.embeddedLexer = null;
            }
        }
        if (this.embeddedLexer == null) {
            super.advance();
        }
    }

    public IElementType getTokenType() {
        int state;
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenType();
        }
        IElementType tokenType = super.getTokenType();
        if (tokenType == null) {
            return tokenType;
        }
        if (tokenType == XmlTokenType.XML_NAME) {
            int state2 = this.getState() & 0x3F;
            if (this.isHtmlTagState(state2)) {
                tokenType = XmlTokenType.XML_TAG_NAME;
            }
        } else if (tokenType == XmlTokenType.XML_WHITE_SPACE || tokenType == XmlTokenType.XML_REAL_WHITE_SPACE) {
            tokenType = this.hasSeenTag() && (this.hasSeenStyle() || this.hasSeenScript()) ? XmlTokenType.XML_WHITE_SPACE : (this.getState() != 0 ? XmlTokenType.TAG_WHITE_SPACE : XmlTokenType.XML_REAL_WHITE_SPACE);
        } else if ((tokenType == XmlTokenType.XML_CHAR_ENTITY_REF || tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN) && (state = this.getState() & 0x3F) == 2) {
            return XmlTokenType.XML_COMMENT_CHARACTERS;
        }
        return tokenType;
    }

    public int getTokenStart() {
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenStart();
        }
        return super.getTokenStart();
    }

    public int getTokenEnd() {
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenEnd();
        }
        return super.getTokenEnd();
    }

    public static final void registerStyleFileType(FileType fileType) {
        ourStyleFileType = fileType;
    }

    public static void registerScriptFileType(FileType _scriptFileType) {
        ourScriptFileType = _scriptFileType;
    }

    @Override
    public int getState() {
        int state = super.getState();
        state |= this.embeddedLexer != null ? 2048 : 0;
        if (this.embeddedLexer != null) {
            state |= this.embeddedLexer.getState() << 12;
        }
        return state;
    }

    @Override
    protected boolean isHtmlTagState(int state) {
        return state == 3 || state == 4 || state == 10 || state == 11;
    }

    public void setHasNoEmbeddments(boolean hasNoEmbeddments) {
        this.hasNoEmbeddments = hasNoEmbeddments;
    }

    public class ElEmbeddmentHandler
    implements BaseHtmlLexer.TokenHandler {
        @Override
        public void handleElement(Lexer lexer) {
            HtmlHighlightingLexer.this.setEmbeddedLexer();
            if (HtmlHighlightingLexer.this.embeddedLexer != null) {
                HtmlHighlightingLexer.this.embeddedLexer.start(HtmlHighlightingLexer.this.getBufferSequence(), HtmlHighlightingLexer.super.getTokenStart(), HtmlHighlightingLexer.super.getTokenEnd());
            }
        }
    }

    public class XmlEmbeddmentHandler
    implements BaseHtmlLexer.TokenHandler {
        @Override
        public void handleElement(Lexer lexer) {
            if (!HtmlHighlightingLexer.this.hasSeenStyle() && !HtmlHighlightingLexer.this.hasSeenScript() || HtmlHighlightingLexer.this.hasNoEmbeddments) {
                return;
            }
            IElementType tokenType = lexer.getTokenType();
            if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && HtmlHighlightingLexer.this.hasSeenAttribute() || tokenType == XmlTokenType.XML_DATA_CHARACTERS && HtmlHighlightingLexer.this.hasSeenTag() || tokenType == XmlTokenType.XML_COMMENT_CHARACTERS && HtmlHighlightingLexer.this.hasSeenTag()) {
                HtmlHighlightingLexer.this.setEmbeddedLexer();
                if (HtmlHighlightingLexer.this.embeddedLexer != null) {
                    HtmlHighlightingLexer.this.embeddedLexer.start(HtmlHighlightingLexer.this.getBufferSequence(), HtmlHighlightingLexer.super.getTokenStart(), HtmlHighlightingLexer.this.skipToTheEndOfTheEmbeddment(), HtmlHighlightingLexer.this.embeddedLexer instanceof EmbedmentLexer ? ((EmbedmentLexer)HtmlHighlightingLexer.this.embeddedLexer).getEmbeddedInitialState(tokenType) : 0);
                    if (HtmlHighlightingLexer.this.embeddedLexer.getTokenType() == null) {
                        HtmlHighlightingLexer.this.embeddedLexer = null;
                    }
                }
            }
        }
    }
}

