/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;

public final class GotoModuleDirectory
extends FileChooserAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileChooser.actions.GotoModuleDirectory");

    @Override
    protected void actionPerformed(final FileSystemTree fileSystemTree, AnActionEvent e) {
        final VirtualFile path = GotoModuleDirectory.getModulePath(e);
        LOG.assertTrue(path != null);
        fileSystemTree.select(path, new Runnable(){

            @Override
            public void run() {
                fileSystemTree.expand(path, null);
            }
        });
    }

    @Override
    protected void update(FileSystemTree fileSystemTree, AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        VirtualFile path = GotoModuleDirectory.getModulePath(e);
        presentation.setEnabled(path != null && fileSystemTree.isUnderRoots(path));
    }

    private static VirtualFile getModulePath(AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        if (module == null) {
            module = (Module)e.getData(LangDataKeys.MODULE);
        }
        if (module == null) {
            return null;
        }
        VirtualFile moduleFile = GotoModuleDirectory.validated(module.getModuleFile());
        return moduleFile != null ? GotoModuleDirectory.validated(moduleFile.getParent()) : null;
    }

    private static VirtualFile validated(VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        return file;
    }
}

