/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.LabelTextReplacingUtil;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class UpdateInfoDialog
extends AbstractUpdateDialog {
    private final UpdateChannel myUpdatedChannel;
    private final BuildInfo myLatestBuild;

    protected UpdateInfoDialog(boolean canBeParent, UpdateChannel channel, List<PluginDownloader> uploadedPlugins, boolean enableLink) {
        super(canBeParent, enableLink, uploadedPlugins);
        this.myUpdatedChannel = channel;
        this.myLatestBuild = channel.getLatestBuild();
        this.setTitle(IdeBundle.message((String)"updates.info.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    protected Action[] createActions() {
        if (this.hasPatch()) {
            AbstractAction moreInfo = new AbstractAction(IdeBundle.message((String)"updates.more.info.button", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateInfoDialog.this.openDownloadPage();
                }
            };
            return new Action[]{this.getOKAction(), moreInfo, this.getCancelAction()};
        }
        return super.createActions();
    }

    private void openDownloadPage() {
        BrowserUtil.launchBrowser((String)this.myUpdatedChannel.getHomePageUrl());
    }

    @Override
    protected String getOkButtonText() {
        if (this.hasPatch()) {
            return ApplicationManager.getApplication().isRestartCapable() ? IdeBundle.message((String)"updates.download.and.install.patch.button.restart", (Object[])new Object[0]) : IdeBundle.message((String)"updates.download.and.install.patch.button", (Object[])new Object[0]);
        }
        return IdeBundle.message((String)"updates.more.info.button", (Object[])new Object[0]);
    }

    protected JComponent createCenterPanel() {
        UpdateInfoPanel updateInfoPanel = new UpdateInfoPanel();
        return updateInfoPanel.myPanel;
    }

    @Override
    protected void doOKAction() {
        if (this.hasPatch()) {
            super.doOKAction();
            return;
        }
        this.openDownloadPage();
        super.doOKAction();
    }

    @Override
    protected boolean doDownloadAndPrepare() {
        if (this.hasPatch()) {
            switch (UpdateChecker.downloadAndInstallPatch(this.myLatestBuild)) {
                case CANCELED: {
                    return false;
                }
                case FAILED: {
                    this.openDownloadPage();
                    return false;
                }
                case SUCCESS: {
                    super.doDownloadAndPrepare();
                    return true;
                }
            }
        }
        return super.doDownloadAndPrepare();
    }

    private boolean hasPatch() {
        return this.myLatestBuild.findPatchForCurrentBuild() != null;
    }

    private class UpdateInfoPanel {
        private JPanel myPanel;
        private JLabel myBuildNumber;
        private JLabel myVersionNumber;
        private JLabel myNewVersionNumber;
        private JLabel myNewBuildNumber;
        private JLabel myPatchAvailableLabel;
        private JLabel myPatchSizeLabel;
        private JLabel myUpdateMessageLabel;
        private JLabel myMessageLabel;

        public UpdateInfoPanel() {
            String minorVersion;
            this.$$$setupUI$$$();
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            this.myBuildNumber.setText(appInfo.getBuild().asStringWithoutProductCode() + ")");
            String majorVersion = appInfo.getMajorVersion();
            String version = majorVersion != null && majorVersion.trim().length() > 0 ? ((minorVersion = appInfo.getMinorVersion()) != null && minorVersion.trim().length() > 0 ? majorVersion + "." + minorVersion : majorVersion + ".0") : appInfo.getVersionName();
            this.myVersionNumber.setText(version);
            this.myNewBuildNumber.setText(UpdateInfoDialog.this.myLatestBuild.getNumber().asStringWithoutProductCode() + ")");
            this.myNewVersionNumber.setText(UpdateInfoDialog.this.myLatestBuild.getVersion());
            if (UpdateInfoDialog.this.myLatestBuild.getMessage() != null) {
                this.myUpdateMessageLabel.setText("<html><body><br>" + UpdateInfoDialog.this.myLatestBuild.getMessage() + "</body></html>");
            } else {
                this.myUpdateMessageLabel.setVisible(false);
            }
            PatchInfo patch = UpdateInfoDialog.this.myLatestBuild.findPatchForCurrentBuild();
            if (patch == null) {
                this.myPatchAvailableLabel.setVisible(false);
                this.myPatchSizeLabel.setVisible(false);
            } else {
                this.myPatchSizeLabel.setText(patch.getSize() + "MB");
            }
            LabelTextReplacingUtil.replaceText(this.myPanel);
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JLabel jLabel;
            JLabel jLabel2;
            JLabel jLabel3;
            JLabel jLabel4;
            JLabel jLabel5;
            JLabel jLabel6;
            JLabel jLabel7;
            JLabel jLabel8;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
            JLabel jLabel9 = new JLabel();
            jLabel9.setText("");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)jLabel9, gridBagConstraints);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 3;
            gridBagConstraints2.gridwidth = 3;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 1;
            jPanel.add((Component)jPanel2, gridBagConstraints2);
            this.myVersionNumber = jLabel8 = new JLabel();
            jLabel8.setText("4.5.4");
            jPanel2.add((Component)jLabel8, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, null, null));
            JLabel jLabel10 = new JLabel();
            this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.build.number"));
            jPanel2.add((Component)jLabel10, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myBuildNumber = jLabel7 = new JLabel();
            jLabel7.setText("3352)");
            jPanel2.add((Component)jLabel7, new GridConstraints(0, 3, 1, 1, 8, 1, 0, 0, null, null, null));
            JLabel jLabel11 = new JLabel();
            this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.current.idea.version"));
            jPanel2.add((Component)jLabel11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNewBuildNumber = jLabel6 = new JLabel();
            jLabel6.setText("3389)");
            jPanel2.add((Component)jLabel6, new GridConstraints(1, 3, 1, 1, 8, 1, 2, 0, null, null, null));
            JLabel jLabel12 = new JLabel();
            this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.build.number"));
            jPanel2.add((Component)jLabel12, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel13 = new JLabel();
            this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.available.idea.version"));
            jPanel2.add((Component)jLabel13, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNewVersionNumber = jLabel5 = new JLabel();
            jLabel5.setText("4.5.5");
            jPanel2.add((Component)jLabel5, new GridConstraints(1, 1, 1, 1, 8, 1, 0, 0, null, null, null));
            this.myPatchAvailableLabel = jLabel4 = new JLabel();
            jLabel4.setText("<html><b>Patch is available to install.</b> Total size is:</html>");
            jPanel2.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myPatchSizeLabel = jLabel3 = new JLabel();
            jLabel3.setText("0 mb");
            jPanel2.add((Component)jLabel3, new GridConstraints(2, 1, 1, 3, 8, 0, 0, 0, null, null, null));
            this.myMessageLabel = jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.press.more.info.label"));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 5;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 2;
            jPanel.add((Component)jLabel2, gridBagConstraints3);
            JLabel jLabel14 = new JLabel();
            this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.check.manually.label"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 6;
            gridBagConstraints4.gridwidth = 3;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.fill = 2;
            jPanel.add((Component)jLabel14, gridBagConstraints4);
            JLabel jLabel15 = new JLabel();
            this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.new.version.available"));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.fill = 2;
            jPanel.add((Component)jLabel15, gridBagConstraints5);
            JPanel jPanel3 = new JPanel();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 7;
            gridBagConstraints6.fill = 3;
            jPanel.add((Component)jPanel3, gridBagConstraints6);
            this.myUpdateMessageLabel = jLabel = new JLabel();
            jLabel.setText("");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 4;
            gridBagConstraints7.anchor = 17;
            jPanel.add((Component)jLabel, gridBagConstraints7);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

