/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.AbstractCalledLater;
import com.intellij.openapi.vcs.changes.committed.ChangeListDetailsAction;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.ChangeListGroupingStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListDecorator;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CompositeChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.committed.RepositoryChangesBrowser;
import com.intellij.openapi.vcs.changes.committed.SelectFilteringAction;
import com.intellij.openapi.vcs.changes.committed.SelectGroupingAction;
import com.intellij.openapi.vcs.changes.committed.WiseSplitter;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeCopyProvider;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommittedChangesTreeBrowser
extends JPanel
implements TypeSafeDataProvider,
Disposable,
DecoratorManager {
    private static final Border LEFT_BORDER = BorderFactory.createMatteBorder(1, 0, 0, 1, UIUtil.getBorderSeparatorColor());
    private static final Border MIDDLE_BORDER = BorderFactory.createMatteBorder(1, 1, 0, 1, UIUtil.getBorderSeparatorColor());
    private static final Border RIGHT_BORDER = BorderFactory.createMatteBorder(1, 1, 0, 0, UIUtil.getBorderSeparatorColor());
    private final Project myProject;
    private final Tree myChangesTree;
    private final RepositoryChangesBrowser myDetailsView;
    private List<CommittedChangeList> myChangeLists;
    private List<CommittedChangeList> mySelectedChangeLists;
    private ChangeListGroupingStrategy myGroupingStrategy = new ChangeListGroupingStrategy.DateChangeListGroupingStrategy();
    private final CompositeChangeListFilteringStrategy myFilteringStrategy = new CompositeChangeListFilteringStrategy();
    private final JPanel myLeftPanel;
    private final FilterChangeListener myFilterChangeListener = new FilterChangeListener();
    private final SplitterProportionsData mySplitterProportionsData = new SplitterProportionsDataImpl();
    private final CopyProvider myCopyProvider;
    private final TreeExpander myTreeExpander;
    private String myHelpId;
    public static final Topic<CommittedChangesReloadListener> ITEMS_RELOADED = new Topic("ITEMS_RELOADED", CommittedChangesReloadListener.class);
    private final List<CommittedChangeListDecorator> myDecorators;
    @NonNls
    public static final String ourHelpId = "reference.changesToolWindow.incoming";
    private final WiseSplitter myInnerSplitter;
    private MessageBusConnection myConnection;
    private TreeState myState;

    public CommittedChangesTreeBrowser(Project project, List<CommittedChangeList> changeLists) {
        super(new BorderLayout());
        this.myProject = project;
        this.myDecorators = new LinkedList<CommittedChangeListDecorator>();
        this.myChangeLists = changeLists;
        this.myChangesTree = new ChangesBrowserTree();
        this.myChangesTree.setRootVisible(false);
        this.myChangesTree.setShowsRootHandles(true);
        this.myChangesTree.setCellRenderer((TreeCellRenderer)((Object)new CommittedChangeListRenderer(project, this.myDecorators)));
        TreeUtil.expandAll((JTree)this.myChangesTree);
        this.myDetailsView = new RepositoryChangesBrowser(project, changeLists);
        this.myDetailsView.getViewer().setScrollPaneBorder(RIGHT_BORDER);
        this.myChangesTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CommittedChangesTreeBrowser.this.updateBySelectionChange();
            }
        });
        TreeLinkMouseListener linkMouseListener = new TreeLinkMouseListener(new CommittedChangeListRenderer(project, this.myDecorators));
        linkMouseListener.install((JComponent)this.myChangesTree);
        this.myLeftPanel = new JPanel(new BorderLayout());
        final Splitter filterSplitter = new Splitter(false, 0.5f);
        filterSplitter.setSecondComponent((JComponent)new JScrollPane((Component)this.myChangesTree));
        this.myLeftPanel.add((Component)filterSplitter, "Center");
        Splitter mainSplitter = new Splitter(false, 0.7f);
        mainSplitter.setFirstComponent((JComponent)this.myLeftPanel);
        mainSplitter.setSecondComponent((JComponent)this.myDetailsView);
        this.add((Component)mainSplitter, "Center");
        this.myInnerSplitter = new WiseSplitter(new Runnable(){

            @Override
            public void run() {
                filterSplitter.doLayout();
                CommittedChangesTreeBrowser.this.updateModel();
            }
        }, filterSplitter);
        this.mySplitterProportionsData.externalizeFromDimensionService("CommittedChanges.SplitterProportions");
        this.mySplitterProportionsData.restoreSplitterProportions((Component)this);
        this.updateBySelectionChange();
        ActionManager.getInstance().getAction("CommittedChanges.Details").registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("QuickJavaDoc")), (JComponent)this);
        this.myCopyProvider = new TreeCopyProvider((JTree)this.myChangesTree);
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myChangesTree);
        this.myDetailsView.addToolbarAction(ActionManager.getInstance().getAction("Vcs.ShowTabbedFileHistory"));
        this.myHelpId = ourHelpId;
        this.myDetailsView.getDiffAction().registerCustomShortcutSet(CommonShortcuts.getDiff(), (JComponent)this.myChangesTree);
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(ITEMS_RELOADED, (Object)new CommittedChangesReloadListener(){

            @Override
            public void itemsReloaded() {
            }

            @Override
            public void emptyRefresh() {
                CommittedChangesTreeBrowser.this.updateGrouping();
            }
        });
    }

    public void addFilter(ChangeListFilteringStrategy strategy) {
        this.myFilteringStrategy.addStrategy("permanent", strategy);
        strategy.addChangeListener((ChangeListener)this.myFilterChangeListener);
    }

    private void updateGrouping() {
        if (this.myGroupingStrategy.changedSinceApply()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommittedChangesTreeBrowser.this.updateModel();
                }
            }, ModalityState.NON_MODAL);
        }
    }

    private TreeModel buildTreeModel(List<CommittedChangeList> filteredChangeLists) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel model = new DefaultTreeModel(root);
        DefaultMutableTreeNode lastGroupNode = null;
        String lastGroupName = null;
        Collections.sort(filteredChangeLists, this.myGroupingStrategy.getComparator());
        this.myGroupingStrategy.beforeStart();
        for (CommittedChangeList list : filteredChangeLists) {
            String groupName = this.myGroupingStrategy.getGroupName(list);
            if (!Comparing.equal((String)groupName, lastGroupName)) {
                lastGroupName = groupName;
                lastGroupNode = new DefaultMutableTreeNode(lastGroupName);
                root.add(lastGroupNode);
            }
            assert (lastGroupNode != null);
            lastGroupNode.add(new DefaultMutableTreeNode(list));
        }
        return model;
    }

    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    public void setEmptyText(String emptyText) {
        this.myChangesTree.setEmptyText(emptyText);
    }

    public void clearEmptyText() {
        this.myChangesTree.clearEmptyText();
    }

    public void appendEmptyText(String text, SimpleTextAttributes attrs) {
        this.myChangesTree.appendEmptyText(text, attrs);
    }

    public void appendEmptyText(String text, SimpleTextAttributes attrs, ActionListener clickListener) {
        this.myChangesTree.appendEmptyText(text, attrs, clickListener);
    }

    public void setToolBar(JComponent toolBar) {
        this.myLeftPanel.add((Component)toolBar, "North");
        Dimension prefSize = this.myDetailsView.getHeaderPanel().getPreferredSize();
        if (prefSize.height < toolBar.getPreferredSize().height) {
            prefSize.height = toolBar.getPreferredSize().height;
            this.myDetailsView.getHeaderPanel().setPreferredSize(prefSize);
        }
    }

    public void dispose() {
        this.myConnection.disconnect();
        this.mySplitterProportionsData.saveSplitterProportions((Component)this);
        this.mySplitterProportionsData.externalizeToDimensionService("CommittedChanges.SplitterProportions");
        this.myDetailsView.dispose();
    }

    public void setItems(@NotNull List<CommittedChangeList> items, boolean keepFilter, CommittedChangesBrowserUseCase useCase) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/committed/CommittedChangesTreeBrowser.setItems must not be null");
        }
        this.myDetailsView.setUseCase(useCase);
        this.myChangeLists = items;
        if (!keepFilter) {
            this.myFilteringStrategy.setFilterBase(items);
        }
        ((CommittedChangesReloadListener)this.myProject.getMessageBus().syncPublisher(ITEMS_RELOADED)).itemsReloaded();
        this.updateModel();
    }

    private void updateModel() {
        List<CommittedChangeList> filteredChangeLists = this.myFilteringStrategy.filterChangeLists(this.myChangeLists);
        this.myChangesTree.setModel(this.buildTreeModel(filteredChangeLists));
        TreeUtil.expandAll((JTree)this.myChangesTree);
    }

    public void setGroupingStrategy(ChangeListGroupingStrategy strategy) {
        this.myGroupingStrategy = strategy;
        this.updateModel();
    }

    private void updateBySelectionChange() {
        ArrayList<CommittedChangeList> selection = new ArrayList<CommittedChangeList>();
        TreePath[] selectionPaths = this.myChangesTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath path : selectionPaths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!(node.getUserObject() instanceof CommittedChangeList)) continue;
                selection.add((CommittedChangeList)node.getUserObject());
            }
        }
        if (!((Object)selection).equals(this.mySelectedChangeLists)) {
            this.mySelectedChangeLists = selection;
            this.myDetailsView.setChangesToDisplay(CommittedChangesTreeBrowser.collectChanges(this.mySelectedChangeLists, false));
        }
    }

    public static List<Change> collectChanges(List<CommittedChangeList> selectedChangeLists, boolean withMovedTrees) {
        ArrayList<Change> result = new ArrayList<Change>();
        Collections.sort(selectedChangeLists, new Comparator<CommittedChangeList>(){

            @Override
            public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                return o1.getCommitDate().compareTo(o2.getCommitDate());
            }
        });
        for (CommittedChangeList cl : selectedChangeLists) {
            Collection changes = withMovedTrees ? cl.getChangesWithMovedTrees() : cl.getChanges();
            for (Change c : changes) {
                CommittedChangesTreeBrowser.addOrReplaceChange(result, c);
            }
        }
        return result;
    }

    private static void addOrReplaceChange(List<Change> changes, Change c) {
        ContentRevision beforeRev = c.getBeforeRevision();
        if (beforeRev != null) {
            String beforeName = beforeRev.getFile().getName();
            String beforeAbsolutePath = beforeRev.getFile().getIOFile().getAbsolutePath();
            for (Change oldChange : changes) {
                ContentRevision rev = oldChange.getAfterRevision();
                if (rev == null || !rev.getFile().getName().equals(beforeName) || !rev.getFile().getIOFile().getAbsolutePath().equals(beforeAbsolutePath)) continue;
                changes.remove(oldChange);
                if (oldChange.getBeforeRevision() != null || c.getAfterRevision() != null) {
                    changes.add(new Change(oldChange.getBeforeRevision(), c.getAfterRevision()));
                }
                return;
            }
        }
        changes.add(c);
    }

    private List<CommittedChangeList> getSelectedChangeLists() {
        return TreeUtil.collectSelectedObjectsOfType((JTree)this.myChangesTree, CommittedChangeList.class);
    }

    public void setTableContextMenu(ActionGroup group, List<AnAction> auxiliaryActions) {
        DefaultActionGroup menuGroup = new DefaultActionGroup();
        menuGroup.add((AnAction)group);
        for (AnAction action : auxiliaryActions) {
            menuGroup.add(action);
        }
        menuGroup.add(ActionManager.getInstance().getAction("$Copy"));
        PopupHandler.installPopupHandler((JComponent)this.myChangesTree, (ActionGroup)menuGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    public void removeFilteringStrategy(String key) {
        ChangeListFilteringStrategy strategy = this.myFilteringStrategy.removeStrategy(key);
        if (strategy != null) {
            strategy.removeChangeListener((ChangeListener)this.myFilterChangeListener);
        }
        this.myInnerSplitter.remove(key);
    }

    public boolean setFilteringStrategy(String key, ChangeListFilteringStrategy filteringStrategy) {
        if (this.myInnerSplitter.canAdd()) {
            filteringStrategy.setFilterBase(this.myChangeLists);
            filteringStrategy.addChangeListener((ChangeListener)this.myFilterChangeListener);
            this.myFilteringStrategy.addStrategy(key, filteringStrategy);
            JComponent filterUI = filteringStrategy.getFilterUI();
            if (filterUI != null) {
                this.myInnerSplitter.add(key, filterUI);
            }
            return true;
        }
        return false;
    }

    public ActionToolbar createGroupFilterToolbar(Project project, ActionGroup leadGroup, @Nullable ActionGroup tailGroup, List<AnAction> extra) {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)leadGroup);
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)new SelectFilteringAction(project, this));
        toolbarGroup.add((AnAction)new SelectGroupingAction(this));
        ExpandAllAction expandAllAction = new ExpandAllAction((JTree)this.myChangesTree);
        CollapseAllAction collapseAllAction = new CollapseAllAction((JTree)this.myChangesTree);
        expandAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("ExpandAll")), (JComponent)this.myChangesTree);
        collapseAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CollapseAll")), (JComponent)this.myChangesTree);
        toolbarGroup.add((AnAction)expandAllAction);
        toolbarGroup.add((AnAction)collapseAllAction);
        toolbarGroup.add(ActionManager.getInstance().getAction("$Copy"));
        toolbarGroup.add((AnAction)new ContextHelpAction(this.myHelpId));
        if (tailGroup != null) {
            toolbarGroup.add((AnAction)tailGroup);
        }
        for (AnAction anAction : extra) {
            toolbarGroup.add(anAction);
        }
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarGroup, true);
    }

    public void calcData(DataKey key, DataSink sink) {
        if (key.equals(VcsDataKeys.CHANGES)) {
            List<Change> changes = CommittedChangesTreeBrowser.collectChanges(this.getSelectedChangeLists(), false);
            sink.put(VcsDataKeys.CHANGES, (Object)changes.toArray(new Change[changes.size()]));
        } else if (key.equals(VcsDataKeys.CHANGES_WITH_MOVED_CHILDREN)) {
            List<Change> changes = CommittedChangesTreeBrowser.collectChanges(this.getSelectedChangeLists(), true);
            sink.put(VcsDataKeys.CHANGES_WITH_MOVED_CHILDREN, (Object)changes.toArray(new Change[changes.size()]));
        } else if (key.equals(VcsDataKeys.CHANGE_LISTS)) {
            List<CommittedChangeList> lists = this.getSelectedChangeLists();
            if (lists.size() > 0) {
                sink.put(VcsDataKeys.CHANGE_LISTS, (Object)lists.toArray(new CommittedChangeList[lists.size()]));
            }
        } else if (key.equals(PlatformDataKeys.NAVIGATABLE_ARRAY)) {
            List<Change> changes = CommittedChangesTreeBrowser.collectChanges(this.getSelectedChangeLists(), false);
            Navigatable[] result = ChangesUtil.getNavigatableArray((Project)this.myProject, (VirtualFile[])ChangesUtil.getFilesFromChanges(changes));
            sink.put(PlatformDataKeys.NAVIGATABLE_ARRAY, (Object)result);
        } else if (key.equals(PlatformDataKeys.HELP_ID)) {
            sink.put(PlatformDataKeys.HELP_ID, (Object)this.myHelpId);
        } else if (VcsDataKeys.SELECTED_CHANGES_IN_DETAILS.equals(key)) {
            List<Change> selectedChanges = this.myDetailsView.getSelectedChanges();
            sink.put(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS, (Object)selectedChanges.toArray(new Change[selectedChanges.size()]));
        }
    }

    public TreeExpander getTreeExpander() {
        return this.myTreeExpander;
    }

    public void repaintTree() {
        this.myChangesTree.revalidate();
        this.myChangesTree.repaint();
    }

    public void install(CommittedChangeListDecorator decorator) {
        this.myDecorators.add(decorator);
        this.repaintTree();
    }

    public void remove(CommittedChangeListDecorator decorator) {
        this.myDecorators.remove(decorator);
        this.repaintTree();
    }

    public void reportLoadedLists(final CommittedChangeListsListener listener) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                listener.onBeforeStartReport();
                for (CommittedChangeList list : CommittedChangesTreeBrowser.this.myChangeLists) {
                    listener.report(list);
                }
                listener.onAfterEndReport();
            }
        });
    }

    public void reset() {
        this.myChangeLists.clear();
        this.myFilteringStrategy.resetFilterBase();
        this.myState = TreeState.createOn((JTree)this.myChangesTree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myChangesTree.getModel().getRoot()));
        this.updateModel();
    }

    public void append(List<CommittedChangeList> list) {
        TreeState state = this.myChangeLists.isEmpty() && this.myState != null ? this.myState : TreeState.createOn((JTree)this.myChangesTree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myChangesTree.getModel().getRoot()));
        state.setScrollToSelection(false);
        this.myChangeLists.addAll(list);
        this.myFilteringStrategy.appendFilterBase(list);
        this.myChangesTree.setModel(this.buildTreeModel(this.myFilteringStrategy.filterChangeLists(this.myChangeLists)));
        state.applyTo((JTree)this.myChangesTree, (DefaultMutableTreeNode)this.myChangesTree.getModel().getRoot());
        TreeUtil.expandAll((JTree)this.myChangesTree);
        ((CommittedChangesReloadListener)this.myProject.getMessageBus().syncPublisher(ITEMS_RELOADED)).itemsReloaded();
    }

    public void setLoading(final boolean value) {
        new AbstractCalledLater(this.myProject, ModalityState.NON_MODAL){

            @Override
            public void run() {
                CommittedChangesTreeBrowser.this.myChangesTree.setPaintBusy(value);
            }
        }.callMe();
    }

    public static interface CommittedChangesReloadListener {
        public void itemsReloaded();

        public void emptyRefresh();
    }

    private class ChangesBrowserTree
    extends Tree
    implements TypeSafeDataProvider {
        public ChangesBrowserTree() {
            super(CommittedChangesTreeBrowser.this.buildTreeModel(CommittedChangesTreeBrowser.this.myFilteringStrategy.filterChangeLists(CommittedChangesTreeBrowser.this.myChangeLists)));
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public void calcData(DataKey key, DataSink sink) {
            if (key.equals(PlatformDataKeys.COPY_PROVIDER)) {
                sink.put(PlatformDataKeys.COPY_PROVIDER, (Object)CommittedChangesTreeBrowser.this.myCopyProvider);
            } else if (key.equals(PlatformDataKeys.TREE_EXPANDER)) {
                sink.put(PlatformDataKeys.TREE_EXPANDER, (Object)CommittedChangesTreeBrowser.this.myTreeExpander);
            }
        }
    }

    private class FilterChangeListener
    implements ChangeListener {
        private FilterChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                CommittedChangesTreeBrowser.this.updateModel();
            } else {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommittedChangesTreeBrowser.this.updateModel();
                    }
                });
            }
        }
    }

    public static class MoreLauncher
    implements Runnable {
        private final Project myProject;
        private final CommittedChangeList myList;

        public MoreLauncher(Project project, CommittedChangeList list) {
            this.myProject = project;
            this.myList = list;
        }

        @Override
        public void run() {
            ChangeListDetailsAction.showDetailsPopup(this.myProject, this.myList);
        }
    }

    public static class CommittedChangeListRenderer
    extends ColoredTreeCellRenderer {
        private static final DateFormat myDateFormat = DateFormat.getDateTimeInstance(3, 3);
        private static final SimpleTextAttributes LINK_ATTRIBUTES = new SimpleTextAttributes(16, Color.blue);
        private final IssueLinkRenderer myRenderer;
        private final List<CommittedChangeListDecorator> myDecorators;
        private final Project myProject;

        public CommittedChangeListRenderer(Project project, List<CommittedChangeListDecorator> decorators) {
            this.myProject = project;
            this.myRenderer = new IssueLinkRenderer(project, (SimpleColoredComponent)this);
            this.myDecorators = decorators;
        }

        public static String getDateOfChangeList(Date date) {
            return myDateFormat.format(date);
        }

        public static Pair<String, Boolean> getDescriptionOfChangeList(String text) {
            String description = text;
            int pos = description.indexOf("\n");
            if (pos >= 0) {
                description = description.substring(0, pos).trim();
                return new Pair((Object)description, (Object)Boolean.TRUE);
            }
            return new Pair((Object)description, (Object)Boolean.FALSE);
        }

        public static String truncateDescription(String initDescription, FontMetrics fontMetrics, int maxWidth) {
            String description = initDescription;
            int descWidth = fontMetrics.stringWidth(description);
            while (description.length() > 0 && descWidth > maxWidth) {
                description = CommittedChangeListRenderer.trimLastWord(description);
                descWidth = fontMetrics.stringWidth(description + " ");
            }
            return description;
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof CommittedChangeList) {
                CachingCommittedChangesProvider provider;
                boolean partial;
                CommittedChangeList changeList = (CommittedChangeList)node.getUserObject();
                Container parent = tree.getParent();
                int parentWidth = parent == null ? 100 : parent.getWidth() - 44;
                String date = ", " + CommittedChangeListRenderer.getDateOfChangeList(changeList.getCommitDate());
                FontMetrics fontMetrics = tree.getFontMetrics(tree.getFont());
                FontMetrics boldMetrics = tree.getFontMetrics(tree.getFont().deriveFont(1));
                int size = fontMetrics.stringWidth(date);
                size += boldMetrics.stringWidth(changeList.getCommitterName());
                Pair<String, Boolean> descriptionInfo = CommittedChangeListRenderer.getDescriptionOfChangeList(changeList.getName().trim());
                boolean truncated = (Boolean)descriptionInfo.getSecond();
                String description = (String)descriptionInfo.getFirst();
                for (CommittedChangeListDecorator decorator : this.myDecorators) {
                    Icon icon = decorator.decorate(changeList);
                    if (icon == null) continue;
                    this.setIcon(icon);
                }
                int descMaxWidth = parentWidth - size - 8;
                boolean bl = partial = changeList instanceof ReceivedChangeList && ((ReceivedChangeList)changeList).isPartial();
                if (partial) {
                    String partialMarker = VcsBundle.message((String)"committed.changes.partial.list", (Object[])new Object[0]) + " ";
                    this.append(partialMarker, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    descMaxWidth -= boldMetrics.stringWidth(partialMarker);
                }
                int descWidth = fontMetrics.stringWidth(description);
                int numberWidth = 0;
                AbstractVcs vcs = changeList.getVcs();
                if (vcs != null && (provider = vcs.getCachingCommittedChangesProvider()) != null && provider.getChangelistTitle() != null) {
                    String number = "#" + changeList.getNumber() + "  ";
                    numberWidth = fontMetrics.stringWidth(number);
                    descWidth += numberWidth;
                    this.append(number, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
                if (description.length() == 0 && !truncated) {
                    this.append(VcsBundle.message((String)"committed.changes.empty.comment", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.appendAlign(parentWidth - size);
                } else if (descMaxWidth < 0) {
                    this.myRenderer.appendTextWithLinks(description);
                } else if (descWidth < descMaxWidth && !truncated) {
                    this.myRenderer.appendTextWithLinks(description);
                    this.appendAlign(parentWidth - size);
                } else {
                    String moreMarker = VcsBundle.message((String)"changes.browser.details.marker", (Object[])new Object[0]);
                    int moreWidth = fontMetrics.stringWidth(moreMarker);
                    description = CommittedChangeListRenderer.truncateDescription(description, fontMetrics, descMaxWidth - moreWidth - numberWidth);
                    this.myRenderer.appendTextWithLinks(description);
                    this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.append(moreMarker, LINK_ATTRIBUTES, new MoreLauncher(this.myProject, changeList));
                    this.appendAlign(parentWidth - size);
                }
                this.append(changeList.getCommitterName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                this.append(date, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else if (node.getUserObject() != null) {
                this.append(node.getUserObject().toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }

        private void appendDescriptionAndNumber(String description, String number) {
            this.myRenderer.appendTextWithLinks(description);
            if (number != null) {
                this.append(number, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        private static String trimLastWord(String description) {
            int pos = description.trim().lastIndexOf(32);
            if (pos >= 0) {
                return description.substring(0, pos).trim();
            }
            return description.substring(0, description.length() - 1);
        }

        public Dimension getPreferredSize() {
            return new Dimension(2000, super.getPreferredSize().height);
        }
    }
}

