/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.StreamProvider;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public class CompoundShelfFileProcesor {
    private final String mySubdirName;
    private final StreamProvider[] myServerStreamProviders;
    private static final RoamingType PER_USER = RoamingType.PER_USER;
    private final String FILE_SPEC;
    private final String myShelfPath;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.CompoundShelfFileProcesor");

    public CompoundShelfFileProcesor(String subdirName) {
        this.mySubdirName = subdirName;
        this.myServerStreamProviders = ((ApplicationImpl)ApplicationManager.getApplication()).getStateStore().getStateStorageManager().getStreamProviders(PER_USER);
        this.FILE_SPEC = "$ROOT_CONFIG$/" + subdirName + "/";
        this.myShelfPath = PathManager.getConfigPath() + File.separator + this.mySubdirName;
    }

    public CompoundShelfFileProcesor(StreamProvider[] serverStreamProviders, String shelfPath) {
        this.myServerStreamProviders = serverStreamProviders;
        this.myShelfPath = shelfPath;
        this.mySubdirName = new File(this.myShelfPath).getName();
        this.FILE_SPEC = "$ROOT_CONFIG$/" + this.mySubdirName + "/";
    }

    public List<String> getLocalFiles() {
        ArrayList<String> result = new ArrayList<String>();
        File[] files = new File(this.myShelfPath).listFiles();
        if (files != null) {
            for (File file : files) {
                result.add(file.getName());
            }
        }
        return result;
    }

    public List<String> getServerFiles() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (StreamProvider serverStreamProvider : this.myServerStreamProviders) {
            if (!serverStreamProvider.isEnabled()) continue;
            String[] subFiles = serverStreamProvider.listSubFiles(this.FILE_SPEC);
            result.addAll(Arrays.asList(subFiles));
        }
        return new ArrayList<String>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String copyFileFromServer(String serverFileName, List<String> localFileNames) {
        for (StreamProvider serverStreamProvider : this.myServerStreamProviders) {
            if (!serverStreamProvider.isEnabled()) continue;
            try {
                InputStream stream;
                File file = new File(new File(this.myShelfPath), serverFileName);
                if (file.exists() || (stream = serverStreamProvider.loadContent(this.FILE_SPEC + serverFileName, PER_USER)) == null) continue;
                file.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(file);
                try {
                    FileUtil.copy((InputStream)stream, (OutputStream)out);
                }
                finally {
                    out.close();
                    stream.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        localFileNames.add(serverFileName);
        return serverFileName;
    }

    public String renameFileOnServer(String serverFileName, List<String> serverFileNames, List<String> localFileNames) {
        String newName = this.getNewFileName(serverFileName, serverFileNames, localFileNames);
        String oldFilePath = this.FILE_SPEC + serverFileName;
        String newFilePath = this.FILE_SPEC + newName;
        for (StreamProvider serverStreamProvider : this.myServerStreamProviders) {
            this.renameFileOnProvider(newName, oldFilePath, newFilePath, serverStreamProvider);
        }
        return newName;
    }

    private void renameFileOnProvider(String newName, String oldFilePath, String newFilePath, StreamProvider serverStreamProvider) {
        if (serverStreamProvider.isEnabled()) {
            try {
                InputStream stream = serverStreamProvider.loadContent(oldFilePath, PER_USER);
                if (stream != null) {
                    File file = new File(this.myShelfPath + "/" + newName);
                    this.copyFileToStream(stream, file);
                    serverStreamProvider.deleteFile(oldFilePath, PER_USER);
                    this.copyFileContentToProviders(newFilePath, serverStreamProvider, file);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileContentToProviders(String newFilePath, StreamProvider serverStreamProvider, File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            if (serverStreamProvider.isEnabled()) {
                serverStreamProvider.saveContent(newFilePath, (InputStream)input, file.length(), PER_USER, true);
            }
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileToStream(InputStream stream, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            FileUtil.copy((InputStream)stream, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    private String getNewFileName(String serverFileName, List<String> serverFileNames, List<String> localFileNames) {
        String name = FileUtil.getNameWithoutExtension((String)serverFileName);
        String ext = FileUtil.getExtension((String)serverFileName);
        int i = 1;
        while (true) {
            String suggestedName;
            if (!serverFileNames.contains(suggestedName = name + i + "." + ext) && !localFileNames.contains(suggestedName)) {
                serverFileNames.add(suggestedName);
                localFileNames.add(suggestedName);
                return suggestedName;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePathFile(ContentProvider contentProvider, File patchPath) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(patchPath));
        try {
            contentProvider.writeContentTo(writer);
        }
        finally {
            writer.close();
        }
        for (StreamProvider serverStreamProvider : this.myServerStreamProviders) {
            this.copyFileContentToProviders(this.FILE_SPEC + patchPath.getName(), serverStreamProvider, patchPath);
        }
    }

    public File getBaseIODir() {
        return new File(this.myShelfPath);
    }

    public void saveFile(File from, File to) throws IOException {
        for (StreamProvider serverStreamProvider : this.myServerStreamProviders) {
            this.copyFileContentToProviders(this.FILE_SPEC + to.getName(), serverStreamProvider, from);
        }
        FileUtil.copy((File)from, (File)to);
    }

    public void delete(String name) {
        FileUtil.delete((File)new File(this.getBaseIODir(), name));
        for (StreamProvider serverStreamProvider : this.myServerStreamProviders) {
            if (!serverStreamProvider.isEnabled()) continue;
            serverStreamProvider.deleteFile(this.FILE_SPEC + name, PER_USER);
        }
    }

    public static interface ContentProvider {
        public void writeContentTo(Writer var1) throws IOException;
    }
}

