/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.vcs.ex.DocumentWrapper;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.ArrayUtil;
import com.intellij.util.diff.Diff;
import java.util.ArrayList;
import java.util.List;

public class RangesBuilder {
    private List<Range> myRanges = new ArrayList<Range>();

    public RangesBuilder(String current, String upToDate) {
        this(EditorFactory.getInstance().createDocument((CharSequence)current), EditorFactory.getInstance().createDocument((CharSequence)upToDate));
    }

    public RangesBuilder(Document current, Document upToDate) {
        this(new DocumentWrapper(current).getLines(), new DocumentWrapper(upToDate).getLines(), 0, 0);
    }

    public RangesBuilder(List<String> current, List<String> upToDate, int shift, int uShift) {
        int i;
        int shiftBefore = 0;
        int minSize = Math.min(upToDate.size(), current.size());
        for (i = 0; i < minSize && upToDate.get(0).equals(current.get(0)); ++i) {
            upToDate.remove(0);
            current.remove(0);
            ++shiftBefore;
        }
        minSize = Math.min(upToDate.size(), current.size());
        for (i = 0; i < minSize && upToDate.get(upToDate.size() - 1).equals(current.get(current.size() - 1)); ++i) {
            upToDate.remove(upToDate.size() - 1);
            current.remove(current.size() - 1);
        }
        Diff.Change ch = Diff.buildChanges((Object[])ArrayUtil.toStringArray(upToDate), (Object[])ArrayUtil.toStringArray(current));
        while (ch != null) {
            Range range = Range.createOn(ch, shift + shiftBefore, uShift + shiftBefore);
            this.myRanges.add(range);
            ch = ch.link;
        }
    }

    public List<Range> getRanges() {
        return this.myRanges;
    }
}

