/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.status.StatusBarPatch;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

class MemoryUsagePanel
extends JPanel
implements StatusBarPatch {
    private static final int MEGABYTE = 0x100000;
    private static final Color ourColorFree = new Color(240, 240, 240);
    private static final Color ourColorUsed = new Color(112, 135, 214);
    private static final Color ourColorUsed2 = new Color(166, 181, 230);
    private static final Icon ourRunGCButtonIcon = IconLoader.getIcon((String)"/actions/gc.png");
    private final JPanel myIndicatorPanel;
    private long myLastTotal = -1L;
    private long myLastUsed = -1L;
    private ScheduledFuture<?> myFuture;

    public MemoryUsagePanel() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.myIndicatorPanel = new IndicatorPanel();
        this.add((Component)this.myIndicatorPanel, "Center");
        RunCGAction gcAction = new RunCGAction();
        JComponent button = gcAction.createButton(gcAction.getTemplatePresentation());
        this.add((Component)button, SystemInfo.isMac ? "West" : "East");
        this.updateUI();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String updateStatusBar(Editor selected, JComponent componentSelected) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public void addNotify() {
        this.myFuture = JobScheduler.getScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!MemoryUsagePanel.this.isDisplayable()) {
                            return;
                        }
                        MemoryUsagePanel.this.updateState();
                    }
                });
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        super.addNotify();
    }

    private void updateState() {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.isShowing()) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory() / 0x100000L;
        long used = total - runtime.freeMemory() / 0x100000L;
        if (total != this.myLastTotal || used != this.myLastUsed) {
            this.myLastTotal = total;
            this.myLastUsed = used;
            this.repaint();
            this.myIndicatorPanel.setToolTipText(UIBundle.message((String)"memory.usage.panel.statistics.message", (Object[])new Object[]{total, used}));
        }
    }

    @Override
    public void removeNotify() {
        this.myFuture.cancel(true);
        this.myFuture = null;
        super.removeNotify();
    }

    private static final class IndicatorPanel
    extends JPanel {
        @NonNls
        static final String SAMPLE_STRING = "0000M of 0000M";

        public IndicatorPanel() {
            this.updateUI();
        }

        @Override
        public final void updateUI() {
            super.updateUI();
            this.setPreferredSize(new Dimension(this.getPreferedWidth(), -1));
        }

        @Override
        public final void paint(Graphics g) {
            super.paint(g);
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            int x = insets.left;
            int y = insets.top;
            Runtime runtime = Runtime.getRuntime();
            long freeMemory = runtime.freeMemory();
            long totalMemory = runtime.totalMemory();
            int totalBarLength = size.width - (insets.left + insets.right);
            int usedBarLength = totalBarLength - (int)((long)totalBarLength * freeMemory / totalMemory);
            int barHeight = size.height - (insets.bottom + insets.top);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(x, y, ourColorUsed, x, barHeight / 2, ourColorUsed2, true));
            g.fillRect(x, y, usedBarLength, barHeight);
            g.setColor(ourColorFree);
            g.fillRect(x + usedBarLength, y, totalBarLength - usedBarLength, barHeight);
            g.setFont(UIUtil.getLabelFont());
            g.setColor(Color.black);
            long used = (totalMemory - freeMemory) / 0x100000L;
            long total = totalMemory / 0x100000L;
            String info = UIBundle.message((String)"memory.usage.panel.message.text", (Object[])new Object[]{Long.toString(used), Long.toString(total)});
            FontMetrics fontMetrics = g.getFontMetrics();
            int infoWidth = fontMetrics.charsWidth(info.toCharArray(), 0, info.length());
            int infoHeight = fontMetrics.getHeight() - fontMetrics.getDescent();
            UIUtil.applyRenderingHints((Graphics)g);
            g.drawString(info, x + (totalBarLength - infoWidth) / 2, y + (barHeight + infoHeight) / 2);
        }

        public final int getPreferedWidth() {
            return this.getFontMetrics(UIUtil.getLabelFont()).stringWidth(SAMPLE_STRING);
        }
    }

    private final class RunCGAction
    extends AnAction
    implements DumbAware {
        public RunCGAction() {
            super(UIBundle.message((String)"memory.usage.panel.run.garbage.collector.action.name", (Object[])new Object[0]), UIBundle.message((String)"memory.usage.panel.run.garbage.collector.action.description", (Object[])new Object[0]), ourRunGCButtonIcon);
        }

        public JComponent createButton(Presentation presentation) {
            ActionButton button = new ActionButton(this, presentation, "unknown", new Dimension(1, 1));
            presentation.putClientProperty("button", (Object)button);
            return button;
        }

        public void actionPerformed(AnActionEvent e) {
            System.gc();
            MemoryUsagePanel.this.updateState();
        }
    }
}

