/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactElementPresentation
extends TreeNodePresentation {
    private final ArtifactPointer myArtifactPointer;
    private final ArtifactEditorContext myContext;

    public ArtifactElementPresentation(ArtifactPointer artifactPointer, ArtifactEditorContext context) {
        this.myArtifactPointer = artifactPointer;
        this.myContext = context;
    }

    public String getPresentableName() {
        return this.myArtifactPointer != null ? this.myArtifactPointer.getArtifactName(this.myContext.getArtifactModel()) : "<unknown>";
    }

    public boolean canNavigateToSource() {
        return this.findArtifact() != null;
    }

    public Object getSourceObject() {
        return this.myArtifactPointer;
    }

    public void navigateToSource() {
        Artifact artifact = this.findArtifact();
        if (artifact != null) {
            this.myContext.selectArtifact(artifact);
        }
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        if (presentationData == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/ui/ArtifactElementPresentation.render must not be null");
        }
        Artifact artifact = this.findArtifact();
        presentationData.setIcons(artifact != null ? artifact.getArtifactType().getIcon() : PlainArtifactType.ARTIFACT_ICON);
        presentationData.addText(this.getPresentableName(), artifact != null ? mainAttributes : SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    @Nullable
    private Artifact findArtifact() {
        return this.myArtifactPointer != null ? this.myArtifactPointer.findArtifact(this.myContext.getArtifactModel()) : null;
    }

    public int getWeight() {
        return 100;
    }
}

