/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiEnumConstantImpl
extends JavaStubPsiElement<PsiFieldStub>
implements PsiEnumConstant {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiEnumConstantImpl");
    private final MyReference myReference = new MyReference();

    public PsiEnumConstantImpl(PsiFieldStub stub) {
        super(stub, JavaStubElementTypes.ENUM_CONSTANT);
    }

    public PsiEnumConstantImpl(ASTNode node) {
        super(node);
    }

    public String toString() {
        return "PsiEnumConstant:" + this.getName();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiEnumConstantImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitEnumConstant((PsiEnumConstant)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.calcTreeElement().findChildByRoleAsPsiElement(73);
    }

    public PsiEnumConstantInitializer getInitializingClass() {
        return (PsiEnumConstantInitializer)this.getStubOrPsiChild(JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER);
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    public PsiModifierList getModifierList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiEnumConstantImpl.hasModifierProperty must not be null");
        }
        return "public".equals(name) || "static".equals(name) || "final".equals(name);
    }

    @NotNull
    public PsiType getType() {
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(this.getContainingClass());
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.getType must not return null");
        }
        return psiClassType;
    }

    public PsiTypeElement getTypeElement() {
        return null;
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return true;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    public Object computeConstantValue() {
        return this;
    }

    public PsiMethod resolveMethod() {
        PsiClass containingClass = this.getContainingClass();
        LOG.assertTrue(containingClass != null);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType(containingClass), this.getArgumentList(), (PsiElement)this);
        return (PsiMethod)resolveResult.getElement();
    }

    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        PsiClass containingClass = this.getContainingClass();
        LOG.assertTrue(containingClass != null);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        JavaResolveResult javaResolveResult = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType(containingClass), this.getArgumentList(), (PsiElement)this);
        if (javaResolveResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.resolveMethodGenerics must not return null");
        }
        return javaResolveResult;
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.calcTreeElement().findChildByRoleAsPsiElement(9);
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.getNameIdentifier must not return null");
        }
        return psiIdentifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getName() {
        String string;
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            string = stub.getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.getName must not return null");
            return string;
        }
        string = this.getNameIdentifier().getText();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.getName must not return null");
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiEnumConstantImpl.setName must not be null");
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    public PsiDocComment getDocComment() {
        return (PsiDocComment)this.calcTreeElement().findChildByRoleAsPsiElement(7);
    }

    public boolean isDeprecated() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        PsiDocComment docComment = this.getDocComment();
        return docComment != null && docComment.findTagByName("deprecated") != null || this.getModifierList().findAnnotation("java.lang.Deprecated") != null;
    }

    @Override
    public PsiReference getReference() {
        return this.myReference;
    }

    public PsiMethod resolveConstructor() {
        return this.resolveMethod();
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = PsiEnumConstantImpl.createLayeredIcon((Icon)Icons.FIELD_ICON, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getFieldPresentation((PsiField)this);
    }

    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo((PsiField)this, another);
    }

    public PsiType getTypeNoResolve() {
        return this.getType();
    }

    private class MyReference
    implements PsiJavaReference {
        private MyReference() {
        }

        public PsiElement getElement() {
            return PsiEnumConstantImpl.this;
        }

        public TextRange getRangeInElement() {
            PsiIdentifier nameIdentifier = PsiEnumConstantImpl.this.getNameIdentifier();
            int startOffsetInParent = nameIdentifier.getStartOffsetInParent();
            return new TextRange(startOffsetInParent, startOffsetInParent + nameIdentifier.getTextLength());
        }

        public boolean isSoft() {
            return false;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return this.getElement();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference.bindToElement must not be null");
            }
            throw new IncorrectOperationException("Invalid operation");
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference.getVariants must not return null");
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public void processVariants(PsiScopeProcessor processor) {
        }

        @NotNull
        public JavaResolveResult[] multiResolve(boolean incompleteCode) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)PsiEnumConstantImpl.this.getProject());
            PsiClassType type = facade.getElementFactory().createType(PsiEnumConstantImpl.this.getContainingClass());
            JavaResolveResult[] javaResolveResultArray = facade.getResolveHelper().multiResolveConstructor(type, PsiEnumConstantImpl.this.getArgumentList(), this.getElement());
            if (javaResolveResultArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference.multiResolve must not return null");
            }
            return javaResolveResultArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public JavaResolveResult advancedResolve(boolean incompleteCode) {
            JavaResolveResult javaResolveResult;
            JavaResolveResult[] results = this.multiResolve(incompleteCode);
            if (results.length == 1) {
                javaResolveResult = results[0];
                if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference.advancedResolve must not return null");
                return javaResolveResult;
            }
            javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult != null) return javaResolveResult;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference.advancedResolve must not return null");
        }

        public PsiElement resolve() {
            return this.advancedResolve(false).getElement();
        }

        public String getCanonicalText() {
            return PsiEnumConstantImpl.this.getContainingClass().getName();
        }

        public boolean isReferenceTo(PsiElement element) {
            return element instanceof PsiMethod && ((PsiMethod)element).isConstructor() && ((PsiMethod)element).getContainingClass() == PsiEnumConstantImpl.this.getContainingClass() && PsiEnumConstantImpl.this.getManager().areElementsEquivalent(this.resolve(), element);
        }
    }
}

