/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeInfoImpl
implements ChangeInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.ChangeInfoImpl");
    final String newVisibility;
    private PsiMethod method;
    final String oldName;
    final String oldType;
    final String[] oldParameterNames;
    final String[] oldParameterTypes;
    final String newName;
    final CanonicalTypes.Type newReturnType;
    final ParameterInfoImpl[] newParms;
    ThrownExceptionInfo[] newExceptions;
    final boolean[] toRemoveParm;
    boolean isVisibilityChanged;
    boolean isNameChanged;
    boolean isReturnTypeChanged;
    boolean isParameterSetOrOrderChanged;
    boolean isExceptionSetChanged;
    boolean isExceptionSetOrOrderChanged;
    boolean isParameterNamesChanged;
    boolean isParameterTypesChanged;
    boolean isPropagationEnabled;
    final boolean wasVararg;
    final boolean retainsVarargs;
    final boolean obtainsVarags;
    final boolean arrayToVarargs;
    PsiIdentifier newNameIdentifier;
    PsiType newTypeElement;
    final PsiExpression[] defaultValues;

    public ChangeInfoImpl(@Modifier String newVisibility, PsiMethod method, String newName, CanonicalTypes.Type newType, @NotNull ParameterInfoImpl[] newParms, ThrownExceptionInfo[] newExceptions) {
        int i;
        if (newParms == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/refactoring/changeSignature/ChangeInfoImpl.<init> must not be null");
        }
        this.isVisibilityChanged = false;
        this.isNameChanged = false;
        this.isReturnTypeChanged = false;
        this.isParameterSetOrOrderChanged = false;
        this.isExceptionSetChanged = false;
        this.isExceptionSetOrOrderChanged = false;
        this.isParameterNamesChanged = false;
        this.isParameterTypesChanged = false;
        this.isPropagationEnabled = true;
        this.newVisibility = newVisibility;
        this.method = method;
        this.newName = newName;
        this.newReturnType = newType;
        this.newParms = newParms;
        this.wasVararg = method.isVarArgs();
        this.oldName = method.getName();
        PsiManager manager = method.getManager();
        this.oldType = !method.isConstructor() ? JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeElement(method.getReturnType()).getText() : null;
        PsiParameter[] parameters = method.getParameterList().getParameters();
        this.oldParameterNames = new String[parameters.length];
        this.oldParameterTypes = new String[parameters.length];
        for (i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            this.oldParameterNames[i] = parameter.getName();
            this.oldParameterTypes[i] = JavaPsiFacade.getInstance((Project)parameter.getProject()).getElementFactory().createTypeElement(parameter.getType()).getText();
        }
        this.isVisibilityChanged = !method.hasModifierProperty(newVisibility);
        boolean bl = this.isNameChanged = !newName.equals(this.oldName);
        if (!method.isConstructor()) {
            try {
                this.isReturnTypeChanged = !this.newReturnType.getType((PsiElement)this.method, manager).equals(this.method.getReturnType());
            }
            catch (IncorrectOperationException e) {
                this.isReturnTypeChanged = true;
            }
        }
        if (parameters.length != newParms.length) {
            this.isParameterSetOrOrderChanged = true;
        } else {
            for (i = 0; i < newParms.length; ++i) {
                ParameterInfoImpl parmInfo = newParms[i];
                PsiParameter parameter = parameters[i];
                if (i != parmInfo.oldParameterIndex) {
                    this.isParameterSetOrOrderChanged = true;
                    break;
                }
                if (!parmInfo.getName().equals(parameter.getName())) {
                    this.isParameterNamesChanged = true;
                }
                try {
                    if (parmInfo.createType((PsiElement)method, manager).equals(parameter.getType())) continue;
                    this.isParameterTypesChanged = true;
                    continue;
                }
                catch (IncorrectOperationException e) {
                    this.isParameterTypesChanged = true;
                }
            }
        }
        this.setupPropagationEnabled(parameters, newParms);
        this.setupExceptions(newExceptions, method);
        this.toRemoveParm = new boolean[parameters.length];
        Arrays.fill(this.toRemoveParm, true);
        for (ParameterInfoImpl info : newParms) {
            if (info.oldParameterIndex < 0) continue;
            this.toRemoveParm[info.oldParameterIndex] = false;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        this.defaultValues = new PsiExpression[newParms.length];
        for (int i2 = 0; i2 < newParms.length; ++i2) {
            ParameterInfoImpl info = newParms[i2];
            if (info.oldParameterIndex >= 0 || info.isVarargType() || info.defaultValue == null) continue;
            try {
                this.defaultValues[i2] = factory.createExpressionFromText(info.defaultValue, (PsiElement)method);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.newParms.length == 0) {
            this.retainsVarargs = false;
            this.obtainsVarags = false;
            this.arrayToVarargs = false;
        } else {
            PsiType oldTypeForVararg;
            ParameterInfoImpl lastNewParm = this.newParms[this.newParms.length - 1];
            this.obtainsVarags = lastNewParm.isVarargType();
            boolean bl2 = this.retainsVarargs = lastNewParm.oldParameterIndex >= 0 && this.obtainsVarags;
            this.arrayToVarargs = this.retainsVarargs ? (oldTypeForVararg = parameters[lastNewParm.oldParameterIndex].getType()) instanceof PsiArrayType && !(oldTypeForVararg instanceof PsiEllipsisType) : false;
        }
    }

    @NotNull
    public ParameterInfo[] getNewParameters() {
        if (this.newParms == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/changeSignature/ChangeInfoImpl.getNewParameters must not return null");
        }
        return this.newParms;
    }

    public boolean isParameterSetOrOrderChanged() {
        return this.isParameterSetOrOrderChanged;
    }

    private void setupExceptions(ThrownExceptionInfo[] newExceptions, PsiMethod method) {
        if (newExceptions == null) {
            newExceptions = ChangeInfoImpl.extractExceptions(method);
        }
        this.newExceptions = newExceptions;
        PsiClassType[] types = method.getThrowsList().getReferencedTypes();
        boolean bl = this.isExceptionSetChanged = newExceptions.length != types.length;
        if (!this.isExceptionSetChanged) {
            for (int i = 0; i < newExceptions.length; ++i) {
                try {
                    if (newExceptions[i].oldIndex < 0 || !types[i].equals((Object)newExceptions[i].myType.getType((PsiElement)method, method.getManager()))) {
                        this.isExceptionSetChanged = true;
                        break;
                    }
                }
                catch (IncorrectOperationException e) {
                    this.isExceptionSetChanged = true;
                }
                if (newExceptions[i].oldIndex == i) continue;
                this.isExceptionSetOrOrderChanged = true;
            }
        }
        this.isExceptionSetOrOrderChanged |= this.isExceptionSetChanged;
    }

    private void setupPropagationEnabled(PsiParameter[] parameters, ParameterInfoImpl[] newParms) {
        if (parameters.length >= newParms.length) {
            this.isPropagationEnabled = false;
        } else {
            for (int i = 0; i < parameters.length; ++i) {
                ParameterInfoImpl newParm = newParms[i];
                if (newParm.oldParameterIndex == i) continue;
                this.isPropagationEnabled = false;
                break;
            }
        }
    }

    private static ThrownExceptionInfo[] extractExceptions(PsiMethod method) {
        PsiClassType[] types = method.getThrowsList().getReferencedTypes();
        ThrownExceptionInfo[] result = new ThrownExceptionInfo[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ThrownExceptionInfo(i, types[i]);
        }
        return result;
    }

    public PsiMethod getMethod() {
        return this.method;
    }

    public void updateMethod(PsiMethod method) {
        this.method = method;
    }

    public ParameterInfoImpl[] getCreatedParmsInfoWithoutVarargs() {
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        for (ParameterInfoImpl newParm : this.newParms) {
            if (newParm.oldParameterIndex >= 0 || newParm.isVarargType()) continue;
            result.add(newParm);
        }
        return result.toArray(new ParameterInfoImpl[result.size()]);
    }

    @Nullable
    public PsiExpression getValue(int i, PsiCallExpression expr) throws IncorrectOperationException {
        if (this.defaultValues[i] != null) {
            return this.defaultValues[i];
        }
        return this.newParms[i].getValue(expr);
    }
}

