/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import gnu.trove.THashSet;
import java.util.Set;

public class FileTreeAccessFilter
implements VirtualFileFilter {
    protected final Set<VirtualFile> myAddedClasses = new THashSet();
    private boolean myTreeAccessAllowed;

    public boolean accept(VirtualFile file) {
        if (file instanceof VirtualFileWindow) {
            return false;
        }
        if (this.myAddedClasses.contains(file) || this.myTreeAccessAllowed) {
            return false;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFile(file);
        return (fileType == StdFileTypes.JAVA || fileType == StdFileTypes.CLASS) && !file.getName().equals("package-info.java");
    }

    public void allowTreeAccessForFile(VirtualFile file) {
        this.myAddedClasses.add(file);
    }

    public void allowTreeAccessForAllFiles() {
        this.myTreeAccessAllowed = true;
    }
}

