/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RegExpElementImpl
extends ASTWrapperPsiElement
implements RegExpElement {
    public RegExpElementImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        RegExpLanguage regExpLanguage = RegExpLanguage.INSTANCE;
        if (regExpLanguage == null) {
            throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpElementImpl.getLanguage must not return null");
        }
        return regExpLanguage;
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = super.getNode();
        if (aSTNode == null) {
            throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpElementImpl.getNode must not return null");
        }
        return aSTNode;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": <" + this.getUnescapedText() + ">";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/lang/regexp/psi/impl/RegExpElementImpl.accept must not be null");
        }
        if (visitor instanceof RegExpElementVisitor) {
            this.accept((RegExpElementVisitor)visitor);
        } else {
            super.accept(visitor);
        }
    }

    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpElement(this);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/lang/regexp/psi/impl/RegExpElementImpl.replace must not be null");
        }
        ASTNode node = psiElement.getNode();
        assert (node != null);
        this.getNode().getTreeParent().replaceChild(this.getNode(), node);
        return psiElement;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.getNode().getTreeParent().removeChild(this.getNode());
    }

    @Override
    public final String getUnescapedText() {
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix(this)) {
            return this.getText();
        }
        return InjectedLanguageManager.getInstance((Project)this.getProject()).getUnescapedText((PsiElement)this);
    }

    public static boolean isLiteralExpression(@Nullable PsiElement context) {
        if (context == null) {
            return false;
        }
        ASTNode astNode = context.getNode();
        if (astNode == null) {
            return false;
        }
        IElementType elementType = astNode.getElementType();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(context.getLanguage());
        return parserDefinition.getStringLiteralElements().contains(elementType);
    }
}

