/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.projectRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.cls.BytePointer;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.cls.ClsUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdkConfigurable;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;

public class IdeaJdk
extends SdkType
implements JavaSdkType {
    private static final Icon ADD_SDK = IconLoader.getIcon((String)"/add_sdk.png");
    private static final Icon SDK_OPEN = IconLoader.getIcon((String)"/sdk_open.png");
    private static final Icon SDK_CLOSED = IconLoader.getIcon((String)"/sdk_closed.png");
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.devkit.projectRoots.IdeaJdk");
    @NonNls
    private static final String JAVA_HOME_PROPERTY = "java.home";
    @NonNls
    private static final String LIB_DIR_NAME = "lib";
    @NonNls
    private static final String SRC_DIR_NAME = "src";
    @NonNls
    private static final String JRE_DIR_NAME = "jre";
    @NonNls
    private static final String PLUGINS_DIR = "plugins";
    @NonNls
    private static final String JAVAEE_DIR = "JavaEE";
    @NonNls
    private static final String JSF_DIR = "JSF";
    @NonNls
    private static final String PERSISTENCE_SUPPORT = "PersistenceSupport";
    @NonNls
    private static final String DATABASE_DIR = "DatabaseSupport";
    @NonNls
    private static final String CSS_DIR = "css";

    public IdeaJdk() {
        super("IDEA JDK");
    }

    public Icon getIcon() {
        return SDK_CLOSED;
    }

    public Icon getIconForExpandedTreeNode() {
        return SDK_OPEN;
    }

    public Icon getIconForAddAction() {
        return ADD_SDK;
    }

    public String suggestHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    public boolean isValidSdkHome(String path) {
        if (IdeaJdk.isFromIDEAProject(path)) {
            return true;
        }
        File home = new File(path);
        if (!home.exists()) {
            return false;
        }
        return IdeaJdk.getBuildNumber(path) != null && IdeaJdk.getOpenApiJar(path) != null;
    }

    private static File getOpenApiJar(String home) {
        String openapiJar = "openapi.jar";
        String platformApiJar = "platform-api.jar";
        File libDir = new File(home, LIB_DIR_NAME);
        File f = new File(libDir, "openapi.jar");
        if (f.exists()) {
            return f;
        }
        f = new File(libDir, "platform-api.jar");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public static boolean isFromIDEAProject(String path) {
        File home = new File(path);
        File[] openapiDir = home.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                return name.equals("openapi") && pathname.isDirectory();
            }
        });
        return openapiDir != null && openapiDir.length != 0;
    }

    @Nullable
    public final String getVersionString(Sdk sdk) {
        Sdk internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk);
        return internalJavaSdk != null ? internalJavaSdk.getVersionString() : null;
    }

    @Nullable
    private static Sdk getInternalJavaSdk(Sdk sdk) {
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        if (data instanceof Sandbox) {
            return ((Sandbox)data).getJavaSdk();
        }
        return null;
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        String productName = new File(sdkHome, "lib/rubymine.jar").exists() ? "RubyMine " : "IDEA ";
        String buildNumber = IdeaJdk.getBuildNumber(sdkHome);
        return productName + (buildNumber != null ? buildNumber : "");
    }

    @Nullable
    private static String getBuildNumber(String ideaHome) {
        try {
            String buildTxt = "/build.txt";
            return new String(FileUtil.loadFileText((File)new File(ideaHome + "/build.txt"))).trim();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static VirtualFile[] getIdeaLibrary(String home) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        IdeaJdk.appendIdeaLibrary(home + File.separator + LIB_DIR_NAME, "idea.jar", result);
        IdeaJdk.appendIdeaLibrary(home + File.separator + PLUGINS_DIR + File.separator + JAVAEE_DIR + File.separator + LIB_DIR_NAME, "javaee-impl.jar", result);
        IdeaJdk.appendIdeaLibrary(home + File.separator + PLUGINS_DIR + File.separator + JSF_DIR + File.separator + LIB_DIR_NAME, "jsf-impl.jar", result);
        IdeaJdk.appendIdeaLibrary(home + File.separator + PLUGINS_DIR + File.separator + PERSISTENCE_SUPPORT + File.separator + LIB_DIR_NAME, "persistence-impl.jar", result);
        IdeaJdk.appendIdeaLibrary(home + File.separator + PLUGINS_DIR + File.separator + DATABASE_DIR + File.separator + LIB_DIR_NAME, "database-impl.jar", result);
        IdeaJdk.appendIdeaLibrary(home + File.separator + PLUGINS_DIR + File.separator + CSS_DIR + File.separator + LIB_DIR_NAME, "css.jar", result);
        return VfsUtil.toVirtualFileArray(result);
    }

    private static void appendIdeaLibrary(String path, @NonNls String forbidden, ArrayList<VirtualFile> result) {
        File[] jars;
        JarFileSystem jfs = JarFileSystem.getInstance();
        File lib = new File(path);
        if (lib.isDirectory() && (jars = lib.listFiles()) != null) {
            for (File jar : jars) {
                String name = jar.getName();
                if (!jar.isFile() || name.equals(forbidden) || !name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                result.add(jfs.findFileByPath(jar.getPath() + "!/"));
            }
        }
    }

    public boolean setupSdkPaths(Sdk sdk, SdkModel sdkModel) {
        Sdk[] sdks;
        Sandbox additionalData = (Sandbox)sdk.getSdkAdditionalData();
        if (additionalData != null) {
            additionalData.cleanupWatchedRoots();
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        ArrayList<String> javaSdks = new ArrayList<String>();
        for (Sdk jdk : sdks = sdkModel.getSdks()) {
            if (!IdeaJdk.isValidInternalJdk(sdk, jdk)) continue;
            javaSdks.add(jdk.getName());
        }
        if (javaSdks.isEmpty()) {
            JDKVersion requiredVer = IdeaJdk.getRequiredJdkVersion(sdk);
            if (requiredVer != null) {
                Messages.showErrorDialog((String)DevKitBundle.message("no.java.sdk.for.idea.sdk.found", new Object[]{requiredVer}), (String)"No Java SDK found");
            } else {
                Messages.showErrorDialog((String)DevKitBundle.message("no.idea.sdk.version.found", new Object[0]), (String)"No Java SDK found");
            }
            return false;
        }
        int choice = Messages.showChooseDialog((String)"Select Java SDK to be used as IDEA internal platform", (String)"Select internal Java platform", (String[])ArrayUtil.toStringArray(javaSdks), (String)((String)javaSdks.get(0)), (Icon)Messages.getQuestionIcon());
        if (choice != -1) {
            String name = (String)javaSdks.get(choice);
            Sdk jdk = sdkModel.findSdk(name);
            LOG.assertTrue(jdk != null);
            IdeaJdk.setupSdkPaths(sdkModificator, sdk.getHomePath(), jdk);
            sdkModificator.setSdkAdditionalData((SdkAdditionalData)new Sandbox(IdeaJdk.getDefaultSandbox(), jdk, sdk));
            sdkModificator.setVersionString(jdk.getVersionString());
            sdkModificator.commitChanges();
            return true;
        }
        return false;
    }

    public static boolean isValidInternalJdk(Sdk ideaSdk, Sdk sdk) {
        SdkType sdkType = sdk.getSdkType();
        if (sdkType instanceof JavaSdk) {
            String versionString = sdkType.getVersionString(sdk);
            JDKVersion requiredJdkVersion = IdeaJdk.getRequiredJdkVersion(ideaSdk);
            if (versionString != null && requiredJdkVersion != null) {
                for (JDKVersion version : JDKVersion.values()) {
                    if (!versionString.contains(version.getPresentation())) continue;
                    return requiredJdkVersion.compareTo(version) <= 0;
                }
                return true;
            }
        }
        return false;
    }

    private static int getIdeaClassFileVersion(Sdk ideaSdk) {
        int result = -1;
        File apiJar = IdeaJdk.getOpenApiJar(ideaSdk.getHomePath());
        if (apiJar == null) {
            return -1;
        }
        VirtualFile mainClassFile = JarFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)apiJar.getPath()) + "!/com/intellij/psi/PsiManager.class");
        if (mainClassFile != null) {
            try {
                BytePointer ptr = new BytePointer(mainClassFile.contentsToByteArray(), 6);
                result = ClsUtil.readU2((BytePointer)ptr);
            }
            catch (IOException e) {
            }
            catch (ClsFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    private static JDKVersion getRequiredJdkVersion(Sdk ideaSdk) {
        int classFileVersion = IdeaJdk.getIdeaClassFileVersion(ideaSdk);
        JDKVersion requiredJdkVersion = null;
        switch (classFileVersion) {
            case 48: {
                requiredJdkVersion = JDKVersion.V1_4;
                break;
            }
            case 49: {
                requiredJdkVersion = JDKVersion.V1_5;
                break;
            }
            case 50: {
                requiredJdkVersion = JDKVersion.V1_6;
            }
        }
        return requiredJdkVersion;
    }

    public static void setupSdkPaths(SdkModificator sdkModificator, String sdkHome, Sdk internalJava) {
        IdeaJdk.addClasses(sdkModificator, internalJava);
        IdeaJdk.addDocs(sdkModificator, internalJava);
        IdeaJdk.addSources(sdkModificator, internalJava);
        if (!IdeaJdk.isFromIDEAProject(sdkHome)) {
            VirtualFile[] ideaLib = IdeaJdk.getIdeaLibrary(sdkHome);
            if (ideaLib != null) {
                for (VirtualFile aIdeaLib : ideaLib) {
                    sdkModificator.addRoot(aIdeaLib, OrderRootType.CLASSES);
                }
            }
            IdeaJdk.addSources(new File(sdkHome), sdkModificator);
            IdeaJdk.addDocs(new File(sdkHome), sdkModificator);
        }
    }

    static String getDefaultSandbox() {
        String defaultSandbox = "";
        try {
            defaultSandbox = new File(PathManager.getSystemPath()).getCanonicalPath() + File.separator + "plugins-sandbox";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return defaultSandbox;
    }

    private static void addSources(File file, SdkModificator sdkModificator) {
        File src = new File(new File(file, LIB_DIR_NAME), SRC_DIR_NAME);
        if (!src.exists()) {
            return;
        }
        File[] srcs = src.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String path = pathname.getPath();
                if (path.indexOf("generics") > -1) {
                    return false;
                }
                return path.endsWith(".jar") || path.endsWith(".zip");
            }
        });
        for (int i = 0; srcs != null && i < srcs.length; ++i) {
            File jarFile = srcs[i];
            if (!jarFile.exists()) continue;
            JarFileSystem jarFileSystem = JarFileSystem.getInstance();
            String path = jarFile.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
            jarFileSystem.setNoCopyJarForPath(path);
            VirtualFile vFile = jarFileSystem.findFileByPath(path);
            sdkModificator.addRoot(vFile, OrderRootType.SOURCES);
        }
    }

    private static void addDocs(File file, final SdkModificator sdkModificator) {
        String help = "help";
        String openapi = "openapi";
        final File docFile = new File(new File(file, "help"), "openapi");
        if (docFile.exists() && docFile.isDirectory()) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    sdkModificator.addRoot(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(docFile), JavadocOrderRootType.getInstance());
                }
            });
            return;
        }
        String openapiHelpJar = "openapihelp.jar";
        File jarfile = new File(new File(file, "help"), "openapihelp.jar");
        if (jarfile.exists()) {
            JarFileSystem jarFileSystem = JarFileSystem.getInstance();
            String path = jarfile.getAbsolutePath().replace(File.separatorChar, '/') + "!/" + "openapi";
            jarFileSystem.setNoCopyJarForPath(path);
            VirtualFile vFile = jarFileSystem.findFileByPath(path);
            sdkModificator.addRoot(vFile, JavadocOrderRootType.getInstance());
        }
    }

    private static void addClasses(SdkModificator sdkModificator, Sdk javaSdk) {
        IdeaJdk.addOrderEntries(OrderRootType.CLASSES, javaSdk, sdkModificator);
    }

    private static void addDocs(SdkModificator sdkModificator, Sdk javaSdk) {
        if (!IdeaJdk.addOrderEntries(JavadocOrderRootType.getInstance(), javaSdk, sdkModificator) && SystemInfo.isMac) {
            Sdk[] jdks;
            for (Sdk jdk : jdks = ProjectJdkTable.getInstance().getAllJdks()) {
                if (!(jdk.getSdkType() instanceof JavaSdk)) continue;
                IdeaJdk.addOrderEntries(JavadocOrderRootType.getInstance(), jdk, sdkModificator);
                break;
            }
        }
    }

    private static void addSources(SdkModificator sdkModificator, Sdk javaSdk) {
        if (javaSdk != null && !IdeaJdk.addOrderEntries(OrderRootType.SOURCES, javaSdk, sdkModificator)) {
            if (SystemInfo.isMac) {
                Sdk[] jdks;
                for (Sdk jdk : jdks = ProjectJdkTable.getInstance().getAllJdks()) {
                    if (!(jdk.getSdkType() instanceof JavaSdk)) continue;
                    IdeaJdk.addOrderEntries(OrderRootType.SOURCES, jdk, sdkModificator);
                    break;
                }
            } else {
                File jdkHome = new File(javaSdk.getHomePath()).getParentFile();
                String srcZip = "src.zip";
                File jarFile = new File(jdkHome, "src.zip");
                if (jarFile.exists()) {
                    JarFileSystem jarFileSystem = JarFileSystem.getInstance();
                    String path = jarFile.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
                    jarFileSystem.setNoCopyJarForPath(path);
                    sdkModificator.addRoot(jarFileSystem.findFileByPath(path), OrderRootType.SOURCES);
                }
            }
        }
    }

    private static boolean addOrderEntries(OrderRootType orderRootType, Sdk sdk, SdkModificator toModificator) {
        String[] entries;
        boolean wasSmthAdded = false;
        for (String entry : entries = sdk.getRootProvider().getUrls(orderRootType)) {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(entry);
            if (virtualFile == null) continue;
            toModificator.addRoot(virtualFile, orderRootType);
            wasSmthAdded = true;
        }
        return wasSmthAdded;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel sdkModel, SdkModificator sdkModificator) {
        final IdeaJdkConfigurable jdkConfigurable = new IdeaJdkConfigurable(sdkModel, sdkModificator);
        sdkModel.addListener(new SdkModel.Listener(){

            public void sdkAdded(Sdk sdk) {
                if (sdk.getSdkType().equals((Object)JavaSdk.getInstance())) {
                    jdkConfigurable.addJavaSdk(sdk);
                }
            }

            public void beforeSdkRemove(Sdk sdk) {
                if (sdk.getSdkType().equals((Object)JavaSdk.getInstance())) {
                    jdkConfigurable.removeJavaSdk(sdk);
                }
            }

            public void sdkChanged(Sdk sdk, String previousName) {
                if (sdk.getSdkType().equals((Object)JavaSdk.getInstance())) {
                    jdkConfigurable.updateJavaSdkList(sdk, previousName);
                }
            }

            public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
                if (sdk.getSdkType() instanceof IdeaJdk) {
                    jdkConfigurable.internalJdkUpdate(sdk);
                }
            }
        });
        return jdkConfigurable;
    }

    @Nullable
    public String getBinPath(Sdk sdk) {
        Sdk internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk);
        return internalJavaSdk == null ? null : JavaSdk.getInstance().getBinPath(internalJavaSdk);
    }

    @Nullable
    public String getToolsPath(Sdk sdk) {
        Sdk jdk = IdeaJdk.getInternalJavaSdk(sdk);
        if (jdk != null && jdk.getVersionString() != null) {
            return JavaSdk.getInstance().getToolsPath(jdk);
        }
        return null;
    }

    @Nullable
    public String getVMExecutablePath(Sdk sdk) {
        Sdk internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk);
        return internalJavaSdk == null ? null : JavaSdk.getInstance().getVMExecutablePath(internalJavaSdk);
    }

    public void saveAdditionalData(SdkAdditionalData additionalData, Element additional) {
        if (additionalData instanceof Sandbox) {
            try {
                ((Sandbox)additionalData).writeExternal(additional);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public SdkAdditionalData loadAdditionalData(Sdk sdk, Element additional) {
        Sandbox sandbox = new Sandbox(sdk);
        try {
            sandbox.readExternal(additional);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        return sandbox;
    }

    public String getPresentableName() {
        return DevKitBundle.message("sdk.title", new Object[0]);
    }

    @Nullable
    public static Sdk findIdeaJdk(@Nullable Sdk jdk) {
        if (jdk == null) {
            return null;
        }
        if (jdk.getSdkType() instanceof IdeaJdk) {
            return jdk;
        }
        return null;
    }

    public static SdkType getInstance() {
        return SdkType.findInstance(IdeaJdk.class);
    }

    static enum JDKVersion {
        V1_4("1.4"),
        V1_5("1.5"),
        V1_6("1.6");

        private String myPresentation;

        private JDKVersion(String presentation) {
            this.myPresentation = presentation;
        }

        public String getPresentation() {
            return this.myPresentation;
        }
    }
}

