/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.gpp.GppClosureParameterTypeProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;

public class GppReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(GrArgumentLabel.class), new PsiReferenceProvider(){

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                PsiReference[] psiReferenceArray;
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppReferenceContributor$1.getReferencesByElement must not be null");
                }
                if (context == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppReferenceContributor$1.getReferencesByElement must not be null");
                }
                PsiElement parent = element.getParent();
                if (parent instanceof GrNamedArgument && parent.getParent() instanceof GrListOrMap) {
                    psiReferenceArray = new PsiReference[]{new GppMapMemberReference(element)};
                    if (psiReferenceArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gpp/GppReferenceContributor$1.getReferencesByElement must not return null");
                    return psiReferenceArray;
                }
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
                if (PsiReference.EMPTY_ARRAY != null) return psiReferenceArray;
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gpp/GppReferenceContributor$1.getReferencesByElement must not return null");
            }
        });
    }

    private static class GppMapMemberReference
    extends PsiReferenceBase<GrArgumentLabel> {
        public GppMapMemberReference(PsiElement element) {
            super((PsiElement)((GrArgumentLabel)element));
        }

        public boolean isReferenceTo(PsiElement element) {
            return element instanceof PsiMethod && super.isReferenceTo(element);
        }

        public PsiElement resolve() {
            GrNamedArgument namedArgument = (GrNamedArgument)((GrArgumentLabel)this.getElement()).getParent();
            for (PsiType type : GroovyExpectedTypesProvider.getDefaultExpectedTypes((GrExpression)((GrExpression)namedArgument.getParent()))) {
                if (!(type instanceof PsiClassType)) continue;
                GrExpression value = namedArgument.getExpression();
                if (value != null && InheritanceUtil.isInheritor((PsiType)value.getType(), (String)"groovy.lang.Closure")) {
                    Pair<PsiMethod, PsiSubstitutor> method = GppClosureParameterTypeProvider.getOverriddenMethod(namedArgument);
                    if (method == null) continue;
                    return (PsiElement)method.first;
                }
                PsiClass psiClass = ((PsiClassType)type).resolve();
                if (psiClass == null) continue;
                String propertyName = this.getValue();
                PsiMethod setter = PropertyUtil.findPropertySetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true);
                if (setter != null) {
                    return setter;
                }
                return PropertyUtil.findPropertyField((Project)psiClass.getProject(), (PsiClass)psiClass, (String)propertyName, (boolean)false);
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gpp/GppReferenceContributor$GppMapMemberReference.getVariants must not return null");
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

