/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ConditionalUtils;
import com.siyeh.ipp.psiutils.EquivalenceChecker;
import com.siyeh.ipp.psiutils.ErrorUtil;

class SimplifyIfElsePredicate
implements PsiElementPredicate {
    SimplifyIfElsePredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiElement parent = token.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        if (ErrorUtil.containsError((PsiElement)ifStatement)) {
            return false;
        }
        PsiExpression condition = ifStatement.getCondition();
        if (condition == null) {
            return false;
        }
        if (SimplifyIfElsePredicate.isSimplifiableAssignment(ifStatement)) {
            return true;
        }
        if (SimplifyIfElsePredicate.isSimplifiableReturn(ifStatement)) {
            return true;
        }
        if (SimplifyIfElsePredicate.isSimplifiableImplicitReturn(ifStatement)) {
            return true;
        }
        if (SimplifyIfElsePredicate.isSimplifiableAssignmentNegated(ifStatement)) {
            return true;
        }
        if (SimplifyIfElsePredicate.isSimplifiableReturnNegated(ifStatement)) {
            return true;
        }
        if (SimplifyIfElsePredicate.isSimplifiableImplicitReturnNegated(ifStatement)) {
            return true;
        }
        if (SimplifyIfElsePredicate.isSimplifiableImplicitAssignment(ifStatement)) {
            return true;
        }
        return SimplifyIfElsePredicate.isSimplifiableImplicitAssignmentNegated(ifStatement);
    }

    public static boolean isSimplifiableImplicitReturn(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableImplicitReturnNegated(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(nextStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)nextStatement;
        return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
    }

    public static boolean isSimplifiableReturn(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableReturnNegated(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
    }

    public static boolean isSimplifiableAssignment(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (!ConditionalUtils.isAssignment(thenBranch, "true") || !ConditionalUtils.isAssignment(elseBranch, "false")) {
            return false;
        }
        PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
        PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenExpressionStatement.getExpression();
        PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
        PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseExpressionStatement.getExpression();
        PsiJavaToken thenSign = thenExpression.getOperationSign();
        PsiJavaToken elseSign = elseExpression.getOperationSign();
        IElementType thenTokenType = thenSign.getTokenType();
        if (!thenTokenType.equals(elseSign.getTokenType())) {
            return false;
        }
        PsiExpression thenLhs = thenExpression.getLExpression();
        PsiExpression elseLhs = elseExpression.getLExpression();
        return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
    }

    public static boolean isSimplifiableAssignmentNegated(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (!ConditionalUtils.isAssignment(thenBranch, "false") || !ConditionalUtils.isAssignment(elseBranch, "true")) {
            return false;
        }
        PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
        PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenExpressionStatement.getExpression();
        PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
        PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseExpressionStatement.getExpression();
        PsiJavaToken thenSign = thenExpression.getOperationSign();
        PsiJavaToken elseSign = elseExpression.getOperationSign();
        IElementType thenTokenType = thenSign.getTokenType();
        if (!thenTokenType.equals(elseSign.getTokenType())) {
            return false;
        }
        PsiExpression thenLhs = thenExpression.getLExpression();
        PsiExpression elseLhs = elseExpression.getLExpression();
        return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
    }

    public static boolean isSimplifiableImplicitAssignment(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement previousStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(previousStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)previousStatement;
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (!ConditionalUtils.isAssignment(thenBranch, "true") || !ConditionalUtils.isAssignment(elseBranch, "false")) {
            return false;
        }
        PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)((PsiExpressionStatement)thenBranch).getExpression();
        PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)((PsiExpressionStatement)elseBranch).getExpression();
        PsiJavaToken thenSign = thenExpression.getOperationSign();
        PsiJavaToken elseSign = elseExpression.getOperationSign();
        IElementType thenTokenType = thenSign.getTokenType();
        if (!thenTokenType.equals(elseSign.getTokenType())) {
            return false;
        }
        PsiExpression thenLhs = thenExpression.getLExpression();
        PsiExpression elseLhs = elseExpression.getLExpression();
        return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
    }

    public static boolean isSimplifiableImplicitAssignmentNegated(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement previousStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (!(previousStatement instanceof PsiStatement)) {
            return false;
        }
        PsiStatement elseBranch = (PsiStatement)previousStatement;
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (!ConditionalUtils.isAssignment(thenBranch, "false") || !ConditionalUtils.isAssignment(elseBranch, "true")) {
            return false;
        }
        PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenBranch;
        PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenExpressionStatement.getExpression();
        PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseBranch;
        PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseExpressionStatement.getExpression();
        PsiJavaToken thenSign = thenExpression.getOperationSign();
        PsiJavaToken elseSign = elseExpression.getOperationSign();
        IElementType thenTokenType = thenSign.getTokenType();
        if (!thenTokenType.equals(elseSign.getTokenType())) {
            return false;
        }
        PsiExpression thenLhs = thenExpression.getLExpression();
        PsiExpression elseLhs = elseExpression.getLExpression();
        return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
    }
}

