/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.LightCodeInsightTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class LightDaemonAnalyzerTestCase
extends LightCodeInsightTestCase {
    private final FileTreeAccessFilter myJavaFilesFilter = new FileTreeAccessFilter();

    protected void setUp() throws Exception {
        super.setUp();
        DaemonCodeAnalyzer.getInstance(LightDaemonAnalyzerTestCase.getProject()).projectOpened();
        DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
    }

    protected void tearDown() throws Exception {
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(LightDaemonAnalyzerTestCase.getProject());
        codeAnalyzer.projectClosed();
        super.tearDown();
    }

    protected void doTest(@NonNls String filePath, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.configureByFile(filePath);
        this.doTestConfiguredFile(checkWarnings, checkInfos);
    }

    protected void doTestConfiguredFile(boolean checkWarnings, boolean checkInfos) {
        LightDaemonAnalyzerTestCase.getJavaFacade().setAssertOnFileLoadingFilter(VirtualFileFilter.NONE);
        ExpectedHighlightingData expectedData = new ExpectedHighlightingData(LightDaemonAnalyzerTestCase.getEditor().getDocument(), checkWarnings, checkInfos);
        PsiDocumentManager.getInstance(LightDaemonAnalyzerTestCase.getProject()).commitAllDocuments();
        LightDaemonAnalyzerTestCase.getFile().getText();
        this.myJavaFilesFilter.allowTreeAccessForFile(LightDaemonAnalyzerTestCase.getVFile());
        LightDaemonAnalyzerTestCase.getJavaFacade().setAssertOnFileLoadingFilter((VirtualFileFilter)this.myJavaFilesFilter);
        List<HighlightInfo> infos = this.doHighlighting();
        LightDaemonAnalyzerTestCase.getJavaFacade().setAssertOnFileLoadingFilter(VirtualFileFilter.NONE);
        expectedData.checkResult(infos, LightDaemonAnalyzerTestCase.getEditor().getDocument().getText());
    }

    @NotNull
    protected List<HighlightInfo> doHighlighting() {
        int[] nArray;
        PsiDocumentManager.getInstance(LightDaemonAnalyzerTestCase.getProject()).commitAllDocuments();
        if (this.doFolding()) {
            nArray = ArrayUtil.EMPTY_INT_ARRAY;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        }
        int[] toIgnore = nArray;
        Editor editor = LightDaemonAnalyzerTestCase.getEditor();
        PsiFile file = LightDaemonAnalyzerTestCase.getFile();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file = InjectedLanguageUtil.getTopLevelFile((PsiElement)file);
        }
        List list = CodeInsightTestFixtureImpl.instantiateAndRun((PsiFile)file, (Editor)editor, (int[])toIgnore, (boolean)false);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/LightDaemonAnalyzerTestCase.doHighlighting must not return null");
        }
        return list;
    }

    protected boolean doFolding() {
        return false;
    }
}

