/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class SdkVersionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.SdkVersionUtil");

    private SdkVersionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readVersionFromProcessOutput(String homePath, @NonNls String[] command, @NonNls String versionLineMarker) {
        if (homePath == null || !new File(homePath).exists()) {
            return null;
        }
        String[] versionString = new String[1];
        try {
            Process process = Runtime.getRuntime().exec(command);
            VersionParsingThread parsingThread = new VersionParsingThread(process.getErrorStream(), versionString, versionLineMarker);
            Future<?> parsingThreadFuture = ApplicationManager.getApplication().executeOnPooledThread(parsingThread);
            ReadStreamThread readThread = new ReadStreamThread(process.getInputStream());
            ApplicationManager.getApplication().executeOnPooledThread(readThread);
            try {
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    LOG.info((Throwable)e);
                    process.destroy();
                }
            }
            finally {
                try {
                    parsingThreadFuture.get();
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        catch (IOException ex) {
            LOG.info((Throwable)ex);
        }
        return versionString[0];
    }

    public static class VersionParsingThread
    implements Runnable {
        private Reader myReader;
        private final InputStream myStream;
        private boolean mySkipLF = false;
        private final String[] myVersionString;
        private final String myVersionLineMarker;

        protected VersionParsingThread(InputStream input, String[] versionString, String versionLineMarker) {
            this.myStream = input;
            this.myVersionString = versionString;
            this.myVersionLineMarker = versionLineMarker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.myReader = new InputStreamReader(this.myStream);
                while (true) {
                    String line;
                    if ((line = this.readLine()) == null) {
                        return;
                    }
                    if (!line.contains(this.myVersionLineMarker)) continue;
                    this.myVersionString[0] = line;
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return;
            }
            finally {
                if (this.myReader != null) {
                    try {
                        this.myReader.close();
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        }

        private String readLine() throws IOException {
            int c;
            boolean first = true;
            StringBuilder buffer = new StringBuilder();
            while ((c = this.myReader.read()) != -1) {
                first = false;
                if (c == 10) {
                    if (!this.mySkipLF) break;
                    this.mySkipLF = false;
                    continue;
                }
                if (c == 13) {
                    this.mySkipLF = true;
                    break;
                }
                this.mySkipLF = false;
                buffer.append((char)c);
            }
            if (first) {
                return null;
            }
            String s = buffer.toString();
            return s;
        }
    }

    public static class ReadStreamThread
    implements Runnable {
        private final InputStream myStream;

        protected ReadStreamThread(InputStream stream) {
            this.myStream = stream;
        }

        @Override
        public void run() {
            try {
                int b;
                while ((b = this.myStream.read()) != -1) {
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }
}

