/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class UiNotifyConnector
implements Disposable,
HierarchyListener {
    private Component myComponent;
    private Activatable myTarget;

    public UiNotifyConnector(Component component, Activatable target) {
        this.myComponent = component;
        this.myTarget = target;
        if (component.isShowing()) {
            this.showNotify();
        } else {
            this.hideNotify();
        }
        component.addHierarchyListener(this);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (this.isDisposed()) {
            return;
        }
        if ((e.getChangeFlags() & 4L) > 0L) {
            DumbAwareRunnable runnable = new DumbAwareRunnable(){

                @Override
                public void run() {
                    if (UiNotifyConnector.this.isDisposed() || UiNotifyConnector.this.myComponent == null) {
                        return;
                    }
                    if (UiNotifyConnector.this.myComponent.isShowing()) {
                        UiNotifyConnector.this.showNotify();
                    } else {
                        UiNotifyConnector.this.hideNotify();
                    }
                }
            };
            Application app = ApplicationManager.getApplication();
            if (app != null && app.isDispatchThread()) {
                app.invokeLater((Runnable)runnable, ModalityState.current());
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    protected void hideNotify() {
        this.myTarget.hideNotify();
    }

    protected void showNotify() {
        this.myTarget.showNotify();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.myTarget.hideNotify();
        this.myComponent.removeHierarchyListener(this);
        this.myTarget = null;
        this.myComponent = null;
    }

    private boolean isDisposed() {
        return this.myTarget == null;
    }

    public static void doWhenFirstShown(@NotNull JComponent c, final @NotNull Runnable runnable) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/update/UiNotifyConnector.doWhenFirstShown must not be null");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ui/update/UiNotifyConnector.doWhenFirstShown must not be null");
        }
        new Once(c, new Activatable(){

            @Override
            public void showNotify() {
                runnable.run();
            }

            @Override
            public void hideNotify() {
            }
        });
    }

    public static class Once
    extends UiNotifyConnector {
        private boolean myShown;
        private boolean myHidden;

        public Once(Component component, Activatable target) {
            super(component, target);
        }

        @Override
        protected final void hideNotify() {
            super.hideNotify();
            this.myHidden = true;
            this.disposeIfNeeded();
        }

        @Override
        protected final void showNotify() {
            super.showNotify();
            this.myShown = true;
            this.disposeIfNeeded();
        }

        private void disposeIfNeeded() {
            if (this.myShown && this.myHidden) {
                Disposer.dispose((Disposable)this);
            }
        }
    }
}

