/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.SpellCheckerManager;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public abstract class ShowSuggestions
implements LocalQuickFix,
Iconable {
    private List<String> suggestions;
    private boolean processed;
    protected ProblemDescriptor myProblemDescriptor;

    @NotNull
    public List<String> getSuggestions() {
        if (!this.processed) {
            this.calculateSuggestions();
            this.processed = true;
        }
        List<String> list = this.suggestions;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/quickfixes/ShowSuggestions.getSuggestions must not return null");
        }
        return list;
    }

    private void calculateSuggestions() {
        SpellCheckerManager manager = SpellCheckerManager.getInstance(this.myProblemDescriptor.getPsiElement().getProject());
        this.suggestions = manager.getSuggestions(ProblemDescriptionNode.extractHighlightedText((CommonProblemDescriptor)this.myProblemDescriptor, (PsiElement)this.myProblemDescriptor.getPsiElement()));
    }

    public Icon getIcon(int flags) {
        return new ImageIcon(ShowSuggestions.class.getResource("spellcheck.png"));
    }

    public void setDescriptor(ProblemDescriptor problemDescriptor) {
        this.myProblemDescriptor = problemDescriptor;
    }
}

