/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.util.Objects;

public final class StackTraceElement
implements Serializable {
    private String declaringClass;
    private String methodName;
    private String fileName;
    private int lineNumber;
    private static final long serialVersionUID = 6992337162326171013L;

    public StackTraceElement(String string, String string2, String string3, int n) {
        this.declaringClass = Objects.nonNull(string, "Declaring class is null");
        this.methodName = Objects.nonNull(string2, "Method name is null");
        this.fileName = string3;
        this.lineNumber = n;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        return this.getClassName() + "." + this.methodName + (this.isNativeMethod() ? "(Native Method)" : (this.fileName != null && this.lineNumber >= 0 ? "(" + this.fileName + ":" + this.lineNumber + ")" : (this.fileName != null ? "(" + this.fileName + ")" : "(Unknown Source)")));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement stackTraceElement = (StackTraceElement)object;
        return stackTraceElement.declaringClass.equals(this.declaringClass) && stackTraceElement.lineNumber == this.lineNumber && Objects.equals(this.methodName, stackTraceElement.methodName) && Objects.equals(this.fileName, stackTraceElement.fileName);
    }

    public int hashCode() {
        int n = 31 * this.declaringClass.hashCode() + this.methodName.hashCode();
        n = 31 * n + Objects.hashCode(this.fileName);
        n = 31 * n + this.lineNumber;
        return n;
    }
}

