/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;

public class Utils {
    public static String getStatus(ThreadReference threadReference) {
        String string;
        int n = threadReference.status();
        switch (n) {
            case -1: {
                string = "unknown status";
                break;
            }
            case 0: {
                string = "zombie";
                break;
            }
            case 1: {
                string = "running";
                break;
            }
            case 2: {
                string = "sleeping";
                break;
            }
            case 3: {
                string = "waiting to acquire a monitor lock";
                break;
            }
            case 4: {
                string = "waiting on a condition";
                break;
            }
            default: {
                string = "<invalid thread status>";
            }
        }
        if (threadReference.isSuspended()) {
            string = string + " (suspended)";
        }
        return string;
    }

    public static String description(ObjectReference objectReference) {
        ReferenceType referenceType = objectReference.referenceType();
        long l = objectReference.uniqueID();
        if (referenceType == null) {
            return Utils.toHex(l);
        }
        return "(" + referenceType.name() + ")" + Utils.toHex(l);
    }

    public static String toHex(long l) {
        char[] cArray = new char[16];
        char[] cArray2 = new char[18];
        int n = 0;
        do {
            long l2 = l & 0xFL;
            cArray[n++] = (char)(l2 < 10L ? 48L + l2 : 97L + l2 - 10L);
        } while ((l >>>= 4) > 0L);
        cArray2[0] = 48;
        cArray2[1] = 120;
        int n2 = 2;
        while (--n >= 0) {
            cArray2[n2++] = cArray[n];
        }
        return new String(cArray2, 0, n2);
    }

    public static long fromHex(String string) {
        String string2;
        String string3 = string2 = string.startsWith("0x") ? string.substring(2).toLowerCase() : string.toLowerCase();
        if (string.length() == 0) {
            throw new NumberFormatException();
        }
        long l = 0L;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c >= '0' && c <= '9') {
                l = l * 16L + (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                l = l * 16L + (long)(c - 97 + 10);
                continue;
            }
            throw new NumberFormatException();
        }
        return l;
    }

    public static String locationString(Location location) {
        return location.declaringType().name() + "." + location.method().name() + "(), line=" + location.lineNumber();
    }

    public static boolean isValidMethodName(String string) {
        return Utils.isJavaIdentifier(string) || string.equals("<init>") || string.equals("<clinit>");
    }

    public static boolean isJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = string.codePointAt(0);
        if (!Character.isJavaIdentifierStart(n)) {
            return false;
        }
        for (int i = Character.charCount(n); i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isJavaIdentifierPart(n)) continue;
            return false;
        }
        return true;
    }
}

