/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

class OCSPChecker
extends PKIXCertPathChecker {
    static final String OCSP_ENABLE_PROP = "ocsp.enable";
    static final String OCSP_URL_PROP = "ocsp.responderURL";
    static final String OCSP_CERT_SUBJECT_PROP = "ocsp.responderCertSubjectName";
    static final String OCSP_CERT_ISSUER_PROP = "ocsp.responderCertIssuerName";
    static final String OCSP_CERT_NUMBER_PROP = "ocsp.responderCertSerialNumber";
    private static final String HEX_DIGITS = "0123456789ABCDEFabcdef";
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private int remainingCerts;
    private X509Certificate[] certs;
    private CertPath cp;
    private PKIXParameters pkixParams;
    private boolean onlyEECert = false;

    OCSPChecker(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathValidatorException {
        this(certPath, pKIXParameters, false);
    }

    OCSPChecker(CertPath certPath, PKIXParameters pKIXParameters, boolean bl) throws CertPathValidatorException {
        this.cp = certPath;
        this.pkixParams = pKIXParameters;
        this.onlyEECert = bl;
        List<? extends Certificate> list = this.cp.getCertificates();
        this.certs = list.toArray(new X509Certificate[list.size()]);
        this.init(false);
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
        this.remainingCerts = this.certs.length + 1;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        --this.remainingCerts;
        X509CertImpl x509CertImpl = null;
        try {
            x509CertImpl = X509CertImpl.toImpl((X509Certificate)certificate);
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException(certificateException);
        }
        if (this.onlyEECert && x509CertImpl.getBasicConstraints() != -1) {
            if (DEBUG != null) {
                DEBUG.println("Skipping revocation check, not end entity cert");
            }
            return;
        }
        String[] stringArray = OCSPChecker.getOCSPProperties();
        URI uRI = OCSPChecker.getOCSPServerURI(x509CertImpl, stringArray[0]);
        X500Principal x500Principal = null;
        X500Principal x500Principal2 = null;
        BigInteger bigInteger = null;
        if (stringArray[1] != null) {
            x500Principal = new X500Principal(stringArray[1]);
        } else if (stringArray[2] != null && stringArray[3] != null) {
            x500Principal2 = new X500Principal(stringArray[2]);
            String string = OCSPChecker.stripOutSeparators(stringArray[3]);
            bigInteger = new BigInteger(string, 16);
        } else if (stringArray[2] != null || stringArray[3] != null) {
            throw new CertPathValidatorException("Must specify both ocsp.responderCertIssuerName and ocsp.responderCertSerialNumber properties");
        }
        boolean bl = false;
        if (x500Principal != null || x500Principal2 != null) {
            bl = true;
        }
        X509Certificate x509Certificate = null;
        boolean bl2 = true;
        Object object6 = null;
        if (this.remainingCerts < this.certs.length) {
            x509Certificate = this.certs[this.remainingCerts];
            bl2 = false;
            if (!bl) {
                object6 = x509Certificate;
                if (DEBUG != null) {
                    DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                }
            }
        }
        if (bl2 || bl) {
            if (DEBUG != null && bl) {
                DEBUG.println("Searching trust anchors for responder's certificate");
            }
            if (!(object5 = this.pkixParams.getTrustAnchors().iterator()).hasNext()) {
                throw new CertPathValidatorException("Must specify at least one trust anchor");
            }
            object4 = x509CertImpl.getIssuerX500Principal();
            while (object5.hasNext() && (bl2 || bl)) {
                object3 = (TrustAnchor)object5.next();
                object2 = ((TrustAnchor)object3).getTrustedCert();
                object = ((X509Certificate)object2).getSubjectX500Principal();
                if (bl2 && ((X500Principal)object4).equals(object)) {
                    x509Certificate = object2;
                    bl2 = false;
                    if (!bl && object6 == null) {
                        object6 = object2;
                        if (DEBUG != null) {
                            DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                        }
                    }
                }
                if (!bl || (x500Principal == null || !x500Principal.equals(object)) && (x500Principal2 == null || bigInteger == null || !x500Principal2.equals(((X509Certificate)object2).getIssuerX500Principal()) || !bigInteger.equals(((X509Certificate)object2).getSerialNumber()))) continue;
                object6 = object2;
                bl = false;
            }
            if (x509Certificate == null) {
                throw new CertPathValidatorException("No trusted certificate for " + x509CertImpl.getIssuerDN());
            }
            if (bl) {
                if (DEBUG != null) {
                    DEBUG.println("Searching cert stores for responder's certificate");
                }
                object3 = null;
                if (x500Principal != null) {
                    object3 = new X509CertSelector();
                    ((X509CertSelector)object3).setSubject(x500Principal);
                } else if (x500Principal2 != null && bigInteger != null) {
                    object3 = new X509CertSelector();
                    ((X509CertSelector)object3).setIssuer(x500Principal2);
                    ((X509CertSelector)object3).setSerialNumber(bigInteger);
                }
                if (object3 != null) {
                    object2 = this.pkixParams.getCertStores();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        CertStore certStore = (CertStore)object.next();
                        Iterator<? extends Certificate> iterator = null;
                        try {
                            iterator = certStore.getCertificates((CertSelector)object3).iterator();
                        }
                        catch (CertStoreException certStoreException) {
                            if (DEBUG == null) continue;
                            DEBUG.println("CertStore exception:" + certStoreException);
                            continue;
                        }
                        if (!iterator.hasNext()) continue;
                        object6 = (X509Certificate)iterator.next();
                        bl = false;
                        break;
                    }
                }
            }
        }
        if (bl) {
            throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
        }
        object5 = null;
        object4 = null;
        try {
            object5 = new CertId(x509Certificate, x509CertImpl.getSerialNumberObject());
            object4 = OCSP.check(Collections.singletonList(object5), uRI, (X509Certificate)object6, this.pkixParams.getDate());
        }
        catch (Exception exception) {
            if (exception instanceof CertPathValidatorException) {
                throw (CertPathValidatorException)exception;
            }
            throw new CertPathValidatorException(exception);
        }
        object3 = ((OCSPResponse)object4).getSingleResponse((CertId)object5);
        object2 = object3.getCertStatus();
        if (object2 == OCSP.RevocationStatus.CertStatus.REVOKED) {
            object = new CertificateRevokedException(object3.getRevocationTime(), object3.getRevocationReason(), ((X509Certificate)object6).getSubjectX500Principal(), object3.getSingleExtensions());
            throw new CertPathValidatorException(((Throwable)object).getMessage(), (Throwable)object, null, -1, CertPathValidatorException.BasicReason.REVOKED);
        }
        if (object2 == OCSP.RevocationStatus.CertStatus.UNKNOWN) {
            throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.cp, this.remainingCerts, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
    }

    private static URI getOCSPServerURI(X509CertImpl x509CertImpl, String string) throws CertPathValidatorException {
        if (string != null) {
            try {
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new CertPathValidatorException(uRISyntaxException);
            }
        }
        AuthorityInfoAccessExtension authorityInfoAccessExtension = x509CertImpl.getAuthorityInfoAccessExtension();
        if (authorityInfoAccessExtension == null) {
            throw new CertPathValidatorException("Must specify the location of an OCSP Responder");
        }
        List<AccessDescription> list = authorityInfoAccessExtension.getAccessDescriptions();
        for (AccessDescription accessDescription : list) {
            GeneralName generalName;
            if (!accessDescription.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (generalName = accessDescription.getAccessLocation()).getType() != 6) continue;
            URIName uRIName = (URIName)generalName.getName();
            return uRIName.getURI();
        }
        throw new CertPathValidatorException("Cannot find the location of the OCSP Responder");
    }

    private static String[] getOCSPProperties() {
        final String[] stringArray = new String[4];
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                stringArray[0] = Security.getProperty(OCSPChecker.OCSP_URL_PROP);
                stringArray[1] = Security.getProperty(OCSPChecker.OCSP_CERT_SUBJECT_PROP);
                stringArray[2] = Security.getProperty(OCSPChecker.OCSP_CERT_ISSUER_PROP);
                stringArray[3] = Security.getProperty(OCSPChecker.OCSP_CERT_NUMBER_PROP);
                return null;
            }
        });
        return stringArray;
    }

    private static String stripOutSeparators(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < cArray.length; ++i) {
            if (HEX_DIGITS.indexOf(cArray[i]) == -1) continue;
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }
}

