/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadPrimitiveTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.OsmIdTextField;
import org.openstreetmap.josm.gui.widgets.OsmPrimitiveTypesComboBox;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadPrimitiveAction
extends JosmAction {
    public DownloadPrimitiveAction() {
        super(I18n.tr("Download object..."), "downloadprimitive", I18n.tr("Download OSM object by ID."), Shortcut.registerShortcut("system:download_primitive", I18n.tr("File: {0}", I18n.tr("Download Object...")), 79, 9), true);
        this.putValue("help", HelpUtil.ht("/Action/DownloadObject"));
    }

    public void actionPerformed(ActionEvent e) {
        JCheckBox layer = new JCheckBox(I18n.tr("Separate Layer"));
        layer.setToolTipText(I18n.tr("Select if the data should be downloaded into a new layer"));
        layer.setSelected(Main.pref.getBoolean("download.newlayer"));
        JCheckBox referrers = new JCheckBox(I18n.tr("Download referrers"));
        referrers.setToolTipText(I18n.tr("Select if the referrers of the object should be downloaded as well"));
        referrers.setSelected(Main.pref.getBoolean("downloadprimitive.referrers"));
        JPanel all = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 23;
        gc.gridy = 0;
        gc.weightx = 0.0;
        all.add((Component)new JLabel(I18n.tr("Object type:")), gc);
        OsmPrimitiveTypesComboBox cbType = new OsmPrimitiveTypesComboBox();
        cbType.setToolTipText(I18n.tr("Choose the OSM object type"));
        gc.weightx = 1.0;
        all.add((Component)cbType, gc);
        gc.gridy = 1;
        gc.weightx = 0.0;
        all.add((Component)new JLabel(I18n.tr("Object ID:")), gc);
        OsmIdTextField tfId = new OsmIdTextField();
        tfId.setToolTipText(I18n.tr("Enter the ID of the object that should be downloaded"));
        tfId.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0, false));
        gc.weightx = 1.0;
        all.add((Component)tfId, gc);
        gc.gridy = 2;
        gc.fill = 1;
        gc.weighty = 1.0;
        gc.weightx = 0.0;
        all.add((Component)referrers, gc);
        gc.gridy = 3;
        all.add((Component)layer, gc);
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Download Object"), new String[]{I18n.tr("Download object"), I18n.tr("Cancel")});
        dialog.setContent(all, false);
        dialog.setButtonIcons(new String[]{"download.png", "cancel.png"});
        dialog.setToolTipTexts(new String[]{I18n.tr("Start downloading"), I18n.tr("Close dialog and cancel downloading")});
        dialog.setDefaultButton(1);
        dialog.configureContextsensitiveHelp("/Action/DownloadObject", true);
        cbType.setSelectedIndex(Main.pref.getInteger("downloadprimitive.lasttype", 0));
        dialog.showDialog();
        if (dialog.getValue() != 1) {
            return;
        }
        Main.pref.putInteger("downloadprimitive.lasttype", cbType.getSelectedIndex());
        Main.pref.put("downloadprimitive.referrers", referrers.isSelected());
        Main.pref.put("download.newlayer", layer.isSelected());
        int id = tfId.getOsmId();
        if (id <= 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Invalid ID specified. Cannot download object."), I18n.tr("Information"), 1);
        } else {
            this.download(layer.isSelected(), cbType.getType(), id, referrers.isSelected());
        }
    }

    public void download(boolean newLayer, OsmPrimitiveType type, int id, boolean downloadReferrers) {
        OsmDataLayer layer = this.getEditLayer();
        if (layer == null || newLayer) {
            layer = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.main.addLayer(layer);
        }
        Main.worker.submit(new DownloadPrimitiveTask(new SimplePrimitiveId(id, type), layer));
        if (downloadReferrers) {
            Main.worker.submit(new DownloadReferrersTask(layer, id, type));
        }
    }
}

