/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class ShowStatusReportAction
extends JosmAction {
    public ShowStatusReportAction() {
        super(I18n.tr("Show Status Report"), "clock", I18n.tr("Show status report with useful information that can be attached to bugs"), Shortcut.registerShortcut("help:showstatusreport", I18n.tr("Help: {0}", I18n.tr("Show Status Report")), 82, 0), true);
        this.putValue("help", HelpUtil.ht("/Action/ShowStatusReport"));
    }

    public static String getReportHeader() {
        StringBuilder text = new StringBuilder();
        text.append(Version.getInstance().getReleaseAttributes());
        text.append("\n");
        text.append("Identification: " + Version.getInstance().getAgentString());
        text.append("\n");
        text.append("Memory Usage: ");
        text.append(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        text.append(" MB / ");
        text.append(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        text.append(" MB (");
        text.append(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        text.append(" MB allocated, but free)");
        text.append("\n");
        text.append("Java version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor") + ", " + System.getProperty("java.vm.name"));
        text.append("\n");
        text.append("Operating system: " + System.getProperty("os.name"));
        text.append("\n");
        DataSet dataset = Main.main.getCurrentDataSet();
        if (dataset != null) {
            String result = DatasetConsistencyTest.runTests(dataset);
            if (result.length() == 0) {
                text.append("Dataset consistency test: No problems found\n");
            } else {
                text.append("\nDataset consistency test:\n" + result + "\n");
            }
        }
        text.append("\n");
        text.append(PluginHandler.getBugReportText());
        text.append("\n");
        return text.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        StringBuilder text = new StringBuilder();
        text.append(ShowStatusReportAction.getReportHeader());
        try {
            BufferedReader input = new BufferedReader(new FileReader(Main.pref.getPreferencesDirFile() + File.separator + "preferences"));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    String toCheck = line.trim().toLowerCase();
                    if (toCheck.startsWith("osm-server.username") || toCheck.startsWith("osm-server.password") || toCheck.startsWith("marker.show") || toCheck.startsWith("oauth.access-token.key") || toCheck.startsWith("oauth.access-token.secret")) continue;
                    text.append(line);
                    text.append("\n");
                }
            }
            finally {
                input.close();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        JTextArea ta = new JTextArea(text.toString());
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        ta.setEditable(false);
        JScrollPane sp = new JScrollPane(ta);
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Status Report"), new String[]{I18n.tr("Copy to clipboard and close"), I18n.tr("Close")});
        ed.setButtonIcons(new String[]{"copy.png", "cancel.png"});
        ed.setContent(sp, false);
        ed.setMinimumSize(new Dimension(500, 0));
        ed.showDialog();
        if (ed.getValue() != 1) {
            return;
        }
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text.toString()), new ClipboardOwner(){

                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            });
        }
        catch (RuntimeException x) {
            // empty catch block
        }
    }
}

