/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import org.openstreetmap.josm.data.osm.FilterMatcher;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterWorker {
    public static boolean executeFilters(Collection<OsmPrimitive> all, FilterMatcher filterMatcher) {
        boolean changed = false;
        for (OsmPrimitive primitive : all) {
            if (primitive instanceof Node) continue;
            if (filterMatcher.isHidden(primitive)) {
                changed |= primitive.setDisabledState(true);
                continue;
            }
            if (filterMatcher.isDisabled(primitive)) {
                changed |= primitive.setDisabledState(false);
                continue;
            }
            changed |= primitive.unsetDisabledState();
        }
        for (OsmPrimitive primitive : all) {
            if (!(primitive instanceof Node)) continue;
            if (filterMatcher.isHidden(primitive)) {
                changed |= primitive.setDisabledState(true);
                continue;
            }
            if (filterMatcher.isDisabled(primitive)) {
                changed |= primitive.setDisabledState(false);
                continue;
            }
            changed |= primitive.unsetDisabledState();
        }
        return changed;
    }

    public static boolean executeFilters(OsmPrimitive primitive, FilterMatcher filterMatcher) {
        boolean changed = false;
        changed = filterMatcher.isHidden(primitive) ? (changed |= primitive.setDisabledState(true)) : (filterMatcher.isDisabled(primitive) ? (changed |= primitive.setDisabledState(false)) : (changed |= primitive.unsetDisabledState()));
        return changed;
    }

    public static void clearFilterFlags(Collection<OsmPrimitive> prims) {
        for (OsmPrimitive osm : prims) {
            osm.unsetDisabledState();
        }
    }
}

