/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.xml.sax.SAXException;

public abstract class PleaseWaitRunnable
implements Runnable,
ProgressMonitor.CancelListener {
    private static final Logger logger = Logger.getLogger(PleaseWaitRunnable.class.getName());
    private boolean cancelled = false;
    private boolean ignoreException;
    private final String title;
    protected final ProgressMonitor progressMonitor;

    public PleaseWaitRunnable(String title) {
        this(title, false);
    }

    public PleaseWaitRunnable(String title, boolean ignoreException) {
        this(title, new PleaseWaitProgressMonitor(title), ignoreException);
    }

    public PleaseWaitRunnable(Component parent, String title, boolean ignoreException) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(parent, "parent");
        this.title = title;
        this.progressMonitor = new PleaseWaitProgressMonitor(parent, title);
        this.ignoreException = ignoreException;
    }

    public PleaseWaitRunnable(String title, ProgressMonitor progressMonitor, boolean ignoreException) {
        this.title = title;
        this.progressMonitor = progressMonitor == null ? new PleaseWaitProgressMonitor(title) : progressMonitor;
        this.ignoreException = ignoreException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRealRun() {
        block12: {
            try {
                try {
                    this.progressMonitor.addCancelListener(this);
                    this.progressMonitor.beginTask(this.title);
                    try {
                        this.realRun();
                    }
                    catch (Throwable throwable) {
                        if (EventQueue.isDispatchThread()) {
                            this.finish();
                        } else {
                            EventQueue.invokeAndWait(new Runnable(){

                                public void run() {
                                    PleaseWaitRunnable.this.finish();
                                }
                            });
                        }
                        throw throwable;
                    }
                    if (EventQueue.isDispatchThread()) {
                        this.finish();
                    } else {
                        EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                finally {
                    this.progressMonitor.finishTask();
                    this.progressMonitor.removeCancelListener(this);
                    if (this.progressMonitor instanceof PleaseWaitProgressMonitor) {
                        ((PleaseWaitProgressMonitor)this.progressMonitor).close();
                    }
                }
            }
            catch (Exception e) {
                if (this.ignoreException) break block12;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (e instanceof RuntimeException) {
                            BugReportExceptionHandler.handleException(e);
                        } else {
                            ExceptionDialogUtil.explainException(e);
                        }
                    }
                });
            }
        }
    }

    public final void run() {
        if (this.cancelled) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            new Thread(new Runnable(){

                public void run() {
                    PleaseWaitRunnable.this.doRealRun();
                }
            }).start();
        } else {
            this.doRealRun();
        }
    }

    public void operationCanceled() {
        this.cancel();
    }

    protected abstract void cancel();

    protected abstract void realRun() throws SAXException, IOException, OsmTransferException;

    protected abstract void finish();

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }
}

