/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterMatcher;
import org.openstreetmap.josm.data.osm.FilterWorker;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterTableModel
extends AbstractTableModel {
    public int disabledCount;
    public int disabledAndHiddenCount;
    private final List<Filter> filters = new LinkedList<Filter>();
    private final FilterMatcher filterMatcher = new FilterMatcher();
    private OSDLabel lblOSD = new OSDLabel("");

    public FilterTableModel() {
        this.loadPrefs();
    }

    private void updateFilters() {
        try {
            this.filterMatcher.update(this.filters);
            this.executeFilters();
        }
        catch (SearchCompiler.ParseError e) {
            JOptionPane.showMessageDialog(Main.parent, e.getMessage(), I18n.tr("Error in filter"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFilters() {
        DataSet ds = Main.main.getCurrentDataSet();
        boolean changed = false;
        if (ds == null) {
            this.disabledAndHiddenCount = 0;
            this.disabledCount = 0;
            changed = true;
        } else {
            HashSet<OsmPrimitive> deselect = new HashSet<OsmPrimitive>();
            ds.beginUpdate();
            try {
                Collection<OsmPrimitive> all = ds.allNonDeletedCompletePrimitives();
                changed = FilterWorker.executeFilters(all, this.filterMatcher);
                this.disabledCount = 0;
                this.disabledAndHiddenCount = 0;
                for (OsmPrimitive osm : all) {
                    if (!osm.isDisabled()) continue;
                    ++this.disabledCount;
                    if (osm.isSelected()) {
                        deselect.add(osm);
                    }
                    if (!osm.isDisabledAndHidden()) continue;
                    ++this.disabledAndHiddenCount;
                }
                this.disabledCount -= this.disabledAndHiddenCount;
            }
            finally {
                ds.endUpdate();
            }
            if (!deselect.isEmpty()) {
                ds.clearSelection(deselect);
            }
        }
        if (Main.isDisplayingMapView() && changed) {
            Main.map.mapView.repaint();
            Main.map.filterDialog.updateDialogHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFilters(Collection<? extends OsmPrimitive> primitives) {
        DataSet ds = Main.main.getCurrentDataSet();
        if (ds == null) {
            return;
        }
        boolean changed = false;
        ArrayList<OsmPrimitive> deselect = new ArrayList<OsmPrimitive>();
        ds.beginUpdate();
        try {
            for (int i = 0; i < 2; ++i) {
                for (OsmPrimitive osmPrimitive : primitives) {
                    if (i == 0 && osmPrimitive instanceof Node || i == 1 && !(osmPrimitive instanceof Node)) continue;
                    if (osmPrimitive.isDisabled()) {
                        --this.disabledCount;
                    }
                    if (osmPrimitive.isDisabledAndHidden()) {
                        --this.disabledAndHiddenCount;
                    }
                    changed |= FilterWorker.executeFilters(osmPrimitive, this.filterMatcher);
                    if (osmPrimitive.isDisabled()) {
                        ++this.disabledCount;
                    }
                    if (osmPrimitive.isDisabledAndHidden()) {
                        ++this.disabledAndHiddenCount;
                    }
                    if (!osmPrimitive.isSelected() || !osmPrimitive.isDisabled()) continue;
                    deselect.add(osmPrimitive);
                }
            }
        }
        finally {
            ds.endUpdate();
        }
        if (changed) {
            Main.map.mapView.repaint();
            Main.map.filterDialog.updateDialogHeader();
            ds.clearSelection(deselect);
        }
    }

    public void clearFilterFlags() {
        DataSet ds = Main.main.getCurrentDataSet();
        if (ds != null) {
            FilterWorker.clearFilterFlags(ds.allPrimitives());
        }
        this.disabledCount = 0;
        this.disabledAndHiddenCount = 0;
    }

    private void loadPrefs() {
        Map<String, String> prefs = Main.pref.getAllPrefix("filters.filter");
        for (String value : prefs.values()) {
            this.filters.add(new Filter(value));
        }
        this.updateFilters();
    }

    private void savePrefs() {
        Map<String, String> prefs = Main.pref.getAllPrefix("filters.filter");
        for (String key : prefs.keySet()) {
            String[] sts = key.split("\\.");
            if (sts.length != 3) {
                throw new Error("Incompatible filter preferences");
            }
            Main.pref.put("filters.filter." + sts[2], null);
        }
        int i = 0;
        for (Filter flt : this.filters) {
            Main.pref.put("filters.filter." + i++, flt.getPrefString());
        }
    }

    private void savePref(int i) {
        if (i >= this.filters.size()) {
            Main.pref.put("filters.filter." + i, null);
        } else {
            Main.pref.put("filters.filter." + i, this.filters.get(i).getPrefString());
        }
    }

    public void addFilter(Filter f) {
        this.filters.add(f);
        this.savePref(this.filters.size() - 1);
        this.updateFilters();
        this.fireTableRowsInserted(this.filters.size() - 1, this.filters.size() - 1);
    }

    public void moveDownFilter(int i) {
        if (i >= this.filters.size() - 1) {
            return;
        }
        this.filters.add(i + 1, this.filters.remove(i));
        this.savePref(i);
        this.savePref(i + 1);
        this.updateFilters();
        this.fireTableRowsUpdated(i, i + 1);
    }

    public void moveUpFilter(int i) {
        if (i == 0) {
            return;
        }
        this.filters.add(i - 1, this.filters.remove(i));
        this.savePref(i);
        this.savePref(i - 1);
        this.updateFilters();
        this.fireTableRowsUpdated(i - 1, i);
    }

    public void removeFilter(int i) {
        this.filters.remove(i);
        this.savePrefs();
        this.updateFilters();
        this.fireTableRowsDeleted(i, i);
    }

    public void setFilter(int i, Filter f) {
        this.filters.set(i, f);
        this.savePref(i);
        this.updateFilters();
        this.fireTableRowsUpdated(i, i);
    }

    public Filter getFilter(int i) {
        return this.filters.get(i);
    }

    @Override
    public int getRowCount() {
        return this.filters.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        String[] names = new String[]{I18n.trc("filter", "E"), I18n.trc("filter", "H"), I18n.trc("filter", "Text"), I18n.trc("filter", "I"), I18n.trc("filter", "M")};
        return names[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class[] classes = new Class[]{Boolean.class, Boolean.class, String.class, Boolean.class, String.class};
        return classes[column];
    }

    public boolean isCellEnabled(int row, int column) {
        return this.filters.get((int)row).enable || column == 0;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (!this.filters.get((int)row).enable && column != 0) {
            return false;
        }
        return column < 4;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Filter f = this.filters.get(row);
        switch (column) {
            case 0: {
                f.enable = (Boolean)aValue;
                this.savePref(row);
                this.updateFilters();
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 1: {
                f.hiding = (Boolean)aValue;
                this.savePref(row);
                this.updateFilters();
                break;
            }
            case 2: {
                f.text = (String)aValue;
                this.savePref(row);
                break;
            }
            case 3: {
                f.inverted = (Boolean)aValue;
                this.savePref(row);
                this.updateFilters();
            }
        }
        if (column != 0) {
            this.fireTableCellUpdated(row, column);
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        Filter f = this.filters.get(row);
        switch (column) {
            case 0: {
                return f.enable;
            }
            case 1: {
                return f.hiding;
            }
            case 2: {
                return f.text;
            }
            case 3: {
                return f.inverted;
            }
            case 4: {
                switch (f.mode) {
                    case replace: {
                        return I18n.trc("filter", "R");
                    }
                    case add: {
                        return I18n.trc("filter", "A");
                    }
                    case remove: {
                        return I18n.trc("filter", "D");
                    }
                    case in_selection: {
                        return I18n.trc("filter", "F");
                    }
                }
            }
        }
        return null;
    }

    public void drawOSDText(Graphics2D g) {
        String message = "<html>" + I18n.tr("<h2>Filter active</h2>");
        if (this.disabledCount == 0 && this.disabledAndHiddenCount == 0) {
            return;
        }
        if (this.disabledAndHiddenCount != 0) {
            message = message + I18n.tr("<p><b>{0}</b> objects hidden", this.disabledAndHiddenCount);
        }
        if (this.disabledAndHiddenCount != 0 && this.disabledCount != 0) {
            message = message + "<br>";
        }
        if (this.disabledCount != 0) {
            message = message + I18n.tr("<b>{0}</b> objects disabled", this.disabledCount);
        }
        message = message + I18n.tr("</p><p>Close the filter dialog to see all objects.<p></html>");
        this.lblOSD.setText(message);
        this.lblOSD.setSize(this.lblOSD.getPreferredSize());
        int dx = Main.map.mapView.getWidth() - this.lblOSD.getPreferredSize().width - 15;
        int dy = 15;
        g.translate(dx, dy);
        this.lblOSD.paintComponent(g);
        g.translate(-dx, -dy);
    }

    private static class OSDLabel
    extends JLabel {
        public OSDLabel(String text) {
            super(text);
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setFont(this.getFont().deriveFont(0));
            this.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        }

        public void paintComponent(Graphics g) {
            g.setColor(new Color(255, 255, 255, 140));
            g.fillRoundRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 10, 10);
            super.paintComponent(g);
        }
    }
}

