/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesetCacheManagerModel
extends AbstractTableModel
implements ChangesetCacheListener {
    public static final String CHANGESET_IN_DETAIL_VIEW_PROP = ChangesetCacheManagerModel.class.getName() + ".changesetInDetailView";
    private final ArrayList<Changeset> data = new ArrayList();
    private DefaultListSelectionModel selectionModel;
    private Changeset changesetInDetailView;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public ChangesetCacheManagerModel(DefaultListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void setChangesetInDetailView(Changeset cs) {
        Changeset oldValue = this.changesetInDetailView;
        this.changesetInDetailView = cs;
        if (oldValue != cs) {
            this.support.firePropertyChange(CHANGESET_IN_DETAIL_VIEW_PROP, oldValue, this.changesetInDetailView);
        }
    }

    public boolean hasSelectedChangesets() {
        return this.selectionModel.getMinSelectionIndex() >= 0;
    }

    public List<Changeset> getSelectedChangesets() {
        ArrayList<Changeset> ret = new ArrayList<Changeset>();
        for (int i = 0; i < this.data.size(); ++i) {
            Changeset cs = this.data.get(i);
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ret.add(cs);
        }
        return ret;
    }

    public Set<Integer> getSelectedChangesetIds() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (Changeset cs : this.getSelectedChangesets()) {
            ret.add(cs.getId());
        }
        return ret;
    }

    public void setSelectedChangesets(Collection<Changeset> selected) {
        this.selectionModel.clearSelection();
        if (selected == null || selected.isEmpty()) {
            return;
        }
        for (Changeset cs : selected) {
            int idx = this.data.indexOf(cs);
            if (idx < 0) continue;
            this.selectionModel.addSelectionInterval(idx, idx);
        }
    }

    public void setSelectedByIdx(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        this.selectionModel.setSelectionInterval(row, row);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.data.get(row);
    }

    public void init() {
        ChangesetCache cc = ChangesetCache.getInstance();
        List<Changeset> selected = this.getSelectedChangesets();
        this.data.clear();
        this.data.addAll(cc.getChangesets());
        this.sort();
        this.fireTableDataChanged();
        this.setSelectedChangesets(selected);
        cc.addChangesetCacheListener(this);
    }

    public void tearDown() {
        ChangesetCache.getInstance().removeChangesetCacheListener(this);
    }

    public DefaultListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected void sort() {
        Collections.sort(this.data, new Comparator<Changeset>(){

            @Override
            public int compare(Changeset o1, Changeset o2) {
                if (o1.getId() < o2.getId()) {
                    return 1;
                }
                if (o1.getId() == o2.getId()) {
                    return 0;
                }
                return -1;
            }
        });
    }

    @Override
    public void changesetCacheUpdated(ChangesetCacheEvent event) {
        List<Changeset> selected = this.getSelectedChangesets();
        for (Changeset cs : event.getAddedChangesets()) {
            this.data.add(cs);
        }
        for (Changeset cs : event.getRemovedChangesets()) {
            this.data.remove(cs);
        }
        for (Changeset cs : event.getUpdatedChangesets()) {
            Changeset mine;
            int idx = this.data.indexOf(cs);
            if (idx < 0 || (mine = this.data.get(idx)) == cs) continue;
            mine.mergeFrom(cs);
        }
        this.sort();
        this.fireTableDataChanged();
        this.setSelectedChangesets(selected);
    }
}

