/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.openstreetmap.josm.gui.history.AdjustmentSynchronizer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.RelationMemberTableColumnModel;
import org.openstreetmap.josm.gui.history.SelectionSynchronizer;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;

public class RelationMemberListViewer
extends JPanel {
    private HistoryBrowserModel model;
    private VersionInfoPanel referenceInfoPanel;
    private VersionInfoPanel currentInfoPanel;
    private AdjustmentSynchronizer adjustmentSynchronizer;
    private SelectionSynchronizer selectionSynchronizer;

    protected JScrollPane embeddInScrollPane(JTable table) {
        JScrollPane pane = new JScrollPane(table);
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        this.adjustmentSynchronizer.participateInSynchronizedScrolling(pane.getVerticalScrollBar());
        return pane;
    }

    protected JTable buildReferenceMemberListTable() {
        JTable table = new JTable(this.model.getRelationMemberTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME), new RelationMemberTableColumnModel());
        table.setName("table.referencememberlisttable");
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        return table;
    }

    protected JTable buildCurrentMemberListTable() {
        JTable table = new JTable(this.model.getRelationMemberTableModel(PointInTimeType.CURRENT_POINT_IN_TIME), new RelationMemberTableColumnModel());
        table.setName("table.currentmemberlisttable");
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        return table;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 5, 5, 0);
        gc.fill = 2;
        gc.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gc);
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        this.selectionSynchronizer = new SelectionSynchronizer();
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildReferenceMemberListTable()), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildCurrentMemberListTable()), gc);
    }

    public RelationMemberListViewer(HistoryBrowserModel model) {
        this.setModel(model);
        this.build();
    }

    protected void unregisterAsObserver(HistoryBrowserModel model) {
        if (this.currentInfoPanel != null) {
            model.deleteObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            model.deleteObserver(this.referenceInfoPanel);
        }
    }

    protected void registerAsObserver(HistoryBrowserModel model) {
        if (this.currentInfoPanel != null) {
            model.addObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            model.addObserver(this.referenceInfoPanel);
        }
    }

    public void setModel(HistoryBrowserModel model) {
        if (this.model != null) {
            this.unregisterAsObserver(model);
        }
        this.model = model;
        if (this.model != null) {
            this.registerAsObserver(model);
        }
    }
}

