/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ManualAuthorizationUI
extends AbstractAuthorizationUI {
    private JTextField tfAccessTokenKey;
    private AccessTokenKeyValidator valAccessTokenKey;
    private JTextField tfAccessTokenSecret;
    private AccessTokenSecretValidator valAccessTokenSecret;
    private JCheckBox cbSaveToPreferences;
    private HtmlPanel pnlMessage;

    protected JPanel buildAccessTokenPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        AccessTokenBuilder accessTokenBuilder = new AccessTokenBuilder();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.gridwidth = 2;
        gc.insets = new Insets(0, 0, 5, 0);
        this.pnlMessage = new HtmlPanel();
        this.pnlMessage.setText("<html><body>" + I18n.tr("Please enter an OAuth Access Token which is authorized to access the OSM server ''{0}''.", this.getApiUrl()) + "</body></html>");
        pnl.add((Component)this.pnlMessage, gc);
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        gc.insets = new Insets(0, 0, 0, 3);
        pnl.add((Component)new JLabel(I18n.tr("Access Token Key:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfAccessTokenKey = new JTextField();
        pnl.add((Component)this.tfAccessTokenKey, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAccessTokenKey);
        this.valAccessTokenKey = new AccessTokenKeyValidator(this.tfAccessTokenKey);
        this.valAccessTokenKey.validate();
        this.tfAccessTokenKey.getDocument().addDocumentListener(accessTokenBuilder);
        gc.gridy = 2;
        gc.gridx = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Access Token Secret:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfAccessTokenSecret = new JTextField();
        pnl.add((Component)this.tfAccessTokenSecret, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAccessTokenSecret);
        this.valAccessTokenSecret = new AccessTokenSecretValidator(this.tfAccessTokenSecret);
        this.valAccessTokenSecret.validate();
        this.tfAccessTokenSecret.getDocument().addDocumentListener(accessTokenBuilder);
        gc.gridy = 3;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        this.cbSaveToPreferences = new JCheckBox(I18n.tr("Save Access Token to preferences"));
        pnl.add((Component)this.cbSaveToPreferences, gc);
        this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
        gc.gridy = 3;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected JPanel buildTabbedPreferencesPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        JTabbedPane tp = new JTabbedPane();
        tp.add(this.buildAccessTokenPanel());
        tp.add(this.getAdvancedPropertiesPanel());
        tp.setTitleAt(0, I18n.tr("Access Token"));
        tp.setTitleAt(1, I18n.tr("Advanced OAuth parameters"));
        tp.setToolTipTextAt(0, I18n.tr("Enter the OAuth Access Token"));
        tp.setToolTipTextAt(1, I18n.tr("Enter advanced OAuth properties"));
        pnl.add((Component)tp, "Center");
        return pnl;
    }

    protected JPanel buildActionsPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        TestAccessTokenAction actTestAccessToken = new TestAccessTokenAction();
        pnl.add(new SideButton(actTestAccessToken));
        this.addPropertyChangeListener(actTestAccessToken);
        return pnl;
    }

    public void setApiUrl(String apiUrl) {
        super.setApiUrl(apiUrl);
        this.pnlMessage.setText(I18n.tr("<html><body>Please enter an OAuth Access Token which is authorized to access the OSM server ''{0}''.</body></html>", this.getApiUrl()));
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.buildTabbedPreferencesPanel(), "Center");
        this.add((Component)this.buildActionsPanel(), "South");
    }

    public ManualAuthorizationUI() {
        this.build();
    }

    public boolean isSaveAccessTokenToPreferences() {
        return this.cbSaveToPreferences.isSelected();
    }

    class TestAccessTokenAction
    extends AbstractAction
    implements PropertyChangeListener {
        public TestAccessTokenAction() {
            this.putValue("Name", I18n.tr("Test Access Token"));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
            this.putValue("ShortDescription", I18n.tr("Click to test the Access Token"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent evt) {
            TestAccessTokenTask task = new TestAccessTokenTask(ManualAuthorizationUI.this, ManualAuthorizationUI.this.getApiUrl(), ManualAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters(), ManualAuthorizationUI.this.getAccessToken());
            Main.worker.submit(task);
        }

        protected void updateEnabledState() {
            this.setEnabled(ManualAuthorizationUI.this.hasAccessToken());
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(AbstractAuthorizationUI.ACCESS_TOKEN_PROP)) {
                return;
            }
            this.updateEnabledState();
        }
    }

    class AccessTokenBuilder
    implements DocumentListener {
        AccessTokenBuilder() {
        }

        public void build() {
            if (!ManualAuthorizationUI.this.valAccessTokenKey.isValid() || !ManualAuthorizationUI.this.valAccessTokenSecret.isValid()) {
                ManualAuthorizationUI.this.setAccessToken(null);
            } else {
                ManualAuthorizationUI.this.setAccessToken(new OAuthToken(ManualAuthorizationUI.this.tfAccessTokenKey.getText().trim(), ManualAuthorizationUI.this.tfAccessTokenSecret.getText().trim()));
            }
        }

        public void changedUpdate(DocumentEvent e) {
            this.build();
        }

        public void insertUpdate(DocumentEvent e) {
            this.build();
        }

        public void removeUpdate(DocumentEvent e) {
            this.build();
        }
    }

    private static class AccessTokenSecretValidator
    extends AbstractTextComponentValidator {
        public AccessTokenSecretValidator(JTextComponent tc) throws IllegalArgumentException {
            super(tc);
        }

        public boolean isValid() {
            return !this.getComponent().getText().trim().equals("");
        }

        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter an Access Token Secret"));
            } else {
                this.feedbackInvalid(I18n.tr("The Access Token Secret must not be empty. Please enter an Access Token Secret"));
            }
        }
    }

    private static class AccessTokenKeyValidator
    extends AbstractTextComponentValidator {
        public AccessTokenKeyValidator(JTextComponent tc) throws IllegalArgumentException {
            super(tc);
        }

        public boolean isValid() {
            return !this.getComponent().getText().trim().equals("");
        }

        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter an Access Token Key"));
            } else {
                this.feedbackInvalid(I18n.tr("The Access Token Key must not be empty. Please enter an Access Token Key"));
            }
        }
    }
}

