/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;

public class OsmIdTextField
extends JTextField {
    private OsmIdValidator validator = OsmIdValidator.decorate(this);

    public int getOsmId() {
        return this.validator.getOsmId();
    }

    private static class OsmIdValidator
    extends AbstractTextComponentValidator {
        public static OsmIdValidator decorate(JTextComponent tc) {
            return new OsmIdValidator(tc);
        }

        public OsmIdValidator(JTextComponent tc) {
            super(tc, false);
        }

        public boolean isValid() {
            return this.getOsmId() > 0;
        }

        public void validate() {
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid OSM ID. Please enter an integer value > 0"));
            } else {
                this.feedbackValid(I18n.tr("Please enter an integer value > 0"));
            }
        }

        public int getOsmId() {
            String value = this.getComponent().getText();
            if (value == null || value.trim().length() == 0) {
                return 0;
            }
            try {
                int osmId = Integer.parseInt(value.trim());
                if (osmId > 0) {
                    return osmId;
                }
                return 0;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    }
}

