/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpgImporter
extends FileImporter {
    private GpxLayer gpx;

    public JpgImporter() {
        super(new ExtensionFileFilter("jpg", "jpg", I18n.tr("Image Files") + " (*.jpg, " + I18n.tr("folder") + ")"));
    }

    public JpgImporter(GpxLayer gpx) {
        this();
        this.gpx = gpx;
    }

    @Override
    public boolean acceptFile(File pathname) {
        return super.acceptFile(pathname) || pathname.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importData(List<File> sel, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        progressMonitor.beginTask(I18n.tr("Looking for image files"), 1);
        try {
            ArrayList<File> files = new ArrayList<File>();
            HashSet<String> visitedDirs = new HashSet<String>();
            this.addRecursiveFiles(files, visitedDirs, sel, progressMonitor.createSubTaskMonitor(1, true));
            if (progressMonitor.isCancelled()) {
                return;
            }
            if (files.isEmpty()) {
                throw new IOException(I18n.tr("No image files found."));
            }
            GeoImageLayer.create(files, this.gpx);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecursiveFiles(List<File> files, Set<String> visitedDirs, List<File> sel, ProgressMonitor progressMonitor) throws IOException {
        if (progressMonitor.isCancelled()) {
            return;
        }
        progressMonitor.beginTask(null, sel.size());
        try {
            for (File f : sel) {
                if (f.isDirectory()) {
                    if (visitedDirs.add(f.getCanonicalPath())) {
                        File[] dirFiles = f.listFiles();
                        if (dirFiles == null) continue;
                        this.addRecursiveFiles(files, visitedDirs, Arrays.asList(dirFiles), progressMonitor.createSubTaskMonitor(1, true));
                        continue;
                    }
                    progressMonitor.worked(1);
                    continue;
                }
                if (f.getName().toLowerCase().endsWith(".jpg")) {
                    files.add(f);
                }
                progressMonitor.worked(1);
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    @Override
    public boolean isBatchImporter() {
        return true;
    }

    @Override
    public double getPriority() {
        return -1000.0;
    }
}

