/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmChangeBuilder {
    public static final String DEFAULT_API_VERSION = "0.6";
    private String currentMode;
    private PrintWriter writer;
    private StringWriter swriter;
    private OsmWriter osmwriter;
    private String apiVersion = "0.6";
    private boolean prologWritten = false;

    public OsmChangeBuilder(Changeset changeset) {
        this(changeset, null);
    }

    public OsmChangeBuilder(Changeset changeset, String apiVersion) {
        this.apiVersion = apiVersion == null ? DEFAULT_API_VERSION : apiVersion;
        this.swriter = new StringWriter();
        this.writer = new PrintWriter(this.swriter);
        this.osmwriter = new OsmWriter(this.writer, false, apiVersion);
        this.osmwriter.setChangeset(changeset);
    }

    protected void write(OsmPrimitive p) {
        if (p.isDeleted()) {
            this.switchMode("delete");
            this.osmwriter.setWithBody(false);
            p.visit(this.osmwriter);
        } else {
            this.switchMode(p.isNew() ? "create" : "modify");
            this.osmwriter.setWithBody(true);
            p.visit(this.osmwriter);
        }
    }

    private void switchMode(String newMode) {
        if (newMode != null && !newMode.equals(this.currentMode) || newMode == null && this.currentMode != null) {
            if (this.currentMode != null) {
                this.writer.print("</");
                this.writer.print(this.currentMode);
                this.writer.println(">");
            }
            if (newMode != null) {
                this.writer.print("<");
                this.writer.print(newMode);
                this.writer.println(">");
            }
            this.currentMode = newMode;
        }
    }

    public void start() throws IllegalStateException {
        if (this.prologWritten) {
            throw new IllegalStateException(I18n.tr("Prolog of OsmChange document already written. Please write only once."));
        }
        this.writer.print("<osmChange version=\"");
        this.writer.print(this.apiVersion);
        this.writer.println("\" generator=\"JOSM\">");
        this.prologWritten = true;
    }

    public void append(Collection<OsmPrimitive> primitives) throws IllegalStateException {
        if (primitives == null) {
            return;
        }
        if (!this.prologWritten) {
            throw new IllegalStateException(I18n.tr("Prolog of OsmChange document not written yet. Please write frst."));
        }
        for (OsmPrimitive p : primitives) {
            this.write(p);
        }
    }

    public void append(OsmPrimitive p) {
        if (p == null) {
            return;
        }
        if (!this.prologWritten) {
            throw new IllegalStateException(I18n.tr("Prolog of OsmChange document not written yet. Please write frst."));
        }
        this.write(p);
    }

    public void finish() throws IllegalStateException {
        if (!this.prologWritten) {
            throw new IllegalStateException(I18n.tr("Prolog of OsmChange document not written yet. Please write frst."));
        }
        if (this.currentMode != null) {
            this.writer.print("</");
            this.writer.print(this.currentMode);
            this.writer.println(">");
        }
        this.writer.println("</osmChange>");
    }

    public String getDocument() {
        return this.swriter.toString();
    }
}

