/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import javax.swing.JApplet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class OpenBrowser {
    public static String displayUrl(URI uri) {
        if (Main.applet) {
            try {
                JApplet applet = (JApplet)Main.parent;
                applet.getAppletContext().showDocument(uri.toURL());
                return null;
            }
            catch (MalformedURLException mue) {
                return mue.getMessage();
            }
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }
        System.err.println("Warning: Desktop class is not supported. Platform dependent fall back for open url in browser.");
        if (Main.platform == null) {
            throw new IllegalStateException(I18n.tr("Failed to open URL. There is currently no platform set. Please set a platform first."));
        }
        try {
            Main.platform.openUrl(uri.toString());
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return null;
    }

    public static String displayUrl(String url) {
        try {
            return OpenBrowser.displayUrl(new URI(url));
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

