/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Debug;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

final class ServerNameExtension
extends HelloExtension {
    static final int NAME_HOST_NAME = 0;
    private List<ServerName> names;
    private int listLength;

    ServerNameExtension(List<String> list) throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        this.listLength = 0;
        this.names = new ArrayList<ServerName>(list.size());
        for (String string : list) {
            if (string == null || string.length() == 0) continue;
            ServerName serverName = new ServerName(0, string);
            this.names.add(serverName);
            this.listLength += serverName.length;
        }
        if (this.names.size() > 1) {
            throw new SSLProtocolException("The ServerNameList MUST NOT contain more than one name of the same name_type");
        }
        if (this.listLength == 0) {
            throw new SSLProtocolException("The ServerNameList cannot be empty");
        }
    }

    ServerNameExtension(HandshakeInStream handshakeInStream, int n) throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        int n2 = n;
        if (n >= 2) {
            this.listLength = handshakeInStream.getInt16();
            if (this.listLength == 0 || this.listLength + 2 != n) {
                throw new SSLProtocolException("Invalid " + this.type + " extension");
            }
            n2 -= 2;
            this.names = new ArrayList<ServerName>();
            while (n2 > 0) {
                ServerName serverName = new ServerName(handshakeInStream);
                this.names.add(serverName);
                n2 -= serverName.length;
            }
        } else if (n == 0) {
            this.listLength = 0;
            this.names = Collections.emptyList();
        }
        if (n2 != 0) {
            throw new SSLProtocolException("Invalid server_name extension");
        }
    }

    @Override
    int length() {
        return this.listLength == 0 ? 4 : 6 + this.listLength;
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(this.type.id);
        handshakeOutStream.putInt16(this.listLength + 2);
        if (this.listLength != 0) {
            handshakeOutStream.putInt16(this.listLength);
            for (ServerName serverName : this.names) {
                handshakeOutStream.putInt8(serverName.type);
                handshakeOutStream.putBytes16(serverName.data);
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (ServerName serverName : this.names) {
            stringBuffer.append("[" + serverName + "]");
        }
        return "Extension " + this.type + ", server_name: " + stringBuffer;
    }

    static class ServerName {
        final int length;
        final int type;
        final byte[] data;
        final String hostname;

        ServerName(int n, String string) throws IOException {
            this.type = n;
            this.hostname = string;
            this.data = string.getBytes("UTF8");
            this.length = this.data.length + 3;
        }

        ServerName(HandshakeInStream handshakeInStream) throws IOException {
            this.type = handshakeInStream.getInt8();
            this.data = handshakeInStream.getBytes16();
            this.length = this.data.length + 3;
            this.hostname = this.type == 0 ? new String(this.data, "UTF8") : null;
        }

        public String toString() {
            if (this.type == 0) {
                return "host_name: " + this.hostname;
            }
            return "unknown-" + this.type + ": " + Debug.toString(this.data);
        }
    }
}

