/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.CallSite;
import java.dyn.MethodHandle;
import java.dyn.MethodHandleProvider;
import java.dyn.MethodType;
import java.dyn.NoAccessException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import sun.dyn.Access;
import sun.dyn.Invokers;
import sun.dyn.MemberName;
import sun.dyn.MethodHandleImpl;
import sun.dyn.MethodTypeImpl;
import sun.dyn.util.VerifyAccess;
import sun.dyn.util.Wrapper;
import sun.reflect.Reflection;

public class MethodHandles {
    private static final Access IMPL_TOKEN = Access.getToken();
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory(IMPL_TOKEN);
    private static MethodHandle GET_TARGET;

    private MethodHandles() {
    }

    public static Lookup lookup() {
        return new Lookup();
    }

    public static Lookup publicLookup() {
        return Lookup.PUBLIC_LOOKUP;
    }

    public static MethodHandle arrayElementGetter(Class<?> clazz) throws IllegalArgumentException {
        return MethodHandleImpl.accessArrayElement(IMPL_TOKEN, clazz, false);
    }

    public static MethodHandle arrayElementSetter(Class<?> clazz) throws IllegalArgumentException {
        return MethodHandleImpl.accessArrayElement(IMPL_TOKEN, clazz, true);
    }

    @Deprecated
    public static Object invokeVarargs(MethodHandle methodHandle, Object ... objectArray) throws Throwable {
        return methodHandle.invokeVarargs(objectArray);
    }

    @Deprecated
    public static Object invoke(MethodHandle methodHandle, Object ... objectArray) throws Throwable {
        return methodHandle.invokeVarargs(objectArray);
    }

    public static MethodHandle genericInvoker(MethodType methodType) {
        return MethodHandles.invokers(methodType).genericInvoker();
    }

    public static MethodHandle varargsInvoker(MethodType methodType, int n) {
        if (n < 0 || n > methodType.parameterCount()) {
            throw new IllegalArgumentException("bad argument count " + n);
        }
        return MethodHandles.invokers(methodType).varargsInvoker(n);
    }

    public static MethodHandle exactInvoker(MethodType methodType) {
        return MethodHandles.invokers(methodType).exactInvoker();
    }

    public static MethodHandle dynamicInvoker(CallSite callSite) throws NoAccessException {
        MethodHandle methodHandle = GET_TARGET;
        if (methodHandle == null) {
            try {
                GET_TARGET = methodHandle = Lookup.IMPL_LOOKUP.findVirtual(CallSite.class, "getTarget", MethodType.methodType(MethodHandle.class));
            }
            catch (NoAccessException noAccessException) {
                throw new InternalError();
            }
        }
        MethodHandle methodHandle2 = MethodHandleImpl.bindReceiver(IMPL_TOKEN, methodHandle, callSite);
        MethodHandle methodHandle3 = MethodHandles.exactInvoker(callSite.type());
        return MethodHandles.foldArguments(methodHandle3, methodHandle2);
    }

    static Invokers invokers(MethodType methodType) {
        return MethodTypeImpl.invokers(IMPL_TOKEN, methodType);
    }

    static <T0, T1> T1 checkValue(Class<T0> clazz, Class<T1> clazz2, Object object) throws ClassCastException {
        if (clazz == clazz2) {
            if (clazz.isPrimitive()) {
                return Wrapper.asPrimitiveType(clazz2).cast(object);
            }
            return Wrapper.OBJECT.cast(object, clazz2);
        }
        boolean bl = clazz.isPrimitive();
        boolean bl2 = clazz2.isPrimitive();
        if (!bl) {
            Wrapper.OBJECT.cast(object, clazz);
            if (!bl2) {
                return Wrapper.OBJECT.cast(object, clazz2);
            }
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz2);
            return wrapper.cast(object, clazz2);
        }
        Wrapper.asWrapperType(clazz).cast(object);
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz2);
        return wrapper.cast(object, clazz2);
    }

    static Object checkValue(Class<?> clazz, Object object) throws ClassCastException {
        Class clazz2 = object == null ? Object.class : object.getClass();
        return MethodHandles.checkValue(clazz2, clazz, object);
    }

    public static MethodHandle convertArguments(MethodHandle methodHandle, MethodType methodType) {
        MethodType methodType2 = methodHandle.type();
        if (methodType2.equals((Object)methodType)) {
            return methodHandle;
        }
        MethodHandle methodHandle2 = MethodHandleImpl.convertArguments(IMPL_TOKEN, methodHandle, methodType, methodType2, null);
        if (methodHandle2 == null) {
            throw MemberName.newIllegalArgumentException("cannot convert to " + methodType + ": " + methodHandle);
        }
        return methodHandle2;
    }

    public static MethodHandle permuteArguments(MethodHandle methodHandle, MethodType methodType, int[] nArray) {
        MethodType methodType2 = methodHandle.type();
        MethodHandles.checkReorder(nArray, methodType, methodType2);
        return MethodHandleImpl.convertArguments(IMPL_TOKEN, methodHandle, methodType, methodType2, nArray);
    }

    private static void checkReorder(int[] nArray, MethodType methodType, MethodType methodType2) {
        if (nArray.length == methodType2.parameterCount()) {
            int n = methodType.parameterCount();
            boolean bl = false;
            for (int n2 : nArray) {
                if (n2 >= 0 && n2 < n) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        throw MemberName.newIllegalArgumentException("bad reorder array");
    }

    public static MethodHandle spreadArguments(MethodHandle methodHandle, MethodType methodType) {
        MethodType methodType2 = methodHandle.type();
        int n = methodType.parameterCount();
        int n2 = methodType2.parameterCount();
        int n3 = n - 1;
        int n4 = n2 - n3;
        MethodHandle methodHandle2 = null;
        if (n3 >= 0 && n4 >= 0) {
            methodHandle2 = MethodHandleImpl.spreadArguments(IMPL_TOKEN, methodHandle, methodType, n3);
        }
        if (methodHandle2 == null) {
            throw MemberName.newIllegalArgumentException("cannot spread " + methodType + " to " + methodType2);
        }
        return methodHandle2;
    }

    public static MethodHandle collectArguments(MethodHandle methodHandle, MethodType methodType) {
        MethodType methodType2 = methodHandle.type();
        int n = methodType.parameterCount();
        int n2 = methodType2.parameterCount();
        int n3 = n2 - 1;
        int n4 = n - n3;
        if (n3 < 0 || n4 < 0) {
            throw MemberName.newIllegalArgumentException("wrong number of arguments");
        }
        MethodHandle methodHandle2 = MethodHandleImpl.collectArguments(IMPL_TOKEN, methodHandle, methodType, n3, null);
        if (methodHandle2 == null) {
            throw MemberName.newIllegalArgumentException("cannot collect from " + methodType + " to " + methodType2);
        }
        return methodHandle2;
    }

    public static MethodHandle insertArguments(MethodHandle methodHandle, int n, Object ... objectArray) {
        int n2 = objectArray.length;
        MethodType methodType = methodHandle.type();
        ArrayList arrayList = new ArrayList(methodType.parameterList());
        int n3 = methodType.parameterCount();
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw MemberName.newIllegalArgumentException("too many values to insert");
        }
        if (n < 0 || n > n4) {
            throw MemberName.newIllegalArgumentException("no argument type to append");
        }
        MethodHandle methodHandle2 = methodHandle;
        for (int i = 0; i < n2; ++i) {
            MethodHandle methodHandle3;
            Object object = objectArray[i];
            Class<?> clazz = methodType.parameterType(n + i);
            object = MethodHandles.checkValue(clazz, object);
            methodHandle2 = n == 0 && !clazz.isPrimitive() && (methodHandle3 = MethodHandleImpl.bindReceiver(IMPL_TOKEN, methodHandle2, object)) != null ? methodHandle3 : MethodHandleImpl.bindArgument(IMPL_TOKEN, methodHandle2, n, object);
        }
        return methodHandle2;
    }

    @Deprecated
    public static MethodHandle insertArgument(MethodHandle methodHandle, int n, Object object) {
        return MethodHandles.insertArguments(methodHandle, n, object);
    }

    public static MethodHandle dropArguments(MethodHandle methodHandle, int n, List<Class<?>> list) {
        if (list.size() == 0) {
            return methodHandle;
        }
        MethodType methodType = methodHandle.type();
        int n2 = methodType.parameterCount();
        int n3 = n2 + list.size();
        if (n < 0 || n >= n3) {
            throw MemberName.newIllegalArgumentException("no argument type to remove");
        }
        ArrayList arrayList = new ArrayList(methodType.parameterList());
        arrayList.addAll(n, list);
        MethodType methodType2 = MethodType.methodType(methodType.returnType(), arrayList);
        return MethodHandleImpl.dropArguments(IMPL_TOKEN, methodHandle, methodType2, n);
    }

    public static MethodHandle dropArguments(MethodHandle methodHandle, int n, Class<?> ... classArray) {
        return MethodHandles.dropArguments(methodHandle, n, Arrays.asList(classArray));
    }

    public static MethodHandle filterArguments(MethodHandle methodHandle, MethodHandle ... methodHandleArray) {
        MethodType methodType = methodHandle.type();
        MethodHandle methodHandle2 = methodHandle;
        MethodType methodType2 = methodType;
        int n = -1;
        int n2 = methodType.parameterCount();
        for (MethodHandle methodHandle3 : methodHandleArray) {
            ++n;
            if (methodHandle3 == null) continue;
            if (n >= n2) {
                throw MemberName.newIllegalArgumentException("too many filters");
            }
            MethodType methodType3 = methodHandle3.type();
            if (methodType3.parameterCount() != 1 || methodType3.returnType() != methodType.parameterType(n)) {
                throw MemberName.newIllegalArgumentException("target and filter types do not match");
            }
            methodType2 = methodType2.changeParameterType(n, methodType3.parameterType(0));
            methodHandle2 = MethodHandleImpl.filterArgument(IMPL_TOKEN, methodHandle2, n, methodHandle3);
        }
        MethodType methodType4 = methodHandle2.type();
        if (methodType4 != methodType2) {
            methodHandle2 = MethodHandleImpl.convertArguments(IMPL_TOKEN, methodHandle2, methodType2, methodType4, null);
        }
        return methodHandle2;
    }

    public static MethodHandle foldArguments(MethodHandle methodHandle, MethodHandle methodHandle2) {
        boolean bl;
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        int n = methodType2.parameterCount();
        boolean bl2 = bl = methodType.parameterCount() >= 1 + n;
        if (!bl) {
            throw MethodHandles.misMatchedTypes("target and combiner types", methodType, methodType2);
        }
        MethodType methodType3 = methodType.dropParameterTypes(0, 1);
        return MethodHandleImpl.foldArguments(IMPL_TOKEN, methodHandle, methodType3, methodHandle2);
    }

    public static MethodHandle guardWithTest(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
        MethodType methodType;
        MethodType methodType2 = methodHandle.type();
        MethodType methodType3 = methodHandle2.type();
        if (methodType3 != (methodType = methodHandle3.type())) {
            throw MethodHandles.misMatchedTypes("target and fallback types", methodType3, methodType);
        }
        MethodType methodType4 = methodType3.changeReturnType(Boolean.TYPE);
        if (methodType4 != methodType2) {
            int n;
            if (methodType2.returnType() != Boolean.TYPE) {
                throw MemberName.newIllegalArgumentException("guard type is not a predicate " + methodType2);
            }
            int n2 = methodType2.parameterCount();
            if (n2 < (n = methodType3.parameterCount())) {
                methodHandle = MethodHandles.dropArguments(methodHandle, n2, methodType3.parameterList().subList(n2, n));
                methodType2 = methodHandle.type();
            }
            if (methodType4 != methodType2) {
                throw MethodHandles.misMatchedTypes("target and test types", methodType3, methodType2);
            }
        }
        return MethodHandleImpl.makeGuardWithTest(IMPL_TOKEN, methodHandle, methodHandle2, methodHandle3);
    }

    static RuntimeException misMatchedTypes(String string, MethodType methodType, MethodType methodType2) {
        return MemberName.newIllegalArgumentException(string + " must match: " + methodType + " != " + methodType2);
    }

    public static MethodHandle catchException(MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2) {
        boolean bl;
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        boolean bl2 = bl = methodType.parameterCount() == methodType2.parameterCount() - 1;
        if (!bl) {
            throw MemberName.newIllegalArgumentException("target and handler types do not match");
        }
        return MethodHandleImpl.makeGuardWithCatch(IMPL_TOKEN, methodHandle, clazz, methodHandle2);
    }

    public static MethodHandle throwException(Class<?> clazz, Class<? extends Throwable> clazz2) {
        return MethodHandleImpl.throwException(IMPL_TOKEN, MethodType.methodType(clazz, clazz2));
    }

    public static <T> T asInstance(MethodHandle methodHandle, Class<T> clazz) {
        final Method method = MethodHandles.getSamMethod(clazz);
        if (method == null) {
            throw new IllegalArgumentException("not a SAM type: " + clazz.getName());
        }
        MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        if (!methodType.equals((Object)methodHandle.type())) {
            throw new IllegalArgumentException("wrong method type");
        }
        final MethodHandle methodHandle2 = methodHandle;
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, MethodHandleProvider.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method2, Object[] objectArray) throws Throwable {
                if (method2.getDeclaringClass() == MethodHandleProvider.class) {
                    return method2.invoke(methodHandle2, objectArray);
                }
                assert (method2.equals(method)) : method2;
                return methodHandle2.invokeVarargs(objectArray);
            }
        }));
    }

    private static Method getSamMethod(Class<?> clazz) {
        Method method = null;
        for (Method method2 : clazz.getMethods()) {
            int n = method2.getModifiers();
            if (!Modifier.isAbstract(n)) continue;
            if (method != null) {
                return null;
            }
            method = method2;
        }
        if (!clazz.isInterface() && MethodHandles.getSamConstructor(clazz) == null) {
            return null;
        }
        return method;
    }

    private static Constructor getSamConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            int n;
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(n = constructor.getModifiers()) && !Modifier.isProtected(n)) continue;
            return constructor;
        }
        return null;
    }

    static {
        MethodHandleImpl.initStatics();
        GET_TARGET = null;
    }

    public static final class Lookup {
        private final Class<?> lookupClass;
        private final int allowedModes;
        private static final int PUBLIC = 1;
        private static final int PACKAGE = 8;
        private static final int PROTECTED = 4;
        private static final int PRIVATE = 2;
        private static final int ALL_MODES = 15;
        private static final int TRUSTED = -1;
        static final Lookup PUBLIC_LOOKUP;
        static final Lookup IMPL_LOOKUP;

        private static int fixmods(int n) {
            return (n &= 7) != 0 ? n : 8;
        }

        public Class<?> lookupClass() {
            return this.lookupClass;
        }

        private Class<?> lookupClassOrNull() {
            return this.allowedModes == -1 ? null : this.lookupClass;
        }

        public int lookupModes() {
            return this.allowedModes & 0xF;
        }

        Lookup() {
            this(Lookup.getCallerClassAtEntryPoint(), 15);
            Lookup.checkUnprivilegedlookupClass(this.lookupClass);
        }

        Lookup(Access access, Class<?> clazz) {
            this(clazz, 15);
            Access.check(access);
        }

        private Lookup(Class<?> clazz, int n) {
            this.lookupClass = clazz;
            this.allowedModes = n;
        }

        public Lookup in(Class<?> clazz) {
            clazz.getClass();
            if (this.allowedModes == -1) {
                return new Lookup(clazz, 15);
            }
            if (clazz == this.lookupClass) {
                return this;
            }
            int n = this.allowedModes & 0xB;
            if ((n & 8) != 0 && !VerifyAccess.isSamePackage(this.lookupClass, clazz)) {
                n &= 0xFFFFFFF5;
            }
            if ((n & 2) != 0 && !VerifyAccess.isSamePackageMember(this.lookupClass, clazz)) {
                n &= 0xFFFFFFFD;
            }
            Lookup.checkUnprivilegedlookupClass(clazz);
            return new Lookup(clazz, n);
        }

        private static void checkUnprivilegedlookupClass(Class<?> clazz) {
            String string = clazz.getName();
            if (string.startsWith("java.dyn.") || string.startsWith("sun.dyn.")) {
                throw MemberName.newIllegalArgumentException("illegal lookupClass: " + clazz);
            }
        }

        public String toString() {
            String string = this.lookupClass.getName();
            switch (this.allowedModes) {
                case -1: {
                    return "/trusted";
                }
                case 1: {
                    String string2 = "/public";
                    if (this.lookupClass != Object.class) break;
                    return string2;
                }
                case 9: {
                    return string + "/package";
                }
                case 0: {
                    return string + "/empty";
                }
                case 15: {
                    return string;
                }
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            if ((this.allowedModes & 1) != 0) {
                stringBuilder.append("/public");
            }
            if ((this.allowedModes & 8) != 0) {
                stringBuilder.append("/package");
            }
            if ((this.allowedModes & 4) != 0) {
                stringBuilder.append("/protected");
            }
            if ((this.allowedModes & 2) != 0) {
                stringBuilder.append("/private");
            }
            return stringBuilder.toString();
        }

        private static Class<?> getCallerClassAtEntryPoint() {
            assert (Reflection.getCallerClass(3) == MethodHandles.class);
            return Reflection.getCallerClass(4);
        }

        public MethodHandle findStatic(Class<?> clazz, String string, MethodType methodType) throws NoAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, true);
            this.checkMethod(clazz, memberName, true);
            return MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, false, this.lookupClassOrNull());
        }

        public MethodHandle findVirtual(Class<?> clazz, String string, MethodType methodType) throws NoAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, false);
            this.checkMethod(clazz, memberName, false);
            MethodHandle methodHandle = MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, true, this.lookupClassOrNull());
            return this.restrictProtectedReceiver(memberName, methodHandle);
        }

        public MethodHandle findConstructor(Class<?> clazz, MethodType methodType) throws NoAccessException {
            String string = "<init>";
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, false, false, this.lookupClassOrNull());
            assert (memberName.isConstructor());
            this.checkAccess(clazz, memberName);
            MethodHandle methodHandle = MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, false, this.lookupClassOrNull());
            return MethodHandleImpl.makeAllocator(IMPL_TOKEN, methodHandle);
        }

        public MethodHandle findSpecial(Class<?> clazz, String string, MethodType methodType, Class<?> clazz2) throws NoAccessException {
            this.checkSpecialCaller(clazz2);
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, false, false, clazz2);
            this.checkMethod(clazz, memberName, false);
            MethodHandle methodHandle = MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, false, clazz2);
            return this.restrictReceiver(memberName, methodHandle, clazz2);
        }

        public MethodHandle findGetter(Class<?> clazz, String string, Class<?> clazz2) throws NoAccessException {
            return this.makeAccessor(clazz, string, clazz2, false, false);
        }

        public MethodHandle findSetter(Class<?> clazz, String string, Class<?> clazz2) throws NoAccessException {
            return this.makeAccessor(clazz, string, clazz2, false, true);
        }

        public MethodHandle findStaticGetter(Class<?> clazz, String string, Class<?> clazz2) throws NoAccessException {
            return this.makeAccessor(clazz, string, clazz2, true, false);
        }

        public MethodHandle findStaticSetter(Class<?> clazz, String string, Class<?> clazz2) throws NoAccessException {
            return this.makeAccessor(clazz, string, clazz2, true, true);
        }

        public MethodHandle bind(Object object, String string, MethodType methodType) throws NoAccessException {
            Class<?> clazz = object.getClass();
            MemberName memberName = this.resolveOrFail(clazz, string, methodType, false);
            this.checkMethod(clazz, memberName, false);
            MethodHandle methodHandle = MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, true, this.lookupClassOrNull());
            MethodHandle methodHandle2 = MethodHandleImpl.bindReceiver(IMPL_TOKEN, methodHandle, object);
            if (methodHandle2 == null) {
                throw MemberName.newNoAccessException(memberName, this.lookupClass());
            }
            return methodHandle2;
        }

        public MethodHandle unreflect(Method method) throws NoAccessException {
            MemberName memberName = new MemberName(method);
            assert (memberName.isMethod());
            if (!method.isAccessible()) {
                this.checkMethod(memberName.getDeclaringClass(), memberName, memberName.isStatic());
            }
            MethodHandle methodHandle = MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, true, this.lookupClassOrNull());
            if (!method.isAccessible()) {
                methodHandle = this.restrictProtectedReceiver(memberName, methodHandle);
            }
            return methodHandle;
        }

        public MethodHandle unreflectSpecial(Method method, Class<?> clazz) throws NoAccessException {
            this.checkSpecialCaller(clazz);
            MemberName memberName = new MemberName(method);
            assert (memberName.isMethod());
            this.checkMethod(method.getDeclaringClass(), memberName, false);
            MethodHandle methodHandle = MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, false, this.lookupClassOrNull());
            return this.restrictReceiver(memberName, methodHandle, clazz);
        }

        public MethodHandle unreflectConstructor(Constructor constructor) throws NoAccessException {
            MemberName memberName = new MemberName(constructor);
            assert (memberName.isConstructor());
            if (!constructor.isAccessible()) {
                this.checkAccess(constructor.getDeclaringClass(), memberName);
            }
            MethodHandle methodHandle = MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, false, this.lookupClassOrNull());
            return MethodHandleImpl.makeAllocator(IMPL_TOKEN, methodHandle);
        }

        public MethodHandle unreflectGetter(Field field) throws NoAccessException {
            return this.makeAccessor(field.getDeclaringClass(), new MemberName(field), field.isAccessible(), false);
        }

        public MethodHandle unreflectSetter(Field field) throws NoAccessException {
            return this.makeAccessor(field.getDeclaringClass(), new MemberName(field), field.isAccessible(), true);
        }

        MemberName resolveOrFail(Class<?> clazz, String string, Class<?> clazz2, boolean bl) throws NoAccessException {
            this.checkSymbolicClass(clazz);
            int n = bl ? 8 : 0;
            return IMPL_NAMES.resolveOrFail(new MemberName(clazz, string, clazz2, n), true, this.lookupClassOrNull());
        }

        MemberName resolveOrFail(Class<?> clazz, String string, MethodType methodType, boolean bl) throws NoAccessException {
            this.checkSymbolicClass(clazz);
            int n = bl ? 8 : 0;
            return IMPL_NAMES.resolveOrFail(new MemberName(clazz, string, methodType, n), true, this.lookupClassOrNull());
        }

        MemberName resolveOrFail(Class<?> clazz, String string, MethodType methodType, boolean bl, boolean bl2, Class<?> clazz2) throws NoAccessException {
            this.checkSymbolicClass(clazz);
            int n = bl ? 8 : 0;
            return IMPL_NAMES.resolveOrFail(new MemberName(clazz, string, methodType, n), bl2, clazz2);
        }

        void checkSymbolicClass(Class<?> clazz) throws NoAccessException {
            Class<?> clazz2 = this.lookupClassOrNull();
            if (clazz2 != null && !VerifyAccess.isClassAccessible(clazz, clazz2)) {
                throw MemberName.newNoAccessException("symbolic reference class is not public", new MemberName(clazz), clazz2);
            }
        }

        void checkMethod(Class<?> clazz, MemberName memberName, boolean bl) throws NoAccessException {
            String string;
            if (memberName.isConstructor()) {
                string = "expected a method, not a constructor";
            } else if (!memberName.isMethod()) {
                string = "expected a method";
            } else if (bl != memberName.isStatic()) {
                string = bl ? "expected a static method" : "expected a non-static method";
            } else {
                this.checkAccess(clazz, memberName);
                return;
            }
            throw MemberName.newNoAccessException(string, memberName, this.lookupClass());
        }

        void checkAccess(Class<?> clazz, MemberName memberName) throws NoAccessException {
            int n = this.allowedModes;
            if (n == -1) {
                return;
            }
            int n2 = memberName.getModifiers();
            if (Modifier.isPublic(n2) && Modifier.isPublic(clazz.getModifiers())) {
                return;
            }
            int n3 = Lookup.fixmods(n2);
            if ((n3 & n) != 0 && VerifyAccess.isMemberAccessible(clazz, memberName.getDeclaringClass(), n2, this.lookupClass())) {
                return;
            }
            if ((n3 & ~n & 4) != 0 && VerifyAccess.isSamePackage(memberName.getDeclaringClass(), this.lookupClass())) {
                return;
            }
            throw MemberName.newNoAccessException(this.accessFailedMessage(clazz, memberName), memberName, this.lookupClass());
        }

        String accessFailedMessage(Class<?> clazz, MemberName memberName) {
            Class<?> clazz2 = memberName.getDeclaringClass();
            int n = memberName.getModifiers();
            if (!VerifyAccess.isClassAccessible(clazz2, this.lookupClass())) {
                return "class is not public";
            }
            if (clazz != clazz2 && !VerifyAccess.isClassAccessible(clazz, this.lookupClass())) {
                return "symbolic reference " + clazz.getName() + " is not public";
            }
            if (Modifier.isPublic(n)) {
                return "access to public member failed";
            }
            if (this.allowedModes == 1) {
                return "member is not public";
            }
            if (Modifier.isPrivate(n)) {
                return "member is private";
            }
            if (Modifier.isProtected(n)) {
                return "member is protected";
            }
            return "member is private to package";
        }

        void checkSpecialCaller(Class<?> clazz) throws NoAccessException {
            if (this.allowedModes == -1) {
                return;
            }
            if (!VerifyAccess.isSamePackageMember(clazz, this.lookupClass())) {
                throw MemberName.newNoAccessException("no private access for invokespecial", new MemberName(clazz), this.lookupClass());
            }
        }

        MethodHandle restrictProtectedReceiver(MemberName memberName, MethodHandle methodHandle) throws NoAccessException {
            if (!memberName.isProtected() || memberName.isStatic() || this.allowedModes == -1 || VerifyAccess.isSamePackageMember(memberName.getDeclaringClass(), this.lookupClass())) {
                return methodHandle;
            }
            return this.restrictReceiver(memberName, methodHandle, this.lookupClass());
        }

        MethodHandle restrictReceiver(MemberName memberName, MethodHandle methodHandle, Class<?> clazz) throws NoAccessException {
            assert (!memberName.isStatic());
            Class<?> clazz2 = memberName.getDeclaringClass();
            if (clazz2.isInterface() || !clazz2.isAssignableFrom(clazz)) {
                throw MemberName.newNoAccessException("caller class must be a subclass below the method", memberName, clazz);
            }
            MethodType methodType = methodHandle.type();
            if (methodType.parameterType(0) == clazz) {
                return methodHandle;
            }
            MethodType methodType2 = methodType.changeParameterType(0, clazz);
            return MethodHandleImpl.convertArguments(IMPL_TOKEN, methodHandle, methodType2, methodType, null);
        }

        MethodHandle makeAccessor(Class<?> clazz, String string, Class<?> clazz2, boolean bl, boolean bl2) throws NoAccessException {
            MemberName memberName = this.resolveOrFail(clazz, string, clazz2, bl);
            if (bl != memberName.isStatic()) {
                throw MemberName.newNoAccessException(bl ? "expected a static field" : "expected a non-static field", memberName, this.lookupClass());
            }
            return this.makeAccessor(clazz, memberName, false, bl2);
        }

        MethodHandle makeAccessor(Class<?> clazz, MemberName memberName, boolean bl, boolean bl2) throws NoAccessException {
            assert (memberName.isField());
            if (bl) {
                return MethodHandleImpl.accessField(IMPL_TOKEN, memberName, bl2, this.lookupClassOrNull());
            }
            this.checkAccess(clazz, memberName);
            MethodHandle methodHandle = MethodHandleImpl.accessField(IMPL_TOKEN, memberName, bl2, this.lookupClassOrNull());
            return this.restrictProtectedReceiver(memberName, methodHandle);
        }

        static {
            IMPL_TOKEN.getClass();
            PUBLIC_LOOKUP = new Lookup(Object.class, 1);
            IMPL_LOOKUP = new Lookup(Object.class, -1);
            MethodHandleImpl.initLookup(IMPL_TOKEN, IMPL_LOOKUP);
        }
    }
}

