/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.FillSpans;
import sun.java2d.pipe.LoopBasedPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.RenderingEngine;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;

public class LoopPipe
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe,
LoopBasedPipe {
    static final RenderingEngine RenderEngine = RenderingEngine.getInstance();

    @Override
    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        int n5 = sunGraphics2D.transX;
        int n6 = sunGraphics2D.transY;
        sunGraphics2D.loops.drawLineLoop.DrawLine(sunGraphics2D, sunGraphics2D.getSurfaceData(), n + n5, n2 + n6, n3 + n5, n4 + n6);
    }

    @Override
    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        sunGraphics2D.loops.drawRectLoop.DrawRect(sunGraphics2D, sunGraphics2D.getSurfaceData(), n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
    }

    @Override
    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.draw(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        sunGraphics2D.shapepipe.draw(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    @Override
    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.draw(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    @Override
    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[]{n};
        sunGraphics2D.loops.drawPolygonsLoop.DrawPolygons(sunGraphics2D, sunGraphics2D.getSurfaceData(), nArray, nArray2, nArray3, 1, sunGraphics2D.transX, sunGraphics2D.transY, false);
    }

    @Override
    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[]{n};
        sunGraphics2D.loops.drawPolygonsLoop.DrawPolygons(sunGraphics2D, sunGraphics2D.getSurfaceData(), nArray, nArray2, nArray3, 1, sunGraphics2D.transX, sunGraphics2D.transY, true);
    }

    @Override
    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        sunGraphics2D.loops.fillRectLoop.FillRect(sunGraphics2D, sunGraphics2D.getSurfaceData(), n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
    }

    @Override
    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.fill(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        sunGraphics2D.shapepipe.fill(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    @Override
    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.fill(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        ShapeSpanIterator shapeSpanIterator = LoopPipe.getFillSSI(sunGraphics2D);
        try {
            shapeSpanIterator.setOutputArea(sunGraphics2D.getCompClip());
            shapeSpanIterator.appendPoly(nArray, nArray2, n, sunGraphics2D.transX, sunGraphics2D.transY);
            LoopPipe.fillSpans(sunGraphics2D, shapeSpanIterator);
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.strokeState == 0) {
            int n;
            int n2;
            Path2D.Float float_;
            if (sunGraphics2D.transformState <= 1) {
                float_ = shape instanceof Path2D.Float ? (Path2D.Float)shape : new Path2D.Float(shape);
                n2 = sunGraphics2D.transX;
                n = sunGraphics2D.transY;
            } else {
                float_ = new Path2D.Float(shape, sunGraphics2D.transform);
                n2 = 0;
                n = 0;
            }
            sunGraphics2D.loops.drawPathLoop.DrawPath(sunGraphics2D, sunGraphics2D.getSurfaceData(), n2, n, float_);
            return;
        }
        if (sunGraphics2D.strokeState == 3) {
            this.fill(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape));
            return;
        }
        ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
        try {
            LoopPipe.fillSpans(sunGraphics2D, shapeSpanIterator);
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    public static ShapeSpanIterator getFillSSI(SunGraphics2D sunGraphics2D) {
        boolean bl = sunGraphics2D.stroke instanceof BasicStroke && sunGraphics2D.strokeHint != 2;
        return new ShapeSpanIterator(bl);
    }

    public static ShapeSpanIterator getStrokeSpans(SunGraphics2D sunGraphics2D, Shape shape) {
        ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator(false);
        try {
            shapeSpanIterator.setOutputArea(sunGraphics2D.getCompClip());
            shapeSpanIterator.setRule(1);
            BasicStroke basicStroke = (BasicStroke)sunGraphics2D.stroke;
            boolean bl = sunGraphics2D.strokeState <= 1;
            boolean bl2 = sunGraphics2D.strokeHint != 2;
            RenderEngine.strokeTo(shape, sunGraphics2D.transform, basicStroke, bl, bl2, false, shapeSpanIterator);
        }
        catch (Throwable throwable) {
            shapeSpanIterator.dispose();
            shapeSpanIterator = null;
            throwable.printStackTrace();
            throw new InternalError("Unable to Stroke shape (" + throwable.getMessage() + ")");
        }
        return shapeSpanIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.strokeState == 0) {
            int n;
            int n2;
            Path2D.Float float_;
            if (sunGraphics2D.transformState <= 1) {
                float_ = shape instanceof Path2D.Float ? (Path2D.Float)shape : new Path2D.Float(shape);
                n2 = sunGraphics2D.transX;
                n = sunGraphics2D.transY;
            } else {
                float_ = new Path2D.Float(shape, sunGraphics2D.transform);
                n2 = 0;
                n = 0;
            }
            sunGraphics2D.loops.fillPathLoop.FillPath(sunGraphics2D, sunGraphics2D.getSurfaceData(), n2, n, float_);
            return;
        }
        ShapeSpanIterator shapeSpanIterator = LoopPipe.getFillSSI(sunGraphics2D);
        try {
            shapeSpanIterator.setOutputArea(sunGraphics2D.getCompClip());
            AffineTransform affineTransform = sunGraphics2D.transformState == 0 ? null : sunGraphics2D.transform;
            shapeSpanIterator.appendPath(shape.getPathIterator(affineTransform));
            LoopPipe.fillSpans(sunGraphics2D, shapeSpanIterator);
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    private static void fillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator) {
        Object object;
        if (sunGraphics2D.clipState == 2) {
            spanIterator = sunGraphics2D.clipRegion.filter(spanIterator);
        } else {
            object = sunGraphics2D.loops.fillSpansLoop;
            if (object != null) {
                ((FillSpans)object).FillSpans(sunGraphics2D, sunGraphics2D.getSurfaceData(), spanIterator);
                return;
            }
        }
        object = new int[4];
        SurfaceData surfaceData = sunGraphics2D.getSurfaceData();
        while (spanIterator.nextSpan((int[])object)) {
            Object object2 = object[0];
            Object object3 = object[1];
            reference var6_6 = object[2] - object2;
            reference var7_7 = object[3] - object3;
            sunGraphics2D.loops.fillRectLoop.FillRect(sunGraphics2D, surfaceData, (int)object2, (int)object3, (int)var6_6, (int)var7_7);
        }
    }
}

