/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.util.Arrays;

final class Helpers {
    private Helpers() {
        throw new Error("This is a non instantiable class");
    }

    static boolean within(float f, float f2, float f3) {
        float f4 = f2 - f;
        return f4 <= f3 && f4 >= -f3;
    }

    static boolean within(double d, double d2, double d3) {
        double d4 = d2 - d;
        return d4 <= d3 && d4 >= -d3;
    }

    static int quadraticRoots(float f, float f2, float f3, float[] fArray, int n) {
        int n2 = n;
        if (f != 0.0f) {
            float f4 = f2 * f2 - 4.0f * f * f3;
            if (f4 > 0.0f) {
                float f5 = (float)Math.sqrt(f4);
                if (f2 >= 0.0f) {
                    fArray[n2++] = 2.0f * f3 / (-f2 - f5);
                    fArray[n2++] = (-f2 - f5) / (2.0f * f);
                } else {
                    fArray[n2++] = (-f2 + f5) / (2.0f * f);
                    fArray[n2++] = 2.0f * f3 / (-f2 + f5);
                }
            } else if (f4 == 0.0f) {
                float f6 = -f2 / (2.0f * f);
                fArray[n2++] = f6;
            }
        } else if (f2 != 0.0f) {
            float f7 = -f3 / f2;
            fArray[n2++] = f7;
        }
        return n2 - n;
    }

    static int cubicRootsInAB(float f, float f2, float f3, float f4, float[] fArray, int n, float f5, float f6, float f7) {
        if (f == 0.0f) {
            return Helpers.quadraticRoots(f2, f3, f4, fArray, n);
        }
        float f8 = 3.0f * f;
        float f9 = 2.0f * f2;
        int n2 = Helpers.quadraticRoots(f8, f9, f3, fArray, n + 1);
        if ((n2 = Helpers.filterOutNotInAB(fArray, n + 1, n2, f6, f7) - n - 1) == 2 && fArray[n + 1] > fArray[n + 2]) {
            float f10 = fArray[n + 1];
            fArray[n + 1] = fArray[n + 2];
            fArray[n + 2] = f10;
        }
        int n3 = n;
        fArray[n] = f6;
        fArray[n + n2 + 1] = f7;
        n2 += 2;
        float f11 = fArray[n];
        float f12 = Helpers.evalCubic(f, f2, f3, f4, f11);
        for (int i = n; i < n + n2 - 1; ++i) {
            float f13 = fArray[i + 1];
            float f14 = Helpers.evalCubic(f, f2, f3, f4, f13);
            if (f12 == 0.0f) {
                fArray[n3++] = f11;
            } else if (f14 * f12 < 0.0f) {
                fArray[n3++] = Helpers.CubicNewton(f, f2, f3, f4, f11 + f12 * (f13 - f11) / (f12 - f14), f5);
            }
            f11 = f13;
            f12 = f14;
        }
        return n3 - n;
    }

    static float CubicNewton(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8 = Helpers.evalCubic(f, f2, f3, f4, f5);
        for (int i = 0; !(Math.abs((f7 = f5 - f8 / Helpers.evalCubic(0.0f, 3.0f * f, 2.0f * f2, f3, f5)) - f5) < f6 * Math.abs(f7 + f5)) && i != 10; ++i) {
            f5 = f7;
            f8 = Helpers.evalCubic(f, f2, f3, f4, f5);
        }
        return f7;
    }

    static void fillWithIdxes(float[] fArray, int[] nArray) {
        if (nArray.length > 0) {
            nArray[0] = 0;
            for (int i = 1; i < nArray.length; ++i) {
                nArray[i] = nArray[i - 1] + (int)fArray[nArray[i - 1]];
            }
        }
    }

    static void fillWithIdxes(int[] nArray, int n) {
        if (nArray.length > 0) {
            nArray[0] = 0;
            for (int i = 1; i < nArray.length; ++i) {
                nArray[i] = nArray[i - 1] + n;
            }
        }
    }

    static float[] widenArray(float[] fArray, int n, int n2) {
        if (fArray == null) {
            return new float[5 * n2];
        }
        if (fArray.length >= n + n2) {
            return fArray;
        }
        return Arrays.copyOf(fArray, 2 * (n + n2));
    }

    static int[] widenArray(int[] nArray, int n, int n2) {
        if (nArray.length >= n + n2) {
            return nArray;
        }
        return Arrays.copyOf(nArray, 2 * (n + n2));
    }

    static float evalCubic(float f, float f2, float f3, float f4, float f5) {
        return f5 * (f5 * (f5 * f + f2) + f3) + f4;
    }

    static float evalQuad(float f, float f2, float f3, float f4) {
        return f4 * (f4 * f + f2) + f3;
    }

    static int filterOutNotInAB(float[] fArray, int n, int n2, float f, float f2) {
        int n3 = n;
        for (int i = n; i < n + n2; ++i) {
            if (!(fArray[i] > f) || !(fArray[i] < f2)) continue;
            fArray[n3++] = fArray[i];
        }
        return n3;
    }

    static float polyLineLength(float[] fArray, int n, int n2) {
        assert (n2 % 2 == 0 && fArray.length >= n + n2) : "";
        float f = 0.0f;
        for (int i = n + 2; i < n + n2; i += 2) {
            f += Helpers.linelen(fArray[i], fArray[i + 1], fArray[i - 2], fArray[i - 1]);
        }
        return f;
    }

    static float linelen(float f, float f2, float f3, float f4) {
        return (float)Math.hypot(f3 - f, f4 - f2);
    }

    static void subdivide(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3, int n4) {
        switch (n4) {
            case 6: {
                Helpers.subdivideQuad(fArray, n, fArray2, n2, fArray3, n3);
                break;
            }
            case 8: {
                Helpers.subdivideCubic(fArray, n, fArray2, n2, fArray3, n3);
                break;
            }
            default: {
                throw new InternalError("Unsupported curve type");
            }
        }
    }

    static void isort(float[] fArray, int n, int n2) {
        for (int i = n + 1; i < n + n2; ++i) {
            float f = fArray[i];
            for (int j = i - 1; j >= n && fArray[j] > f; --j) {
                fArray[j + 1] = fArray[j];
            }
            fArray[j + 1] = f;
        }
    }

    static void subdivideCubic(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        float f = fArray[n + 0];
        float f2 = fArray[n + 1];
        float f3 = fArray[n + 2];
        float f4 = fArray[n + 3];
        float f5 = fArray[n + 4];
        float f6 = fArray[n + 5];
        float f7 = fArray[n + 6];
        float f8 = fArray[n + 7];
        if (fArray2 != null) {
            fArray2[n2 + 0] = f;
            fArray2[n2 + 1] = f2;
        }
        if (fArray3 != null) {
            fArray3[n3 + 6] = f7;
            fArray3[n3 + 7] = f8;
        }
        f = (f + f3) / 2.0f;
        f2 = (f2 + f4) / 2.0f;
        f7 = (f7 + f5) / 2.0f;
        f8 = (f8 + f6) / 2.0f;
        float f9 = (f3 + f5) / 2.0f;
        float f10 = (f4 + f6) / 2.0f;
        f3 = (f + f9) / 2.0f;
        f4 = (f2 + f10) / 2.0f;
        f5 = (f7 + f9) / 2.0f;
        f6 = (f8 + f10) / 2.0f;
        f9 = (f3 + f5) / 2.0f;
        f10 = (f4 + f6) / 2.0f;
        if (fArray2 != null) {
            fArray2[n2 + 2] = f;
            fArray2[n2 + 3] = f2;
            fArray2[n2 + 4] = f3;
            fArray2[n2 + 5] = f4;
            fArray2[n2 + 6] = f9;
            fArray2[n2 + 7] = f10;
        }
        if (fArray3 != null) {
            fArray3[n3 + 0] = f9;
            fArray3[n3 + 1] = f10;
            fArray3[n3 + 2] = f5;
            fArray3[n3 + 3] = f6;
            fArray3[n3 + 4] = f7;
            fArray3[n3 + 5] = f8;
        }
    }

    static void subdivideCubicAt(float f, float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        float f2 = fArray[n + 0];
        float f3 = fArray[n + 1];
        float f4 = fArray[n + 2];
        float f5 = fArray[n + 3];
        float f6 = fArray[n + 4];
        float f7 = fArray[n + 5];
        float f8 = fArray[n + 6];
        float f9 = fArray[n + 7];
        if (fArray2 != null) {
            fArray2[n2 + 0] = f2;
            fArray2[n2 + 1] = f3;
        }
        if (fArray3 != null) {
            fArray3[n3 + 6] = f8;
            fArray3[n3 + 7] = f9;
        }
        f2 += f * (f4 - f2);
        f3 += f * (f5 - f3);
        f8 = f6 + f * (f8 - f6);
        f9 = f7 + f * (f9 - f7);
        float f10 = f4 + f * (f6 - f4);
        float f11 = f5 + f * (f7 - f5);
        f4 = f2 + f * (f10 - f2);
        f5 = f3 + f * (f11 - f3);
        f6 = f10 + f * (f8 - f10);
        f7 = f11 + f * (f9 - f11);
        f10 = f4 + f * (f6 - f4);
        f11 = f5 + f * (f7 - f5);
        if (fArray2 != null) {
            fArray2[n2 + 2] = f2;
            fArray2[n2 + 3] = f3;
            fArray2[n2 + 4] = f4;
            fArray2[n2 + 5] = f5;
            fArray2[n2 + 6] = f10;
            fArray2[n2 + 7] = f11;
        }
        if (fArray3 != null) {
            fArray3[n3 + 0] = f10;
            fArray3[n3 + 1] = f11;
            fArray3[n3 + 2] = f6;
            fArray3[n3 + 3] = f7;
            fArray3[n3 + 4] = f8;
            fArray3[n3 + 5] = f9;
        }
    }

    static void subdivideQuad(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        float f = fArray[n + 0];
        float f2 = fArray[n + 1];
        float f3 = fArray[n + 2];
        float f4 = fArray[n + 3];
        float f5 = fArray[n + 4];
        float f6 = fArray[n + 5];
        if (fArray2 != null) {
            fArray2[n2 + 0] = f;
            fArray2[n2 + 1] = f2;
        }
        if (fArray3 != null) {
            fArray3[n3 + 4] = f5;
            fArray3[n3 + 5] = f6;
        }
        f = (f + f3) / 2.0f;
        f2 = (f2 + f4) / 2.0f;
        f5 = (f5 + f3) / 2.0f;
        f6 = (f6 + f4) / 2.0f;
        f3 = (f + f5) / 2.0f;
        f4 = (f2 + f6) / 2.0f;
        if (fArray2 != null) {
            fArray2[n2 + 2] = f;
            fArray2[n2 + 3] = f2;
            fArray2[n2 + 4] = f3;
            fArray2[n2 + 5] = f4;
        }
        if (fArray3 != null) {
            fArray3[n3 + 0] = f3;
            fArray3[n3 + 1] = f4;
            fArray3[n3 + 2] = f5;
            fArray3[n3 + 3] = f6;
        }
    }

    static void subdivideQuadAt(float f, float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        float f2 = fArray[n + 0];
        float f3 = fArray[n + 1];
        float f4 = fArray[n + 2];
        float f5 = fArray[n + 3];
        float f6 = fArray[n + 4];
        float f7 = fArray[n + 5];
        if (fArray2 != null) {
            fArray2[n2 + 0] = f2;
            fArray2[n2 + 1] = f3;
        }
        if (fArray3 != null) {
            fArray3[n3 + 4] = f6;
            fArray3[n3 + 5] = f7;
        }
        f2 += f * (f4 - f2);
        f3 += f * (f5 - f3);
        f6 = f4 + f * (f6 - f4);
        f7 = f5 + f * (f7 - f5);
        f4 = f2 + f * (f6 - f2);
        f5 = f3 + f * (f7 - f3);
        if (fArray2 != null) {
            fArray2[n2 + 2] = f2;
            fArray2[n2 + 3] = f3;
            fArray2[n2 + 4] = f4;
            fArray2[n2 + 5] = f5;
        }
        if (fArray3 != null) {
            fArray3[n3 + 0] = f4;
            fArray3[n3 + 1] = f5;
            fArray3[n3 + 2] = f6;
            fArray3[n3 + 3] = f7;
        }
    }

    static void subdivideAt(float f, float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3, int n4) {
        switch (n4) {
            case 8: {
                Helpers.subdivideCubicAt(f, fArray, n, fArray2, n2, fArray3, n3);
                break;
            }
            case 6: {
                Helpers.subdivideQuadAt(f, fArray, n, fArray2, n2, fArray3, n3);
            }
        }
    }
}

