/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.Prepared;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.log.LogFile;
import org.h2.log.LogSystem;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.store.DiskFile;
import org.h2.store.FileLister;
import org.h2.store.PageStore;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.ObjectArray;

public class BackupCommand
extends Prepared {
    private Expression fileName;

    public BackupCommand(Session session) {
        super(session);
    }

    public void setFileName(Expression expression) {
        this.fileName = expression;
    }

    public int update() throws SQLException {
        String string = this.fileName.getValue(this.session).getString();
        this.session.getUser().checkAdmin();
        this.backupTo(string);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String string) throws SQLException {
        Database database = this.session.getDatabase();
        if (!database.isPersistent()) {
            throw Message.getSQLException(90126);
        }
        try {
            String string2 = database.getName();
            string2 = FileUtils.getFileName(string2);
            OutputStream outputStream = FileUtils.openFileOutputStream(string, false);
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            LogSystem logSystem = database.getLog();
            try {
                logSystem.flush();
                logSystem.updateKeepFiles(1);
                String string3 = database.getName() + ".data.db";
                this.backupDiskFile(zipOutputStream, string3, database.getDataFile());
                string3 = database.getName() + ".index.db";
                this.backupDiskFile(zipOutputStream, string3, database.getIndexFile());
                if (SysProperties.PAGE_STORE) {
                    string3 = database.getName() + ".h2.db";
                    this.backupPageStore(zipOutputStream, string3, database.getPageStore());
                }
                ObjectArray objectArray = logSystem.getActiveLogFiles();
                int n = objectArray.size();
                String string4 = FileUtils.getParent(string3);
                Object object = database.getLobSyncObject();
                synchronized (object) {
                    Object object2;
                    for (int i = 0; i < objectArray.size(); ++i) {
                        object2 = (LogFile)objectArray.get(i);
                        string3 = ((LogFile)object2).getFileName();
                        this.backupFile(zipOutputStream, string4, string3);
                        database.setProgress(3, string2, i, n);
                    }
                    String string5 = database.getDatabasePath();
                    object2 = FileUtils.getParent(string5);
                    ArrayList arrayList = FileLister.getDatabaseFiles((String)object2, string2, true);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        string3 = (String)arrayList.get(i);
                        if (!string3.endsWith(".lob.db")) continue;
                        this.backupFile(zipOutputStream, string4, string3);
                    }
                }
                zipOutputStream.close();
                outputStream.close();
            }
            finally {
                logSystem.updateKeepFiles(-1);
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, string);
        }
    }

    private void backupPageStore(ZipOutputStream zipOutputStream, String string, PageStore pageStore) throws SQLException, IOException {
        Database database = this.session.getDatabase();
        string = FileUtils.getFileName(string);
        zipOutputStream.putNextEntry(new ZipEntry(string));
        int n = pageStore.getPageCount();
        int n2 = 0;
        while ((n2 = pageStore.copyDirect(n2, zipOutputStream)) >= 0) {
            database.setProgress(3, string, n2, n);
        }
        zipOutputStream.closeEntry();
    }

    private void backupDiskFile(ZipOutputStream zipOutputStream, String string, DiskFile diskFile) throws SQLException, IOException {
        Database database = this.session.getDatabase();
        string = FileUtils.getFileName(string);
        zipOutputStream.putNextEntry(new ZipEntry(string));
        int n = -1;
        int n2 = diskFile.getReadCount();
        while ((n = diskFile.copyDirect(n, zipOutputStream)) >= 0) {
            database.setProgress(3, string, n, n2);
        }
        zipOutputStream.closeEntry();
    }

    private void backupFile(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        String string3 = FileUtils.getAbsolutePath(string2);
        if (!string3.startsWith(string = FileUtils.getAbsolutePath(string))) {
            Message.throwInternalError(string3 + " does not start with " + string);
        }
        string3 = string3.substring(string.length());
        string3 = BackupCommand.correctFileName(string3);
        zipOutputStream.putNextEntry(new ZipEntry(string3));
        InputStream inputStream = FileUtils.openFileInputStream(string2);
        IOUtils.copyAndCloseInput(inputStream, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    public boolean isTransactional() {
        return true;
    }

    public static String correctFileName(String string) {
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    public boolean needRecompile() {
        return false;
    }

    public LocalResult queryMeta() {
        return null;
    }
}

