/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferStrategy;
import java.awt.peer.WindowPeer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Window
extends Container
implements Accessible {
    private static final long serialVersionUID = 4497834738069338734L;
    private static transient long next_window_number;
    private String warningString;
    private int windowSerializedDataVersion;
    private int state;
    private boolean focusableWindowState;
    private transient Vector ownedWindows;
    private transient WindowListener windowListener;
    private transient WindowFocusListener windowFocusListener;
    private transient WindowStateListener windowStateListener;
    private transient GraphicsConfiguration graphicsConfiguration;
    private transient boolean shown;
    transient Component windowFocusOwner;
    static /* synthetic */ Class class$java$awt$event$WindowListener;
    static /* synthetic */ Class class$java$awt$event$WindowFocusListener;
    static /* synthetic */ Class class$java$awt$event$WindowStateListener;

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        return super.getGraphicsConfigurationImpl();
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createWindow(this);
        }
        super.addNotify();
    }

    public void pack() {
        if (this.parent != null && !this.parent.isDisplayable()) {
            this.parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void show() {
        var1_1 = this.getTreeLock();
        synchronized (var1_1) {
            block13: {
                block12: {
                    block11: {
                        if (this.parent != null && !this.parent.isDisplayable()) {
                            this.parent.addNotify();
                        }
                        if (this.peer == null) {
                            this.addNotify();
                        }
                        this.validate();
                        if (!this.visible) break block11;
                        this.toFront();
                        break block12;
                    }
                    super.show();
                    var3_2 = this.ownedWindows.iterator();
                    break block13;
                }
                var3_2 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                var3_2.setGlobalFocusedWindow(this);
                if (!this.shown) {
                    var4_3 = this.getFocusTraversalPolicy();
                    var5_4 = null;
                    if (var4_3 != null) {
                        var5_4 = var4_3.getInitialComponent(this);
                    }
                    if (var5_4 != null) {
                        var5_4.requestFocusInWindow();
                    }
                    this.shown = true;
                }
                return;
lbl31:
                // 1 sources

                var4_3 = (Window)((Reference)var3_2.next()).get();
                if (var4_3 != null) {
                    if (var4_3.isVisible()) {
                        var4_3.getPeer().setVisible(true);
                    }
                } else {
                    var3_2.remove();
                }
            }
            if (var3_2.hasNext()) ** GOTO lbl31
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void hide() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Iterator iterator = this.ownedWindows.iterator();
            while (iterator.hasNext()) {
                Window window = (Window)((Reference)iterator.next()).get();
                if (window != null) {
                    if (!window.isVisible() || window.getPeer() == null) continue;
                    window.getPeer().setVisible(false);
                    continue;
                }
                iterator.remove();
            }
        }
        super.hide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        this.hide();
        var1_1 = this.getTreeLock();
        synchronized (var1_1) {
            var3_2 = this.ownedWindows.iterator();
            while (true) {
                block6: {
                    if (var3_2.hasNext()) break block6;
                    var4_4 = 0;
                    if (true) ** GOTO lbl23
                }
                var4_3 = (Window)((Reference)var3_2.next()).get();
                if (var4_3 != null) {
                    var4_3.dispose();
                    continue;
                }
                var3_2.remove();
            }
            do {
                this.component[var4_4].removeNotify();
                ++var4_4;
lbl23:
                // 2 sources

            } while (var4_4 < this.ncomponents);
            this.removeNotify();
            var4_5 = new WindowEvent(this, 202);
            this.getToolkit().getSystemEventQueue().postEvent(var4_5);
            return;
        }
    }

    public void toBack() {
        if (this.peer != null) {
            WindowPeer windowPeer = (WindowPeer)this.peer;
            windowPeer.toBack();
        }
    }

    public void toFront() {
        if (this.peer != null) {
            WindowPeer windowPeer = (WindowPeer)this.peer;
            windowPeer.toFront();
        }
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public Window getOwner() {
        return (Window)this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Window[] getOwnedWindows() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Window[] windowArray = new Window[this.ownedWindows.size()];
            Iterator iterator = this.ownedWindows.iterator();
            int n = 0;
            while (true) {
                if (!iterator.hasNext()) break;
                Window window = (Window)((Reference)iterator.next()).get();
                if (window != null) {
                    windowArray[n++] = window;
                    continue;
                }
                iterator.remove();
            }
            if (n == windowArray.length) return windowArray;
            Window[] windowArray2 = new Window[n];
            System.arraycopy(windowArray, 0, windowArray2, 0, n);
            return windowArray2;
        }
    }

    public synchronized void addWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.add(this.windowListener, windowListener);
    }

    public synchronized void removeWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, windowListener);
    }

    public synchronized WindowListener[] getWindowListeners() {
        Class clazz = class$java$awt$event$WindowListener;
        if (clazz == null) {
            clazz = class$java$awt$event$WindowListener = Window.class("[Ljava.awt.event.WindowListener;", false);
        }
        return (WindowListener[])AWTEventMulticaster.getListeners(this.windowListener, clazz);
    }

    public synchronized WindowFocusListener[] getWindowFocusListeners() {
        Class clazz = class$java$awt$event$WindowFocusListener;
        if (clazz == null) {
            clazz = class$java$awt$event$WindowFocusListener = Window.class("[Ljava.awt.event.WindowFocusListener;", false);
        }
        return (WindowFocusListener[])AWTEventMulticaster.getListeners(this.windowFocusListener, clazz);
    }

    public synchronized WindowStateListener[] getWindowStateListeners() {
        Class clazz = class$java$awt$event$WindowStateListener;
        if (clazz == null) {
            clazz = class$java$awt$event$WindowStateListener = Window.class("[Ljava.awt.event.WindowStateListener;", false);
        }
        return (WindowStateListener[])AWTEventMulticaster.getListeners(this.windowStateListener, clazz);
    }

    public void addWindowFocusListener(WindowFocusListener windowFocusListener) {
        this.windowFocusListener = AWTEventMulticaster.add(this.windowFocusListener, windowFocusListener);
    }

    public void addWindowStateListener(WindowStateListener windowStateListener) {
        this.windowStateListener = AWTEventMulticaster.add(this.windowStateListener, windowStateListener);
    }

    public void removeWindowFocusListener(WindowFocusListener windowFocusListener) {
        this.windowFocusListener = AWTEventMulticaster.remove(this.windowFocusListener, windowFocusListener);
    }

    public void removeWindowStateListener(WindowStateListener windowStateListener) {
        this.windowStateListener = AWTEventMulticaster.remove(this.windowStateListener, windowStateListener);
    }

    public EventListener[] getListeners(Class clazz) {
        Class clazz2 = class$java$awt$event$WindowListener;
        if (clazz2 == null) {
            clazz2 = class$java$awt$event$WindowListener = Window.class("[Ljava.awt.event.WindowListener;", false);
        }
        if (clazz == clazz2) {
            return this.getWindowListeners();
        }
        return super.getListeners(clazz);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 209 && aWTEvent.id >= 200 && (this.windowListener != null || this.windowFocusListener != null || this.windowStateListener != null || (this.eventMask & 0x40L) != 0L)) {
            this.processEvent(aWTEvent);
        } else if (aWTEvent.id == 101) {
            this.validate();
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            this.processWindowEvent((WindowEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        if (n == 207 || n == 208) {
            this.processWindowFocusEvent(windowEvent);
        } else if (n == 209) {
            this.processWindowStateEvent(windowEvent);
        } else if (this.windowListener != null) {
            switch (windowEvent.getID()) {
                case 205: {
                    this.windowListener.windowActivated(windowEvent);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(windowEvent);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(windowEvent);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(windowEvent);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(windowEvent);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(windowEvent);
                    break;
                }
                case 200: {
                    this.windowListener.windowOpened(windowEvent);
                    break;
                }
            }
        }
    }

    public boolean isActive() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        boolean bl = false;
        if (keyboardFocusManager.getActiveWindow() == this) {
            bl = true;
        }
        return bl;
    }

    public boolean isFocused() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        boolean bl = false;
        if (keyboardFocusManager.getFocusedWindow() == this) {
            bl = true;
        }
        return bl;
    }

    public Component getFocusOwner() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = keyboardFocusManager.getActiveWindow();
        if (window == this) {
            return keyboardFocusManager.getFocusOwner();
        }
        return null;
    }

    public Component getMostRecentFocusOwner() {
        return this.windowFocusOwner;
    }

    void setFocusOwner(Component component) {
        this.windowFocusOwner = component;
    }

    public boolean postEvent(Event event) {
        return this.handleEvent(event);
    }

    public boolean isShowing() {
        return this.isVisible();
    }

    public void setLocationRelativeTo(Component component) {
        int n = 0;
        int n2 = 0;
        if (component == null || !component.isShowing()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Point point = graphicsEnvironment.getCenterPoint();
            n = point.x - this.width / 2;
            n2 = point.y - this.height / 2;
        } else {
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            Dimension dimension = this.getToolkit().getScreenSize();
            n = component.getLocationOnScreen().x;
            n2 = component.getLocationOnScreen().y;
            if (n2 + n4 > dimension.height) {
                n = dimension.width / 2 - n <= 0 ? (n - this.width >= 0 ? (n -= this.width) : 0) : (n + n3 + this.width <= dimension.width ? (n += n3) : dimension.width - this.width);
                n2 = dimension.height - this.height;
            } else if (n3 > this.width || n4 > this.height) {
                n = n + this.width > dimension.width ? dimension.width - this.width : (n < 0 ? 0 : (n += (n3 - this.width) / 2));
                n2 += (n4 - this.height) / 2;
            } else {
                n = n + this.width > dimension.width ? dimension.width - this.width : (n < 0 || n - (this.width - n3) / 2 < 0 ? 0 : (n -= (this.width - n3) / 2));
                n2 = n2 - (this.height - n4) / 2 > 0 ? (n2 -= (this.height - n4) / 2) : 0;
            }
        }
        this.setLocation(n, n2);
    }

    public void createBufferStrategy(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Window.createBufferStrategy: number of buffers is less than one");
        }
        if (!this.isDisplayable()) {
            throw new IllegalStateException("Window.createBufferStrategy: window is not displayable");
        }
        BufferStrategy bufferStrategy = null;
        try {
            bufferStrategy = new WindowFlipBufferStrategy(n);
        }
        catch (AWTException aWTException) {}
        if (bufferStrategy == null) {
            bufferStrategy = new WindowBltBufferStrategy(n, true);
        }
        this.bufferStrategy = bufferStrategy;
    }

    public void createBufferStrategy(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n < 1) {
            throw new IllegalArgumentException("Window.createBufferStrategy: number of buffers is less than one");
        }
        if (bufferCapabilities == null) {
            throw new IllegalArgumentException("Window.createBufferStrategy: capabilities object is null");
        }
        this.bufferStrategy = bufferCapabilities.isPageFlipping() ? new WindowFlipBufferStrategy(n) : new WindowBltBufferStrategy(n, true);
    }

    public BufferStrategy getBufferStrategy() {
        return this.bufferStrategy;
    }

    public void applyResourceBundle(ResourceBundle resourceBundle) {
        throw new Error("Not implemented");
    }

    public void applyResourceBundle(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault(), ClassLoader.getSystemClassLoader());
        if (resourceBundle != null) {
            this.applyResourceBundle(resourceBundle);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTWindow();
        }
        return this.accessibleContext;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        if (this.peer != null) {
            return this.peer.getGraphicsConfiguration();
        }
        return null;
    }

    protected void processWindowFocusEvent(WindowEvent windowEvent) {
        if (this.windowFocusListener != null) {
            switch (windowEvent.getID()) {
                case 207: {
                    this.windowFocusListener.windowGainedFocus(windowEvent);
                    break;
                }
                case 208: {
                    this.windowFocusListener.windowLostFocus(windowEvent);
                    break;
                }
            }
        }
    }

    protected void processWindowStateEvent(WindowEvent windowEvent) {
        if (this.windowStateListener != null && windowEvent.getID() == 209) {
            this.windowStateListener.windowStateChanged(windowEvent);
        }
    }

    public final boolean isFocusableWindow() {
        if (!this.getFocusableWindowState()) {
            return false;
        }
        return this instanceof Dialog || this instanceof Frame;
    }

    public boolean getFocusableWindowState() {
        return this.focusableWindowState;
    }

    public void setFocusableWindowState(boolean bl) {
        this.focusableWindowState = bl;
    }

    String generateName() {
        return "win" + Window.getUniqueLong();
    }

    private static final synchronized long getUniqueLong() {
        return next_window_number++;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.warningString = null;
        this.windowSerializedDataVersion = 0;
        this.state = 0;
        this.focusableWindowState = true;
        this.ownedWindows = new Vector();
    }

    Window() {
        this.this();
        this.visible = false;
        this.focusCycleRoot = true;
        this.setLayout(new BorderLayout());
        this.addWindowFocusListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void windowGainedFocus(WindowEvent windowEvent) {
                block5: {
                    if (Window.this.windowFocusOwner != null) {
                        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                        EventQueue eventQueue2 = eventQueue;
                        synchronized (eventQueue2) {
                            block4: {
                                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                Component component = keyboardFocusManager.getGlobalPermanentFocusOwner();
                                if (component == null) break block4;
                                eventQueue.postEvent(new FocusEvent(component, 1005, false, Window.this.windowFocusOwner));
                                eventQueue.postEvent(new FocusEvent(Window.this.windowFocusOwner, 1004, false, component));
                                break block5;
                            }
                            eventQueue.postEvent(new FocusEvent(Window.this.windowFocusOwner, 1004, false));
                        }
                    }
                }
            }
        });
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
    }

    Window(GraphicsConfiguration graphicsConfiguration) {
        this();
        this.graphicsConfiguration = graphicsConfiguration;
    }

    public Window(Frame frame) {
        this(frame, frame.getGraphicsConfiguration());
    }

    public Window(Window window) {
        this(window, window.getGraphicsConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Window(Window window, GraphicsConfiguration graphicsConfiguration) {
        this();
        Object object = this.getTreeLock();
        synchronized (object) {
            if (window == null) {
                throw new IllegalArgumentException("owner must not be null");
            }
            this.parent = window;
            window.ownedWindows.add(new WeakReference(this));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !securityManager.checkTopLevelWindow(this)) {
            this.warningString = System.getProperty("awt.appletWarning");
        }
        if (graphicsConfiguration != null && graphicsConfiguration.getDevice().getType() != 0) {
            throw new IllegalArgumentException("gc must be from a screen device");
        }
        if (graphicsConfiguration == null) {
            this.graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            return;
        }
        this.graphicsConfiguration = graphicsConfiguration;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class WindowFlipBufferStrategy
    extends Component.FlipBufferStrategy {
        WindowFlipBufferStrategy(int n) throws AWTException {
            super(n, new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class WindowBltBufferStrategy
    extends Component.BltBufferStrategy {
        WindowBltBufferStrategy(int n, boolean bl) {
            super(n, new BufferCapabilities(new ImageCapabilities(bl), new ImageCapabilities(bl), BufferCapabilities.FlipContents.COPIED));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTWindow
    extends Container.AccessibleAWTContainer {
        private static final long serialVersionUID = 4215068635060671780L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.WINDOW;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Window.this.isActive()) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }

        protected AccessibleAWTWindow() {
        }
    }
}

