/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.text.FormatCharacterIterator;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

public class MessageFormat
extends Format {
    private static final long serialVersionUID = 6479157306784022952L;
    private String pattern;
    private Locale locale;
    private MessageFormatElement[] elements;
    private String leader;

    private static final int scanString(String string, int n, StringBuffer stringBuffer) {
        int n2 = string.length();
        stringBuffer.setLength(0);
        boolean bl = false;
        while (n < n2) {
            char c = string.charAt(n);
            if (bl) {
                if (c == '\'') {
                    bl = false;
                } else {
                    stringBuffer.append(c);
                }
            } else if (c == '\'' && n + 1 < n2 && string.charAt(n + 1) == '\'') {
                stringBuffer.append(c);
                ++n;
            } else if (c == '\'') {
                bl = true;
            } else {
                if (c == '{') break;
                stringBuffer.append(c);
            }
            ++n;
        }
        return n;
    }

    private static final int scanFormatElement(String string, int n, StringBuffer stringBuffer, char c) {
        int n2 = string.length();
        stringBuffer.setLength(0);
        int n3 = 1;
        boolean bl = false;
        while (n < n2) {
            char c2 = string.charAt(n);
            if (bl) {
                if (c2 == '\'') {
                    bl = false;
                }
            } else if (c2 == '\'' && n + 1 < n2 && string.charAt(n + 1) == '\'') {
                stringBuffer.append(c2);
                ++n;
            } else if (c2 == '\'') {
                bl = true;
            } else if (c2 == '{') {
                ++n3;
            } else if (c2 == '}' ? --n3 == 0 : c2 == c) break;
            stringBuffer.append(c2);
            ++n;
        }
        return n;
    }

    private static final int scanFormat(String string, int n, StringBuffer stringBuffer, Vector vector, Locale locale) {
        MessageFormatElement messageFormatElement = new MessageFormatElement();
        vector.addElement(messageFormatElement);
        int n2 = string.length();
        ++n;
        n = MessageFormat.scanFormatElement(string, n, stringBuffer, ',');
        try {
            messageFormatElement.argNumber = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            illegalArgumentException.initCause(numberFormatException);
            throw illegalArgumentException;
        }
        if (n < n2 && string.charAt(n) == ',') {
            n = MessageFormat.scanFormatElement(string, n + 1, stringBuffer, ',');
            messageFormatElement.type = stringBuffer.toString();
            if (n < n2 && string.charAt(n) == ',') {
                n = MessageFormat.scanFormatElement(string, n + 1, stringBuffer, '}');
                messageFormatElement.style = stringBuffer.toString();
            }
        }
        if (n >= n2 || string.charAt(n) != '}') {
            throw new IllegalArgumentException("Missing '}' at end of message format");
        }
        ++n;
        n = MessageFormat.scanString(string, n, stringBuffer);
        messageFormatElement.trailer = stringBuffer.toString();
        messageFormatElement.setLocale(locale);
        return n;
    }

    public void applyPattern(String string) {
        this.pattern = string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = MessageFormat.scanString(string, 0, stringBuffer);
        this.leader = stringBuffer.toString();
        Vector vector = new Vector();
        while (n < string.length()) {
            n = MessageFormat.scanFormat(string, n, stringBuffer, vector, this.locale);
        }
        this.elements = new MessageFormatElement[vector.size()];
        vector.copyInto(this.elements);
    }

    public Object clone() {
        MessageFormat messageFormat = (MessageFormat)super.clone();
        messageFormat.elements = (MessageFormatElement[])this.elements.clone();
        return messageFormat;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MessageFormat)) {
            return false;
        }
        MessageFormat messageFormat = (MessageFormat)object;
        boolean bl = false;
        if (this.pattern.equals(messageFormat.pattern) && this.locale.equals(messageFormat.locale)) {
            bl = true;
        }
        return bl;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        Object[] objectArray = (Object[])object;
        FormatCharacterIterator formatCharacterIterator = new FormatCharacterIterator();
        this.formatInternal(objectArray, new StringBuffer(), null, formatCharacterIterator);
        return formatCharacterIterator;
    }

    public static String format(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        return messageFormat.formatInternal(objectArray, stringBuffer, fieldPosition, null).toString();
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.formatInternal(objectArray, stringBuffer, fieldPosition, null);
    }

    private final StringBuffer formatInternal(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition, FormatCharacterIterator formatCharacterIterator) {
        stringBuffer.append(this.leader);
        if (formatCharacterIterator != null) {
            formatCharacterIterator.append(this.leader);
        }
        int n = 0;
        while (n < this.elements.length) {
            Serializable serializable;
            Object object = null;
            boolean bl = false;
            if (objectArray == null || this.elements[n].argNumber >= objectArray.length) {
                bl = true;
            } else {
                object = objectArray[this.elements[n].argNumber];
            }
            AttributedCharacterIterator attributedCharacterIterator = null;
            Format format = null;
            if (fieldPosition != null && n == fieldPosition.getField() && fieldPosition.getFieldAttribute() == Field.ARGUMENT) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            if (bl) {
                stringBuffer.append("{" + this.elements[n].argNumber + '}');
            } else if (this.elements[n].setFormat != null) {
                format = this.elements[n].setFormat;
            } else if (this.elements[n].format != null) {
                if (this.elements[n].formatClass != null && !this.elements[n].formatClass.isInstance(object)) {
                    throw new IllegalArgumentException("Wrong format class");
                }
                format = this.elements[n].format;
            } else if (object instanceof Number) {
                format = NumberFormat.getInstance(this.locale);
            } else if (object instanceof Date) {
                format = DateFormat.getTimeInstance(2, this.locale);
            } else {
                stringBuffer.append(object);
            }
            if (fieldPosition != null && fieldPosition.getField() == n && fieldPosition.getFieldAttribute() == Field.ARGUMENT) {
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            if (format != null) {
                if (format instanceof ChoiceFormat) {
                    serializable = new StringBuffer();
                    format.format(object, (StringBuffer)serializable, fieldPosition);
                    MessageFormat messageFormat = new MessageFormat();
                    messageFormat.setLocale(this.locale);
                    messageFormat.applyPattern(((StringBuffer)serializable).toString());
                    messageFormat.format(objectArray, stringBuffer, fieldPosition);
                } else if (formatCharacterIterator != null) {
                    attributedCharacterIterator = format.formatToCharacterIterator(object);
                } else {
                    format.format(object, stringBuffer, fieldPosition);
                }
                this.elements[n].format = format;
            }
            if (formatCharacterIterator != null) {
                serializable = new HashMap();
                int n2 = formatCharacterIterator.getEndIndex();
                ((HashMap)serializable).put(Field.ARGUMENT, new Integer(this.elements[n].argNumber));
                if (attributedCharacterIterator != null) {
                    formatCharacterIterator.append(attributedCharacterIterator);
                    formatCharacterIterator.addAttributes((HashMap)serializable, n2, formatCharacterIterator.getEndIndex());
                } else {
                    formatCharacterIterator.append(object.toString(), (HashMap)serializable);
                }
                formatCharacterIterator.append(this.elements[n].trailer);
            }
            stringBuffer.append(this.elements[n].trailer);
            ++n;
        }
        return stringBuffer;
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((Object[])object, stringBuffer, fieldPosition);
    }

    public Format[] getFormats() {
        Format[] formatArray = new Format[this.elements.length];
        int n = this.elements.length - 1;
        while (n >= 0) {
            formatArray[n] = this.elements[n].setFormat;
            --n;
        }
        return formatArray;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return this.pattern.hashCode() + this.locale.hashCode();
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        if (!string.startsWith(this.leader, n)) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        n += this.leader.length();
        Vector vector = new Vector(this.elements.length, 1);
        int n2 = 0;
        while (n2 < this.elements.length) {
            Format format = null;
            if (this.elements[n2].setFormat != null) {
                format = this.elements[n2].setFormat;
            } else if (this.elements[n2].format != null) {
                format = this.elements[n2].format;
            }
            Object[] objectArray = null;
            if (format instanceof ChoiceFormat) {
                ChoiceFormat choiceFormat = (ChoiceFormat)format;
                String[] stringArray = (String[])choiceFormat.getFormats();
                double[] dArray = choiceFormat.getLimits();
                MessageFormat messageFormat = new MessageFormat();
                messageFormat.setLocale(this.locale);
                ParsePosition parsePosition2 = new ParsePosition(n);
                int n3 = 0;
                while (objectArray == null && n3 < dArray.length) {
                    messageFormat.applyPattern(stringArray[n3]);
                    parsePosition2.setIndex(n);
                    objectArray = messageFormat.parse(string, parsePosition2);
                    ++n3;
                }
                if (objectArray != null) {
                    n = parsePosition2.getIndex();
                    objectArray = new Double(dArray[n3]);
                }
            } else if (format != null) {
                parsePosition.setIndex(n);
                objectArray = format.parseObject(string, parsePosition);
                if (objectArray != null) {
                    n = parsePosition.getIndex();
                }
            } else {
                int n4 = this.elements[n2].trailer.length() > 0 ? string.indexOf(this.elements[n2].trailer, n) : string.length();
                if (n4 == -1) {
                    parsePosition.setErrorIndex(n);
                    return null;
                }
                objectArray = string.substring(n, n4);
                n = n4;
            }
            if (objectArray == null || !string.startsWith(this.elements[n2].trailer, n)) {
                parsePosition.setErrorIndex(n);
                return null;
            }
            if (this.elements[n2].argNumber >= vector.size()) {
                vector.setSize(this.elements[n2].argNumber + 1);
            }
            vector.setElementAt(objectArray, this.elements[n2].argNumber);
            n += this.elements[n2].trailer.length();
            ++n2;
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object[] parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Object[] objectArray = this.parse(string, parsePosition);
        if (objectArray == null) {
            throw new ParseException("couldn't parse string", parsePosition.getErrorIndex());
        }
        return objectArray;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public void setFormat(int n, Format format) {
        this.elements[n].setFormat = format;
    }

    public void setFormats(Format[] formatArray) {
        if (formatArray.length < this.elements.length) {
            throw new IllegalArgumentException("Not enough format objects");
        }
        int n = Math.min(formatArray.length, this.elements.length);
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2].setFormat = formatArray[n2];
            ++n2;
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.elements != null) {
            int n = 0;
            while (n < this.elements.length) {
                this.elements[n].setLocale(locale);
                ++n;
            }
        }
    }

    public String toPattern() {
        return this.pattern;
    }

    public Format[] getFormatsByArgumentIndex() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elements.length) {
            if (this.elements[n2].argNumber > n) {
                n = this.elements[n2].argNumber;
            }
            ++n2;
        }
        Format[] formatArray = new Format[n];
        int n3 = 0;
        while (n3 < this.elements.length) {
            if (this.elements[n3].setFormat != null) {
                formatArray[this.elements[n3].argNumber] = this.elements[n3].setFormat;
            } else if (this.elements[n3].format != null) {
                formatArray[this.elements[n3].argNumber] = this.elements[n3].format;
            }
            ++n3;
        }
        return formatArray;
    }

    public void setFormatByArgumentIndex(int n, Format format) {
        int n2 = 0;
        while (n2 < this.elements.length) {
            if (this.elements[n2].argNumber == n) {
                this.elements[n2].setFormat = format;
            }
            ++n2;
        }
    }

    public void setFormatsByArgumentIndex(Format[] formatArray) {
        int n = 0;
        while (n < formatArray.length) {
            this.setFormatByArgumentIndex(n, formatArray[n]);
            ++n;
        }
    }

    private MessageFormat() {
    }

    public MessageFormat(String string) {
        this(string, Locale.getDefault());
    }

    public MessageFormat(String string, Locale locale) {
        this.locale = locale;
        this.applyPattern(string);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class MessageFormatElement {
        int argNumber;
        Format setFormat;
        Format format;
        Class formatClass;
        String type;
        String style;
        String trailer;
        static /* synthetic */ Class class$java$lang$Number;
        static /* synthetic */ Class class$java$util$Date;

        final void setLocale(Locale locale) {
            if (this.type != null) {
                if (this.type.equals("number")) {
                    Class clazz = class$java$lang$Number;
                    if (clazz == null) {
                        clazz = this.formatClass = (class$java$lang$Number = MessageFormatElement.class("[Ljava.lang.Number;", false));
                    }
                    if (this.style == null) {
                        this.format = NumberFormat.getInstance(locale);
                    } else if (this.style.equals("currency")) {
                        this.format = NumberFormat.getCurrencyInstance(locale);
                    } else if (this.style.equals("percent")) {
                        this.format = NumberFormat.getPercentInstance(locale);
                    } else if (this.style.equals("integer")) {
                        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
                        numberFormat.setMaximumFractionDigits(0);
                        numberFormat.setGroupingUsed(false);
                        this.format = numberFormat;
                    } else {
                        this.format = NumberFormat.getNumberInstance(locale);
                        DecimalFormat decimalFormat = (DecimalFormat)this.format;
                        decimalFormat.applyPattern(this.style);
                    }
                } else if (this.type.equals("time") || this.type.equals("date")) {
                    Class clazz = class$java$util$Date;
                    if (clazz == null) {
                        clazz = class$java$util$Date = MessageFormatElement.class("[Ljava.util.Date;", false);
                    }
                    this.formatClass = clazz;
                    int n = 2;
                    boolean bl = false;
                    if (this.style != null) {
                        if (this.style.equals("short")) {
                            n = 3;
                        } else if (this.style.equals("medium")) {
                            n = 2;
                        } else if (this.style.equals("long")) {
                            n = 1;
                        } else if (this.style.equals("full")) {
                            n = 0;
                        } else {
                            bl = true;
                        }
                    }
                    this.format = this.type.equals("time") ? DateFormat.getTimeInstance(n, locale) : DateFormat.getDateInstance(n, locale);
                    if (bl) {
                        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.format;
                        simpleDateFormat.applyPattern(this.style);
                    }
                } else if (this.type.equals("choice")) {
                    Class clazz = class$java$lang$Number;
                    if (clazz == null) {
                        clazz = this.formatClass = (class$java$lang$Number = MessageFormatElement.class("[Ljava.lang.Number;", false));
                    }
                    if (this.style == null) {
                        throw new IllegalArgumentException("style required for choice format");
                    }
                    this.format = new ChoiceFormat(this.style);
                }
            }
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        private MessageFormatElement() {
        }
    }

    public static class Field
    extends Format.Field {
        static final long serialVersionUID = 7899943957617360810L;
        public static final Field ARGUMENT = new Field("argument");

        protected Object readResolve() throws InvalidObjectException {
            if (this.getName().equals(ARGUMENT.getName())) {
                return ARGUMENT;
            }
            throw new InvalidObjectException("no such MessageFormat field called " + this.getName());
        }

        private Field() {
            super("");
        }

        protected Field(String string) {
            super(string);
        }
    }
}

