/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.midi;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.TMidiDevice;

public abstract class TSequencer
extends TMidiDevice
implements Sequencer {
    private static final float MPQ_BPM_FACTOR = 6.0E7f;
    private static final Sequencer.SyncMode[] EMPTY_SYNCMODE_ARRAY = new Sequencer.SyncMode[0];
    private boolean m_bRunning;
    private Sequence m_sequence;
    private Set m_metaListeners;
    private Set[] m_aControllerListeners;
    private float m_fNominalTempoInMPQ;
    private float m_fTempoFactor;
    private Collection m_masterSyncModes;
    private Collection m_slaveSyncModes;
    private Sequencer.SyncMode m_masterSyncMode;
    private Sequencer.SyncMode m_slaveSyncMode;
    private BitSet m_muteBitSet;
    private BitSet m_soloBitSet;
    private BitSet m_enabledBitSet;

    public void setSequence(Sequence sequence) throws InvalidMidiDataException {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSequence(Sequence): begin");
        }
        this.m_sequence = sequence;
        this.setTempoFactor(1.0f);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSequence(Sequence): end");
        }
    }

    public void setSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSequence(InputStream): begin");
        }
        Sequence sequence = MidiSystem.getSequence(inputStream);
        this.setSequence(sequence);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSequence(InputStream): end");
        }
    }

    public Sequence getSequence() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSequence(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSequence(): end");
        }
        return this.m_sequence;
    }

    public synchronized void start() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.start(): begin");
        }
        this.checkOpen();
        if (!this.isRunning()) {
            this.m_bRunning = true;
            this.startImpl();
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.start(): end");
        }
    }

    protected void startImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TSequencer.startImpl(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TSequencer.startImpl(): end");
        }
    }

    public synchronized void stop() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.stop(): begin");
        }
        this.checkOpen();
        if (this.isRunning()) {
            this.stopImpl();
            this.m_bRunning = false;
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.stop(): end");
        }
    }

    protected void stopImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TSequencer.stopImpl(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TSequencer.stopImpl(): end");
        }
    }

    public synchronized boolean isRunning() {
        return this.m_bRunning;
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer is not open");
        }
    }

    protected int getResolution() {
        Sequence sequence;
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getResolution(): begin");
        }
        int n = (sequence = this.getSequence()) != null ? sequence.getResolution() : 1;
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getResolution(): end");
        }
        return n;
    }

    protected void setRealTempo() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setRealTempo(): begin");
        }
        float f = this.getTempoInMPQ() / this.getTempoFactor();
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setRealTempo(): real tempo: " + f);
        }
        this.setTempoImpl(f);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setRealTempo(): end");
        }
    }

    public float getTempoInBPM() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoInBPM(): begin");
        }
        float f = 6.0E7f / this.getTempoInMPQ();
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoInBPM(): end");
        }
        return f;
    }

    public void setTempoInBPM(float f) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoInBPM(): begin");
        }
        float f2 = 6.0E7f / f;
        this.setTempoInMPQ(f2);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoInBPM(): end");
        }
    }

    public float getTempoInMPQ() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoInMPQ(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoInMPQ(): end");
        }
        return this.m_fNominalTempoInMPQ;
    }

    public void setTempoInMPQ(float f) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoInMPQ(): begin");
        }
        this.m_fNominalTempoInMPQ = f;
        this.setRealTempo();
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoInMPQ(): end");
        }
    }

    public void setTempoFactor(float f) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoFactor(): begin");
        }
        this.m_fTempoFactor = f;
        this.setRealTempo();
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setTempoFactor(): end");
        }
    }

    public float getTempoFactor() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoFactor(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTempoFactor(): end");
        }
        return this.m_fTempoFactor;
    }

    protected abstract void setTempoImpl(float var1);

    public long getTickLength() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTickLength(): begin");
        }
        long l = 0L;
        if (this.getSequence() != null) {
            l = this.getSequence().getTickLength();
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getTickLength(): end");
        }
        return l;
    }

    public long getMicrosecondLength() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMicrosecondLength(): begin");
        }
        long l = 0L;
        if (this.getSequence() != null) {
            l = this.getSequence().getMicrosecondLength();
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMicrosecondLength(): end");
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addMetaEventListener(MetaEventListener metaEventListener) {
        Set set = this.m_metaListeners;
        synchronized (set) {
            return this.m_metaListeners.add(metaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeMetaEventListener(MetaEventListener metaEventListener) {
        Set set = this.m_metaListeners;
        synchronized (set) {
            this.m_metaListeners.remove(metaEventListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Iterator getMetaEventListeners() {
        Set set = this.m_metaListeners;
        synchronized (set) {
            return this.m_metaListeners.iterator();
        }
    }

    protected void sendMetaMessage(MetaMessage metaMessage) {
        Iterator iterator = this.getMetaEventListeners();
        while (iterator.hasNext()) {
            MetaEventListener metaEventListener = (MetaEventListener)iterator.next();
            MetaMessage metaMessage2 = (MetaMessage)metaMessage.clone();
            metaEventListener.meta(metaMessage2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] addControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Set[] setArray = this.m_aControllerListeners;
        synchronized (this.m_aControllerListeners) {
            block6: {
                block5: {
                    if (nArray != null) break block5;
                    int n = 0;
                    while (n < 128) {
                        this.addControllerListener(n, controllerEventListener);
                        ++n;
                    }
                    break block6;
                }
                int n = 0;
                while (n < nArray.length) {
                    this.addControllerListener(nArray[n], controllerEventListener);
                    ++n;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.getListenedControllers(controllerEventListener);
        }
    }

    private final void addControllerListener(int n, ControllerEventListener controllerEventListener) {
        if (this.m_aControllerListeners[n] == null) {
            this.m_aControllerListeners[n] = new ArraySet();
        }
        this.m_aControllerListeners[n].add(controllerEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] removeControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Set[] setArray = this.m_aControllerListeners;
        synchronized (this.m_aControllerListeners) {
            block6: {
                block5: {
                    if (nArray != null) break block5;
                    int n = 0;
                    while (n < 128) {
                        this.removeControllerListener(n, controllerEventListener);
                        ++n;
                    }
                    break block6;
                }
                int n = 0;
                while (n < nArray.length) {
                    this.removeControllerListener(nArray[n], controllerEventListener);
                    ++n;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.getListenedControllers(controllerEventListener);
        }
    }

    private final void removeControllerListener(int n, ControllerEventListener controllerEventListener) {
        if (this.m_aControllerListeners[n] != null) {
            this.m_aControllerListeners[n].add(controllerEventListener);
        }
    }

    private final int[] getListenedControllers(ControllerEventListener controllerEventListener) {
        int[] nArray = new int[128];
        int n = 0;
        int n2 = 0;
        while (n2 < 128) {
            if (this.m_aControllerListeners[n2] != null && this.m_aControllerListeners[n2].contains(controllerEventListener)) {
                nArray[n] = n2;
                ++n;
            }
            ++n2;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    protected void sendControllerEvent(ShortMessage shortMessage) {
        int n = shortMessage.getData1();
        if (this.m_aControllerListeners[n] != null) {
            Iterator iterator = this.m_aControllerListeners[n].iterator();
            while (iterator.hasNext()) {
                ControllerEventListener controllerEventListener = (ControllerEventListener)iterator.next();
                ShortMessage shortMessage2 = (ShortMessage)shortMessage.clone();
                controllerEventListener.controlChange(shortMessage2);
            }
        }
    }

    protected void notifyListeners(MidiMessage midiMessage) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.sendToListeners(): begin");
        }
        if (midiMessage instanceof MetaMessage) {
            this.sendMetaMessage((MetaMessage)midiMessage);
        } else if (midiMessage instanceof ShortMessage && ((ShortMessage)midiMessage).getCommand() == 176) {
            this.sendControllerEvent((ShortMessage)midiMessage);
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.sendToListeners(): end");
        }
    }

    public Sequencer.SyncMode getMasterSyncMode() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMasterSyncMode(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMasterSyncMode(): end");
        }
        return this.m_masterSyncMode;
    }

    public void setMasterSyncMode(Sequencer.SyncMode syncMode) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setMasterSyncMode(): begin");
        }
        if (this.m_masterSyncModes.contains(syncMode)) {
            if (!this.getMasterSyncMode().equals(syncMode)) {
                this.m_masterSyncMode = syncMode;
                this.setMasterSyncModeImpl(syncMode);
            }
        } else {
            throw new IllegalArgumentException("sync mode not allowed: " + syncMode);
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setMasterSyncMode(): end");
        }
    }

    protected void setMasterSyncModeImpl(Sequencer.SyncMode syncMode) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setMasterSyncModeImpl(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setMasterSyncModeImpl(): end");
        }
    }

    public Sequencer.SyncMode[] getMasterSyncModes() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMasterSyncModes(): begin");
        }
        Sequencer.SyncMode[] syncModeArray = (Sequencer.SyncMode[])this.m_masterSyncModes.toArray(EMPTY_SYNCMODE_ARRAY);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getMasterSyncModes(): end");
        }
        return syncModeArray;
    }

    public Sequencer.SyncMode getSlaveSyncMode() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSlaveSyncMode(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSlaveSyncMode(): end");
        }
        return this.m_slaveSyncMode;
    }

    public void setSlaveSyncMode(Sequencer.SyncMode syncMode) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSlaveSyncMode(): begin");
        }
        if (this.m_slaveSyncModes.contains(syncMode)) {
            if (!this.getSlaveSyncMode().equals(syncMode)) {
                this.m_slaveSyncMode = syncMode;
                this.setSlaveSyncModeImpl(syncMode);
            }
        } else {
            throw new IllegalArgumentException("sync mode not allowed: " + syncMode);
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSlaveSyncMode(): end");
        }
    }

    protected void setSlaveSyncModeImpl(Sequencer.SyncMode syncMode) {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSlaveSyncModeImpl(): begin");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.setSlaveSyncModeImpl(): end");
        }
    }

    public Sequencer.SyncMode[] getSlaveSyncModes() {
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSlaveSyncModes(): begin");
        }
        Sequencer.SyncMode[] syncModeArray = (Sequencer.SyncMode[])this.m_slaveSyncModes.toArray(EMPTY_SYNCMODE_ARRAY);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.getSlaveSyncModes(): end");
        }
        return syncModeArray;
    }

    public boolean getTrackSolo(int n) {
        boolean bl = false;
        if (this.getSequence() != null && n < this.getSequence().getTracks().length) {
            bl = this.m_soloBitSet.get(n);
        }
        return bl;
    }

    public void setTrackSolo(int n, boolean bl) {
        boolean bl2;
        if (this.getSequence() != null && n < this.getSequence().getTracks().length && bl != (bl2 = this.m_soloBitSet.get(n))) {
            if (bl) {
                this.m_soloBitSet.set(n);
            } else {
                this.m_soloBitSet.clear(n);
            }
            this.updateEnabled();
            this.setTrackSoloImpl(n, bl);
        }
    }

    protected void setTrackSoloImpl(int n, boolean bl) {
    }

    public boolean getTrackMute(int n) {
        boolean bl = false;
        if (this.getSequence() != null && n < this.getSequence().getTracks().length) {
            bl = this.m_muteBitSet.get(n);
        }
        return bl;
    }

    public void setTrackMute(int n, boolean bl) {
        boolean bl2;
        if (this.getSequence() != null && n < this.getSequence().getTracks().length && bl != (bl2 = this.m_muteBitSet.get(n))) {
            if (bl) {
                this.m_muteBitSet.set(n);
            } else {
                this.m_muteBitSet.clear(n);
            }
            this.updateEnabled();
            this.setTrackMuteImpl(n, bl);
        }
    }

    protected void setTrackMuteImpl(int n, boolean bl) {
    }

    private final void updateEnabled() {
        int n;
        boolean bl;
        BitSet bitSet = (BitSet)this.m_enabledBitSet.clone();
        boolean bl2 = false;
        if (this.m_soloBitSet.length() > 0) {
            bl2 = true;
        }
        if (bl = bl2) {
            this.m_enabledBitSet = (BitSet)this.m_soloBitSet.clone();
        } else {
            n = 0;
            while (n < this.m_muteBitSet.size()) {
                if (this.m_muteBitSet.get(n)) {
                    this.m_enabledBitSet.clear(n);
                } else {
                    this.m_enabledBitSet.set(n);
                }
                ++n;
            }
        }
        bitSet.xor(this.m_enabledBitSet);
        n = 0;
        while (n < bitSet.size()) {
            if (bitSet.get(n)) {
                this.setTrackEnabledImpl(n, this.m_enabledBitSet.get(n));
            }
            ++n;
        }
    }

    protected void setTrackEnabledImpl(int n, boolean bl) {
    }

    protected boolean isTrackEnabled(int n) {
        return this.m_enabledBitSet.get(n);
    }

    public void setLatency(int n) {
    }

    public int getLatency() {
        return -1;
    }

    protected TSequencer(MidiDevice.Info info, Collection collection, Collection collection2) {
        super(info);
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.<init>(): begin");
        }
        this.m_bRunning = false;
        this.m_sequence = null;
        this.m_metaListeners = new ArraySet();
        this.m_aControllerListeners = new Set[128];
        this.setTempoInMPQ(500000.0f);
        this.setTempoFactor(1.0f);
        this.m_masterSyncModes = collection;
        this.m_slaveSyncModes = collection2;
        if (this.getMasterSyncModes().length > 0) {
            this.m_masterSyncMode = this.getMasterSyncModes()[0];
        }
        if (this.getSlaveSyncModes().length > 0) {
            this.m_slaveSyncMode = this.getSlaveSyncModes()[0];
        }
        this.m_muteBitSet = new BitSet();
        this.m_soloBitSet = new BitSet();
        this.m_enabledBitSet = new BitSet();
        this.updateEnabled();
        if (TDebug.TraceSequencer) {
            TDebug.out("TSequencer.<init>(): end");
        }
    }
}

