/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader;

import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class CompoundResource
implements Resource {
    private ResourceKey source;
    private DependencyCollector dependencies;
    private Object product;
    private static final long serialVersionUID = -5828242419391352185L;

    public CompoundResource(ResourceKey resourceKey, DependencyCollector dependencyCollector, Object object) {
        if (resourceKey == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (dependencyCollector == null) {
            throw new NullPointerException("Dependecies must be given.");
        }
        if (object == null) {
            throw new NullPointerException("Product must not be null");
        }
        this.source = resourceKey;
        try {
            this.dependencies = (DependencyCollector)dependencyCollector.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone not supported? This should not happen.");
        }
        this.product = object;
    }

    public Object getResource() throws ResourceException {
        return this.product;
    }

    public long getVersion(ResourceKey resourceKey) {
        return this.dependencies.getVersion(resourceKey);
    }

    public ResourceKey[] getDependencies() {
        return this.dependencies.getDependencies();
    }

    public ResourceKey getSource() {
        return this.source;
    }
}

