/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.raw;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.raw.RawResourceData;

public class RawResourceLoader
implements ResourceLoader {
    public boolean isSupportedKey(ResourceKey resourceKey) {
        return RawResourceLoader.class.getName().equals(resourceKey.getSchema());
    }

    public ResourceKey createKey(Object object, Map map) throws ResourceKeyCreationException {
        if (!(object instanceof byte[])) {
            return null;
        }
        return new ResourceKey(RawResourceLoader.class.getName(), object, map);
    }

    public ResourceKey deriveKey(ResourceKey resourceKey, String string, Map map) throws ResourceKeyCreationException {
        if (string != null) {
            throw new ResourceKeyCreationException("Unable to derive key for new path.");
        }
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        if (map == null) {
            return resourceKey;
        }
        HashMap hashMap = new HashMap();
        hashMap.putAll(resourceKey.getFactoryParameters());
        hashMap.putAll(map);
        return new ResourceKey(resourceKey.getSchema(), resourceKey.getIdentifier(), hashMap);
    }

    public URL toURL(ResourceKey resourceKey) {
        return null;
    }

    public ResourceData load(ResourceKey resourceKey) throws ResourceLoadingException {
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceLoadingException("The key type is not supported.");
        }
        return new RawResourceData(resourceKey);
    }
}

