/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.serializer.methods;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.serializer.SerializeMethod;

public class AttributedStringSerializer
implements SerializeMethod {
    public void writeObject(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        AttributedString attributedString = (AttributedString)object;
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        StringBuffer stringBuffer = new StringBuffer(100);
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            stringBuffer = stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        objectOutputStream.writeObject(stringBuffer.toString());
        c = attributedCharacterIterator.first();
        int n = attributedCharacterIterator.getBeginIndex();
        while (c != '\uffff') {
            objectOutputStream.writeChar(c);
            int n2 = attributedCharacterIterator.getRunLimit();
            objectOutputStream.writeInt(n2 - n);
            HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>(attributedCharacterIterator.getAttributes());
            objectOutputStream.writeObject(hashMap);
            c = attributedCharacterIterator.setIndex(n2);
        }
        objectOutputStream.writeChar(65535);
    }

    public Object readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = (String)objectInputStream.readObject();
        AttributedString attributedString = new AttributedString(string);
        char c = objectInputStream.readChar();
        int n = 0;
        while (c != '\uffff') {
            int n2 = objectInputStream.readInt();
            Map map = (Map)objectInputStream.readObject();
            attributedString.addAttributes(map, n, n2);
            n = n2;
            c = objectInputStream.readChar();
        }
        return attributedString;
    }

    public Class getObjectClass() {
        return AttributedString.class;
    }
}

