/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.versioning;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

public class VersionHelper {
    private String version;
    private String title;
    private String productId;
    private String releaseMilestone;
    private String releaseMinor;
    private String releaseMajor;
    private String releaseCandidateToken;
    private String releaseNumber;
    private String releaseBuildNumber;
    private ProjectInformation projectInformation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionHelper(ProjectInformation projectInformation) {
        if (projectInformation == null) {
            throw new NullPointerException();
        }
        this.projectInformation = projectInformation;
        ClassLoader classLoader = projectInformation.getClass().getClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = uRL.openStream();
                try {
                    if (!this.init(inputStream)) continue;
                    return;
                }
                finally {
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean init(InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        try {
            Manifest manifest = new Manifest(inputStream);
            Attributes attributes = this.getAttributes(manifest, this.projectInformation.getInternalName());
            String string = this.getValue(attributes, "Implementation-Title", null);
            if (!ObjectUtilities.equal(this.projectInformation.getInternalName(), string)) {
                return false;
            }
            this.title = string;
            this.releaseMajor = this.getValue(attributes, "Release-Major-Number", "0");
            this.releaseMinor = this.getValue(attributes, "Release-Minor-Number", "0");
            this.releaseMilestone = this.getValue(attributes, "Release-Milestone-Number", "0");
            this.releaseCandidateToken = this.getValue(attributes, "Release-Candidate-Token", "");
            this.releaseBuildNumber = this.getValue(attributes, "Release-Build-Number", "");
            this.releaseNumber = this.getValue(attributes, "Release-Number", "");
            if (this.releaseNumber.length() == 0) {
                this.releaseNumber = this.createReleaseVersion();
            }
            this.version = this.getValue(attributes, "Implementation-Version", "");
            if (this.version.length() == 0) {
                this.version = this.createVersion();
            }
            this.productId = this.getValue(attributes, "Implementation-Product-Id", "");
            if (this.productId.length() == 0) {
                this.productId = this.createProductId();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Attributes getAttributes(Manifest manifest, String string) {
        Attributes attributes = manifest.getAttributes(string);
        if (attributes == null) {
            return manifest.getMainAttributes();
        }
        return attributes;
    }

    private String getValue(Attributes attributes, String string, String string2) {
        String string3 = attributes.getValue(string);
        if (string3 == null) {
            return string2;
        }
        return string3.trim();
    }

    private String createProductId() {
        if (this.version.trim().length() == 0) {
            return this.title;
        }
        return this.title + '-' + this.version;
    }

    private String createVersion() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.releaseMajor);
        stringBuffer.append('.');
        stringBuffer.append(this.releaseMinor);
        stringBuffer.append('.');
        stringBuffer.append(this.releaseMilestone);
        return stringBuffer.toString();
    }

    private String createReleaseVersion() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.releaseMajor);
        stringBuffer.append('.');
        stringBuffer.append(this.releaseMinor);
        stringBuffer.append('.');
        stringBuffer.append(this.releaseMilestone);
        if (this.releaseCandidateToken.length() > 0) {
            stringBuffer.append('-');
            stringBuffer.append(this.releaseCandidateToken);
        }
        if (this.releaseBuildNumber.length() > 0) {
            stringBuffer.append(" (Build ");
            stringBuffer.append(this.releaseBuildNumber);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getReleaseMilestone() {
        return this.releaseMilestone;
    }

    public String getReleaseMinor() {
        return this.releaseMinor;
    }

    public String getReleaseMajor() {
        return this.releaseMajor;
    }

    public String getReleaseCandidateToken() {
        return this.releaseCandidateToken;
    }

    public String getReleaseNumber() {
        return this.releaseNumber;
    }

    public String getReleaseBuildNumber() {
        return this.releaseBuildNumber;
    }
}

