/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.HashNMap;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.function.DefaultFunctionDescription;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.FunctionCategory;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;

public class DefaultFunctionRegistry
implements FunctionRegistry {
    private static final Log logger = LogFactory.getLog(DefaultFunctionRegistry.class);
    private static final String FUNCTIONS_PREFIX = "org.pentaho.reporting.libraries.formula.functions.";
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final FunctionCategory[] EMPTY_CATEGORIES = new FunctionCategory[0];
    private FunctionCategory[] categories;
    private HashNMap categoryFunctions;
    private HashMap functions;
    private HashMap functionMetaData;
    private HashMap cachedFunctions = new HashMap();

    public DefaultFunctionRegistry() {
        this.categoryFunctions = new HashNMap();
        this.functionMetaData = new HashMap();
        this.functions = new HashMap();
        this.categories = EMPTY_CATEGORIES;
    }

    public FunctionCategory[] getCategories() {
        return (FunctionCategory[])this.categories.clone();
    }

    public Function[] getFunctions() {
        String[] stringArray = this.getFunctionNames();
        ArrayList<Function> arrayList = new ArrayList<Function>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Function function = this.createFunction(string);
            if (function == null) {
                logger.debug((Object)("There is no such function: " + string));
                continue;
            }
            arrayList.add(function);
        }
        return arrayList.toArray(new Function[arrayList.size()]);
    }

    public String[] getFunctionNames() {
        return this.functions.keySet().toArray(new String[this.functions.size()]);
    }

    public String[] getFunctionNamesByCategory(FunctionCategory functionCategory) {
        return (String[])this.categoryFunctions.toArray((Object)functionCategory, (Object[])EMPTY_ARRAY);
    }

    public Function[] getFunctionsByCategory(FunctionCategory functionCategory) {
        String[] stringArray = (String[])this.categoryFunctions.toArray((Object)functionCategory, (Object[])EMPTY_ARRAY);
        ArrayList<Function> arrayList = new ArrayList<Function>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Function function = this.createFunction(string);
            if (function == null) continue;
            arrayList.add(function);
        }
        return arrayList.toArray(new Function[arrayList.size()]);
    }

    public Function createFunction(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = (String)this.functions.get(string.toUpperCase());
        Class clazz = (Class)this.cachedFunctions.get(string2);
        if (clazz != null) {
            try {
                return (Function)clazz.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        Function function = (Function)ObjectUtilities.loadAndInstantiate((String)string2, DefaultFunctionRegistry.class, Function.class);
        if (function == null) {
            logger.debug((Object)("There is no such function: " + string));
        } else {
            this.cachedFunctions.put(string2, function.getClass());
        }
        return function;
    }

    public FunctionDescription getMetaData(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return (FunctionDescription)this.functionMetaData.get(string.toUpperCase());
    }

    public void initialize(Configuration configuration) {
        Iterator iterator = configuration.findPropertyKeys(FUNCTIONS_PREFIX);
        HashSet<FunctionCategory> hashSet = new HashSet<FunctionCategory>();
        while (iterator.hasNext()) {
            Object object;
            String string;
            String string2 = (String)iterator.next();
            if (!string2.endsWith(".class") || (string = configuration.getConfigProperty(string2)).length() == 0 || !((object = ObjectUtilities.loadAndInstantiate((String)string, DefaultFunctionRegistry.class, Function.class)) instanceof Function)) continue;
            Function function = (Function)object;
            int n = string2.length() - 6;
            String string3 = string2.substring(0, n) + ".description";
            String string4 = configuration.getConfigProperty(string3);
            Object object2 = ObjectUtilities.loadAndInstantiate((String)string4, DefaultFunctionRegistry.class, FunctionDescription.class);
            FunctionDescription functionDescription = !(object2 instanceof FunctionDescription) ? new DefaultFunctionDescription(function.getCanonicalName()) : (FunctionDescription)object2;
            FunctionCategory functionCategory = functionDescription.getCategory();
            this.categoryFunctions.add((Object)functionCategory, (Object)function.getCanonicalName());
            this.functionMetaData.put(function.getCanonicalName(), functionDescription);
            this.functions.put(function.getCanonicalName(), string);
            hashSet.add(functionCategory);
        }
        this.categories = hashSet.toArray(new FunctionCategory[hashSet.size()]);
    }
}

