/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.sql.Date;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.util.DateUtil;

public class DateFunction
implements Function {
    private static final long serialVersionUID = 4956151361696995668L;

    public String getCanonicalName() {
        return "DATE";
    }

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        if (parameterCallback.getParameterCount() != 3) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Number number = typeRegistry.convertToNumber(parameterCallback.getType(0), parameterCallback.getValue(0));
        Number number2 = typeRegistry.convertToNumber(parameterCallback.getType(1), parameterCallback.getValue(1));
        Number number3 = typeRegistry.convertToNumber(parameterCallback.getType(2), parameterCallback.getValue(2));
        if (number == null || number2 == null || number3 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        LocalizationContext localizationContext = formulaContext.getLocalizationContext();
        Date date = DateUtil.createDate(number.intValue(), number2.intValue(), number3.intValue(), localizationContext);
        return new TypeValuePair(DateTimeType.DATE_TYPE, date);
    }
}

