/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public abstract class AbstractNumericOperator
implements InfixOperator {
    protected static final Number ZERO = new BigDecimal(0);
    private static final long serialVersionUID = -1087959445157130705L;

    protected AbstractNumericOperator() {
    }

    public final TypeValuePair evaluate(FormulaContext formulaContext, TypeValuePair typeValuePair, TypeValuePair typeValuePair2) throws EvaluationException {
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        if (typeValuePair == null || typeValuePair2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        Object object = typeValuePair.getValue();
        Object object2 = typeValuePair2.getValue();
        if (object == null || object2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        Number number = AbstractNumericOperator.convertToNumber(typeRegistry, typeValuePair.getType(), object, ZERO);
        Number number2 = AbstractNumericOperator.convertToNumber(typeRegistry, typeValuePair2.getType(), object2, ZERO);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, this.evaluate(number, number2));
    }

    protected abstract Number evaluate(Number var1, Number var2) throws EvaluationException;

    private static Number convertToNumber(TypeRegistry typeRegistry, Type type, Object object, Number number) {
        if (object == null) {
            return number;
        }
        try {
            return typeRegistry.convertToNumber(type, object);
        }
        catch (EvaluationException evaluationException) {
            return number;
        }
    }
}

